<?php
get_header(); ?>
    <div id="primary" class="content">
        <main id="main" class="site-main">
            <?php
            $errorpage_id = get_option('page_for_404');
            if ($errorpage_id) :
                $query = new WP_Query(array('page_id' => $errorpage_id));
                while ($query->have_posts()) {
                    $query->the_post();
                    get_template_part('content', 'page');
                }
                wp_reset_postdata();
            else:?>
                <div class="error-404 not-found">
                    <div class="page-content">

                        <div class="error-image">
                            <img src="<?php echo get_theme_file_uri('assets/images/404/404.png') ?>" alt="<?php echo esc_attr__('404 Page not found', 'makbet') ?>">
                        </div>

                        <h3 class="error-title">
                            <?php esc_html_e("Oops! That page can't be found.", 'makbet'); ?>
                        </h3>

                        <p class="error-sub-title">
                            <?php esc_html_e("The page you are looking for doesn't exits or an other error occurred.", 'makbet'); ?>
                        </p>

                        <div class="button-wrapper elementor-button-bgEffect enable-effects-yes">
                            <a class="elementor-button elementor-button-link elementor-size-sm has-interacted" href="<?php echo esc_url(home_url('/')); ?>">
                                <span class="elementor-button-content-wrapper">
                                    <span class="elementor-button-icon"><i aria-hidden="true" class="makbet-icon-arrow-right-normal"></i></span>
                                    <span class="elementor-button-text"><?php esc_html_e('Back to homepage', 'makbet') ?></span>
                                </span>
                            </a>
                        </div>

                    </div><!-- .page-content -->
                </div><!-- .error-404 -->
            <?php endif; ?>
        </main><!-- #main -->
    </div><!-- #primary -->
<?php
get_footer();



