(function ($) {
    "use strict";

    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-brand.default', ($element) => {
            let addHandler = $('.makbet-swiper-wrapper', $element);
            if (addHandler.length > 0) {
                elementorFrontend.elementsHandler.addHandler(makbetSwiperBase, {
                    $element,
                });
            }

            $('.elementor-brand-image', $element).each(function () {
                const original = $(this);

                if (original.hasClass('cloned')) return;

                const clone = original.clone().addClass('cloned').css({
                    position: 'absolute',
                    top: 0,
                    left: 0,
                    width: '100%',
                    height: '100%',
                    opacity: 0,
                    visibility: 'hidden',
                    transform: 'translateY(-100%)',
                    transition: 'all 0.3s ease-in-out',
                    pointerEvents: 'none',
                    zIndex: 2
                });

                original.css({
                    transition: 'all 0.3s ease-in-out',
                    transform: 'translateY(0%)',
                    zIndex: 1
                });

                const wrapper = $('<div class="brand-hover-wrapper"></div>').css({
                    position: 'relative',
                    display: 'inline-block',
                    overflow: 'hidden'
                });

                original.wrap(wrapper);
                original.after(clone);

                const currentWrapper = original.parent();

                currentWrapper.hover(
                    function () {
                        clone.css({
                            opacity: 1,
                            visibility: 'visible',
                            transform: 'translateY(0%)'
                        });

                        original.css({
                            opacity: 0,
                            visibility: 'hidden',
                            transform: 'translateY(100%)'
                        });
                    },
                    function () {
                        clone.css({
                            opacity: 0,
                            visibility: 'hidden',
                            transform: 'translateY(-100%)'
                        });

                        original.css({
                            opacity: 1,
                            visibility: 'visible',
                            transform: 'translateY(0%)'
                        });
                    }
                );
            });
        });
    });
})(jQuery);
