(function ($) {
    "use strict";

    function splitTextIntoWordsAndDivLetters(element) {
        let text = $(element).text().trim();
        if (!text) return;

        let words = text.split(' ');
        let html = words.map((word, wordIndex) => {
            let lettersHTML = word.split('').map((letter) => {
                return `<div class="letter-class" style="
                    position: relative;
                    display: inline-block;
                    opacity: 0;
                    visibility: hidden;
                    transform: translate(20px, 0);
                    transition: transform 0.3s ease, opacity 0.3s ease;
                    will-change: transform, opacity;
                ">${letter}</div>`;
            }).join('');

            return `
                <div class="word-wrapper" style="position: relative;display: inline-block;" data-word-index="${wordIndex}">
                    ${lettersHTML}
                </div>
            `;
        }).join(' ');

        return html;
    }

    function animateLettersSequentially(wordWrappers, wordIndex = 0, letterIndex = 0) {
        if (wordIndex >= wordWrappers.length) return;

        const currentWord = wordWrappers[wordIndex];
        const letters = currentWord.querySelectorAll('.letter-class');

        if (letterIndex < letters.length) {
            const letter = letters[letterIndex];
            letter.style.opacity = '1';
            letter.style.visibility = 'visible';
            letter.style.transform = 'translate(0, 0)';

            setTimeout(() => {
                animateLettersSequentially(wordWrappers, wordIndex, letterIndex + 1);
            }, 50);
        } else {
            setTimeout(() => {
                animateLettersSequentially(wordWrappers, wordIndex + 1, 0);
            }, 150);
        }
    }

    function isInViewport(element) {
        let rect = element.getBoundingClientRect();
        return (
            rect.top < window.innerHeight &&
            rect.bottom >= 0
        );
    }

    function processIconBoxTitle($element) {
        const $widget = $element;
        if (!$widget.hasClass('title-effect-yes')) return;

        const $title = $widget.find('.elementor-icon-box-title').first();
        if (!$title.length || $title.hasClass('split-done')) return;

        const newHTML = splitTextIntoWordsAndDivLetters($title);
        $title.html(newHTML).addClass('split-done');

        const titleDOM = $title.get(0);
        if (titleDOM && isInViewport(titleDOM) && !titleDOM.classList.contains('words-visible')) {
            titleDOM.classList.add('words-visible');
            const wordWrappers = titleDOM.querySelectorAll('.word-wrapper');
            animateLettersSequentially(wordWrappers);
        }

        $(window).on('scroll resize', () => {
            if (titleDOM && isInViewport(titleDOM) && !titleDOM.classList.contains('words-visible')) {
                titleDOM.classList.add('words-visible');
                const wordWrappers = titleDOM.querySelectorAll('.word-wrapper');
                animateLettersSequentially(wordWrappers);
            }
        });
    }

    $(window).on('elementor/frontend/init', () => {
        const addHandler = ($element) => {
            processIconBoxTitle($element);
        }

        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-icon-box.default', addHandler);
    });

})(jQuery);
