(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/number-box.default', function ($element) {
            $element.find('svg.svg-gradient-text').each(function () {
                const svg = this;
                const text = svg.querySelector('text');
                if (!text) return;

                const bbox = text.getBBox();

                svg.setAttribute('width', bbox.width);
                svg.setAttribute('height', bbox.height);
                svg.setAttribute('viewBox', `0 0 ${bbox.width} ${bbox.height}`);
                text.setAttribute('y', -bbox.y);
            });
        });
    });
})(jQuery);
