(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-portfolio.default', function ($element) {

            let addHandler = $('.makbet-swiper-wrapper', $element);
            if (addHandler.length > 0) {
                elementorFrontend.elementsHandler.addHandler(makbetSwiperBase, {
                    $element,
                });
            }
            if ($('.portfolio-item-style-1', $element).length) {
                const section = $('.portfolio-item-style-1', $element || document);
                const items = section.find('.portfolio-inner');

                function handleScrollEffect() {
                    if (window.innerWidth <= 880) {
                        items.css({
                            transform: '',
                            opacity: '',
                            transition: '',
                        });
                        return;
                    }

                    items.each(function (i) {
                        const current = $(this);
                        const next = items.eq(i + 1);
                        if (!next.length) return;

                        const currentRect = current[0].getBoundingClientRect();
                        const nextRect = next[0].getBoundingClientRect();

                        const currentTop = currentRect.top;
                        const currentHeight = currentRect.height;
                        const triggerStart = currentTop + currentHeight * 0.5;
                        const triggerEnd = currentTop;

                        if (nextRect.top <= triggerStart && nextRect.top >= triggerEnd) {
                            const progress = 1 - (nextRect.top - triggerEnd) / (triggerStart - triggerEnd);
                            const scale = 1 - 0.12 * progress;
                            const opacity = 1 - progress;

                            current.css({
                                transform: `scale(${scale})`,
                                opacity: opacity,
                                transition: 'transform 0.1s linear, opacity 0.1s linear',
                            });
                        } else if (nextRect.top < triggerEnd) {
                            current.css({
                                transform: 'scale(0.88)',
                                opacity: 0,
                                transition: 'transform 0.2s ease, opacity 0.2s ease',
                            });
                        } else {
                            current.css({
                                transform: 'scale(1)',
                                opacity: 1,
                                transition: 'transform 0.2s ease, opacity 0.2s ease',
                            });
                        }
                    });
                }

                $(window).on('scroll resize', handleScrollEffect);
                handleScrollEffect();
            }
        });
    });
})(jQuery);