(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-post-grid.default', ($element) => {
            let addHandler = $('.makbet-swiper-wrapper', $element);
            if (addHandler.length > 0) {
                elementorFrontend.elementsHandler.addHandler(makbetSwiperBase, {
                    $element,
                });
            }

            const isLayout1 = $element.closest('.layout-post-list-widget').length > 0;

            if ($(window).width() > 1024) {
                $element.find('.elementor-posts-item > .post-style-list').removeClass('active');

                if (isLayout1) {
                    $element.find('.elementor-posts-item > .post-style-list').addClass('active');
                }

                const firstItem = $element.find('.elementor-posts-item').first();
                if (firstItem.length > 0) {
                    firstItem.find('.post-style-list').addClass('active');
                }

                $element.find('.elementor-posts-item').on('mouseenter', function () {
                    $element.find('.elementor-posts-item > .post-style-list').removeClass('active');
                    $(this).find('.post-style-list').addClass('active');
                });

                $element.find('.elementor-posts-item').on('mouseleave', function () {
                    $element.find('.elementor-posts-item > .post-style-list').removeClass('active');
                    firstItem.find('.post-style-list').addClass('active');
                });
            }

        });
    });
})(jQuery);

