(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-price-table.default', function ($element) {
            let $checkBox = $element.find('.toggle-checkbox');
            let $pricingToggle = $element.find('.pricing-toggle');

            $checkBox.on('change', function () {
                const isAnnual = this.checked;

                let $monthlyPrice = $element.find('.elementor-price-table__price-monthly');
                let $annualPrice = $element.find('.elementor-price-table__price-annual');
                let $monthlyFeatures = $element.find('.features-monthly');
                let $annualFeatures = $element.find('.features-annual');
                let $sharedButtons = $element.find('.pricing-button-shared');


                if (isAnnual) {
                    $monthlyPrice.hide();
                    $annualPrice.show();
                    $monthlyFeatures.hide();
                    $annualFeatures.show();
                    $pricingToggle.addClass('active');
                } else {
                    $monthlyPrice.show();
                    $annualPrice.hide();
                    $monthlyFeatures.show();
                    $annualFeatures.hide();
                    $pricingToggle.removeClass('active');
                }

                $sharedButtons.each(function () {
                    const $btn = $(this);
                    const href = isAnnual ? $btn.data('href-year') : $btn.data('href-month');
                    const label = isAnnual ? $btn.data('label-year') : $btn.data('label-month');

                    if (href) $btn.attr('href', href);
                    if (label) $btn.find('.pricing-button-text').text(label);
                });
            });

            $checkBox.each(function () {
                $(this).trigger('change');
            });

            const addHandler = ($element) => {
                elementorFrontend.elementsHandler.addHandler(makbetSwiperBase, {
                    $element,
                });
            };
            addHandler($element);
        });
    });
})(jQuery);