(function ($) {
    "use strict";

    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-slider-scrolling.default', ($scope) => {
            const $items = $('.scroll-layout-style-1 .elementor-slider-scrolling-item-wrapper, .scroll-layout-style-1 .elementor-slider-scrolling-item-wrapper-after');
            if ($items.length) {
                let currentActiveItem = $items.filter('.active')[0];
                if (!currentActiveItem) {
                    $items.first().addClass('active');
                    currentActiveItem = $items.first()[0];
                }
                $items.on('mouseover', function () {
                    if (currentActiveItem !== this) {
                        $items.removeClass('active');
                        $(this).addClass('active');
                        currentActiveItem = this;
                    }
                });
                $('.scroll-layout-style-1').on('mouseleave', function () {
                    $items.removeClass('active');
                    if ($items.first().length) {
                        $items.first().addClass('active');
                        currentActiveItem = $items.first()[0];
                    }
                });
            }
        });
    });
})(jQuery);
