(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-step.default', ($element) => {
            const stepItems = $element.find('.elementor-step-item');
            const stepWrap = $element.find('.elementor-step-wrapper');

            if (stepItems.length === 0 || stepWrap.length === 0) return;

            $element.find('svg.svg-gradient-text').each(function () {
                const svg = this;
                const text = svg.querySelector('text');
                if (!text) return;

                const bbox = text.getBBox();

                svg.setAttribute('width', bbox.width);
                svg.setAttribute('height', bbox.height);
                svg.setAttribute('viewBox', `0 0 ${bbox.width} ${bbox.height}`);
                text.setAttribute('y', -bbox.y);

                if (window.innerWidth > 568) {
                    const stepNumberWrapper = svg.closest('.step-number');
                    if (stepNumberWrapper) {
                        const textStyle = window.getComputedStyle(text);
                        const lineHeight = parseFloat(textStyle.lineHeight) || parseFloat(textStyle.fontSize);
                        stepNumberWrapper.style.width = `${lineHeight}px`;
                        stepNumberWrapper.style.height = `${bbox.width}px`;
                    }
                }
            });

            let scrollAttached = false;
            let ticking = false;

            function clamp(num, min, max) {
                return Math.max(min, Math.min(num, max));
            }

            function animateItemsByScroll() {
                const wrapperRect = stepWrap[0].getBoundingClientRect();
                const viewportHeight = window.innerHeight;
                const scrollY = window.scrollY || window.pageYOffset;
                const stepWrapTop = stepWrap.offset().top;
                const viewportCenter = viewportHeight / 2;

                stepItems.each((index, el) => {
                    const rotateTarget = parseFloat(el.dataset.rotate) || 0;

                    const itemStart = stepWrapTop + index / 1.5 * wrapperRect.top + (viewportCenter * -0.5);
                    const itemEnd = itemStart + viewportHeight * 0.5;

                    const scrollProgress = clamp(
                        (scrollY + viewportHeight - itemStart) / (itemEnd - itemStart),
                        0, 1
                    );

                    let translateY = 0;
                    let rotateZ = 0;

                    if (scrollProgress < 0.5) {
                        const phaseProgress = scrollProgress / 0.5;
                        const baseOffset = index <= 2 ? 170 : 170 + (index - 2) * 30;
                        translateY = (1 - phaseProgress) * -baseOffset;
                        rotateZ = 0;
                    } else {
                        const phaseProgress = (scrollProgress - 0.5) / 0.5;
                        translateY = 0;
                        rotateZ = phaseProgress * rotateTarget;
                    }

                    $(el).css({
                        transform: `translate3d(0px, ${translateY}vh, 0px) rotateZ(${rotateZ}deg)`,
                    });
                });
            }

            function onScroll() {
                if (window.innerWidth <= 1024) {
                    stepItems.css({ transform: 'none' });
                    return;
                }

                if (!ticking) {
                    window.requestAnimationFrame(() => {
                        animateItemsByScroll();
                        ticking = false;
                    });
                    ticking = true;
                }
            }

            function enableScrollEffect() {
                if (!scrollAttached) {
                    window.addEventListener('scroll', onScroll);
                    window.addEventListener('resize', onScroll);
                    scrollAttached = true;
                }
                onScroll();
            }

            function disableScrollEffect() {
                if (scrollAttached) {
                    window.removeEventListener('scroll', onScroll);
                    window.removeEventListener('resize', onScroll);
                    scrollAttached = false;
                }
                stepItems.css({ transform: 'none' });
            }

            function checkWindowSizeAndToggle() {
                if (window.innerWidth > 1024) {
                    enableScrollEffect();
                } else {
                    disableScrollEffect();
                }
            }

            checkWindowSizeAndToggle();
            window.addEventListener('resize', checkWindowSizeAndToggle);
        });
    });
})(jQuery);
