(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-testimonials.default', ($element) => {
            let addHandler = $('.makbet-swiper-wrapper', $element);
            let testimonialElem = $element.closest('.elementor-widget-makbet-testimonials'),
                testimonialSettings = testimonialElem.data('settings');

            if (addHandler.length > 0) {
                elementorFrontend.elementsHandler.addHandler(makbetSwiperBase, {
                    $element,
                });
            }

            if ($('.elementor-custom-swiper-pagination.testimonial-style-3', $element).length > 0) {
                let loopEnabled = testimonialSettings && testimonialSettings['infinite'] === 'no' ? false : true;

                $element.on("swiperInit", function (e, mainSwiper) {
                    if (!mainSwiper) {
                        return;
                    }

                    try {
                        let thumbSlider = new Swiper($element.find('.elementor-custom-swiper-pagination.testimonial-style-3')[0], {
                            slidesPerView: 3,
                            spaceBetween: 30,
                            centeredSlides: false,
                            loop: loopEnabled,
                            loopAdditionalSlides: 3,
                            watchSlidesProgress: true,
                            slideToClickedSlide: true,
                            direction: 'vertical',
                            autoplay: false
                        });

                        mainSwiper.controller = mainSwiper.controller || {};
                        thumbSlider.controller = thumbSlider.controller || {};
                        mainSwiper.controller.control = thumbSlider;
                        thumbSlider.controller.control = mainSwiper;

                        if (loopEnabled) {
                            mainSwiper.loopFix();
                            thumbSlider.loopFix();
                        }

                        $element.find('.elementor-custom-swiper-pagination.testimonial-style-3 .swiper-slide').off('click').on('click', function () {
                            let index = $(this).index();
                            mainSwiper.slideTo(index);
                        });

                        $element.find('.testimonial-info-wrapper').off('click').on('click', function () {
                            let index = $(this).closest('.swiper-slide').index();
                            thumbSlider.slideTo(index);
                        });
                    } catch (error) {}
                });
            }
        });
    });
})(jQuery);