(function ($) {
    'use strict';

    function addOutEffectToButtons($scope) {
        $('.elementor-widget-button', $scope).each(function () {
            const button = $(this).find('.elementor-button')[0];
            if (button) {
                button.addEventListener('mouseenter', () => {
                    button.classList.add('has-interacted');
                });

                button.addEventListener('focus', () => {
                    button.classList.add('has-interacted');
                });
            }
        });
    }

    $(document).ready(function () {
        addOutEffectToButtons(document);
    });

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/global', function ($scope) {
            addOutEffectToButtons($scope);
        });
    });

    (function () {
        function isInElementorEdit() {
            return typeof elementorFrontend !== 'undefined'
                && elementorFrontend.isEditMode
                && elementorFrontend.isEditMode();
        }

        function initScrollEffect(scrollContainer) {
            if (!scrollContainer || scrollContainer.dataset.effectAttached === 'true') return;

            scrollContainer.dataset.effectAttached = 'true';

            let targetX = 0;
            let targetY = 0;
            let currentX = 0;
            let currentY = 0;
            let animationFrame;

            let isVisible = true;
            let isActive = window.innerWidth > 568 || isInElementorEdit();

            window.addEventListener('resize', () => {
                isActive = window.innerWidth > 568 || isInElementorEdit();
            });

            function onMouseMove(e) {
                if (!isVisible || !isActive) return;
                const rect = scrollContainer.getBoundingClientRect();
                const centerX = rect.left + rect.width / 2;
                const centerY = rect.top + rect.height / 2;

                targetX = (e.clientX - centerX) * 0.025;
                targetY = (e.clientY - centerY) * 0.025;

                if (!animationFrame) animate();
            }

            function animate() {
                const ease = 0.05;
                currentX += (targetX - currentX) * ease;
                currentY += (targetY - currentY) * ease;

                scrollContainer.style.transform = `translateX(${currentX}px) translateY(${currentY}px)`;

                if (Math.abs(targetX - currentX) > 0.1 || Math.abs(targetY - currentY) > 0.1) {
                    animationFrame = requestAnimationFrame(animate);
                } else {
                    animationFrame = null;
                }
            }

            window.addEventListener('mousemove', onMouseMove);
        }

        function scanAndInitAll() {
            const containers = document.querySelectorAll('.scroll-container');
            containers.forEach(initScrollEffect);
        }

        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', scanAndInitAll);
        } else {
            scanAndInitAll();
        }

        if (typeof elementorFrontend !== 'undefined') {
            jQuery(window).on('elementor/frontend/init', () => {
                elementorFrontend.hooks.addAction('frontend/element_ready/global', function ($scope) {
                    const el = $scope[0].querySelector('.scroll-container');
                    if (el) initScrollEffect(el);
                });
            });
        }
    })();



})(jQuery);
