!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("three")):"function"==typeof define&&define.amd?define(["exports","three"],e):e((t=t||self).PANOLENS={},t.THREE)}(this,function(t,X){"use strict";var e="0.11.0",i={"@tweenjs/tween.js":"^17.4.0",ava:"^2.1.0","browser-env":"^3.2.6",concurrently:"^4.1.0",coveralls:"^3.0.4",docdash:"^1.1.1",eslint:"^5.16.0","google-closure-compiler":"^20190528.0.0","http-server":"^0.11.1",jsdoc:"^3.6.2",nyc:"^14.1.1",rollup:"^1.15.1","rollup-plugin-commonjs":"^10.0.0","rollup-plugin-inject":"^2.2.0","rollup-plugin-json":"^4.0.0","rollup-plugin-node-resolve":"^5.0.1",three:"^0.105.2",xmlhttprequest:"^1.8.0"},e=e.split(".")[1],n=i.three.split(".")[1],i=i.three.replace(/[^0-9.]/g,"");const a={ORBIT:0,DEVICEORIENTATION:1},m={UNKNOWN:0,NORMAL:1,CARDBOARD:2,STEREO:3},r={TAB:0,SBS:1},p={Info:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAABAAAAAQADq8/hgAAADBklEQVR42u2bP08UQRiHnzFaSYCI/xoksdBIqGwIiYWRUBISExpCQ0ej38FWOmlIKKhoMPEbaCxsrrHiYrQgOSlQEaICrT+LHSPZzNzt3s3c3Hn7lHvLzvv82L2dm30XKioqKgYY062BJF0HpoA7wARwBbhsPz4DjoEG8AnYNcZ8Sx1Op8IXJM1KWpdUV3nq9m9nJV1I7VNGfEzSM0mNNqR9NOwxx1L7NRMflbQm6SSgeJ4TO8Zoat+8/LKkg4jieQ4kLaf2RtKwpJ0uiufZkTScSn5S0l5C+b/sSZrstvyMpKPU5uc4kjTTjkvpeYCkaeA1/+7hvcIZMGuMqUULQNIU8Aa4ltrWwyHwyBizGzwASSPAe+B2assW7AH3jTE/i+xcZoa12Qfy2Bo3i+5cKABl99zF1GYlWFTBeULLS0DZrOsDcDNggTXgc27bLWA64BhfgHvGmB8dHUXZ1DM0S45xliKMs9bKr+klIOkqsBrwv9JtVq1DewEAT4Ch1BYdMGQdygeg7Df4SmqDAKyoyXpCszPgITCeuvoAjFuX0gE8jljUdv7bCtiOOJ7XpdUZ8L/gdXHOA5QtYH5NXXVgbrgWWn1nwFTqaiPgdPIFcDd1tRFwOl307DwRuZgXwLvctgfA04hjOp18AcReZ6sZY16e3yDpUuQxnU6+S2AkcjEpcDr1zxOXSPgCKLSa0mc4nXwB/EpdbQScTr4AGqmrjYDTyRfAx9TVRsDp5Aug8LJyH+F0cgZg58z11BUHpO5ruGh2G3ybuuqAeF2aBfAqddUB8bq0OgP2U1cegH3aOQOMMb+BrdTVB2DLupQLwLIOnKY26IBT6+ClaQDGmO/ARmqLDtiwDn7HVkcY+EdjNoTlCI+tYhO2iUppm6HKslPUq2qQKHpUe8AFsjaUXuUQWCgqXyoAG8IuME/WkNRrnAHzZfqDSgdgQ6gBc2Td3b3CMTBXtkOsIzTIjZLnQhjcVtlcEIPZLJ0LoVvt8s/Va+3yuSAG84UJRxB98cpM9dJURUVFxSDzBxKde4Lk3/h2AAAAAElFTkSuQmCC",Arrow:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAABAAAAAQADq8/hgAAADPklEQVR42u2bMUscQRiG30/SRaJEI1ZKUiRErNIELRUbQYSAnX8hpVUgkDYp0wgWVjYW+QcJaQzYpLojJIXhtDDEKBpj65ti58ixmdmb2ZvZ7+T2AUHudmfmeXf2bnb3O6CmpqZmgJGqOiI5AWAWwEMA0wDuArht3r4CcAagBeAbgIaI/NQOp1fhIZKLJN+SbDKcptl3keSQtk+I+BjJVyRbJaRdtEybY9p+ReKjJN+QvIwonufS9DGq7ZuXXyd5nFA8zzHJdW1vkLxDcrdC8Ty7JO9oyc+QPFCUb3NAcqZq+TmSp9rmHZySnCvjErwOIPkUwHv8+w7vF64ALIrIfrIASM4C+ADgnratgxMACyLSiB4AyREAnwE80LbswgGAJyJy4bNxyApr6wbIw4xxy3djrwCYfeeuaZsFsEbPdULXU4DZqusLgMkEA21P05EEbf8A8FhEzos28pkBLxLKL5s/r/M1kEkz9vKQHGeatf05yfmOfubNa7G5JDle5NhtBjwHMBz5yFwAWBaRT+0XzP8pZsKwcQiH2fX8Ycojb+kzxUw4ZJn7CSQXqpRPHMKCq7+iZJ71Mvdy/DftXSQ6HcJdSDaqPPKW/mPOBO+lcbvzCU35RCFM2PpwnQKzZQfdgfe0dxH5dLA6uQJ4pC2fIASrkyuA6X6QjxyC1ckVQNn7bNHlI4ZgdXIFUObiJJl8pBCsTjGfuIwA2Cv4FN7xbYjkjqsRAHuIePXoCiDF1Zk2VidXAL+1R5sAq5MrgJb2aBNgdXIF8FV7tAmwOrkCCFs73wysTtYATHFCU3vEEWm6Ci6KvgY/ao86Ik6XogDeaY86Ik6XbjPgSHvkEThCwQy45XpDRK5JbgN4GWkgUyR9H65MRQxgW0SunZ5FezK7pfwd8e8MV8UfAPdF5Jdrg8JrAbPjprZFD2wWyQP6j8ZSEufRmGlgQ9umBBvd5IOgbjFUKLu+XnWBhG+rpsFVZGUo/coJgFVf+aAATAgNACvICpL6jSsAKyH1QcEBmBD2ASwhq+7uF84ALIVWiPUEB7lQsiOEwS2VzQUxmMXSuRCqKpd/zX4rl88FMZg/mLAEcSN+MlP/aKqmpqZmkPkL0hSjwOpNKxwAAAAASUVORK5CYII=",FullscreenEnter:"data:image/svg+xml;base64,PHN2ZyBmaWxsPSIjRkZGRkZGIiBoZWlnaHQ9IjI0IiB2aWV3Qm94PSIwIDAgMjQgMjQiIHdpZHRoPSIyNCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICAgIDxwYXRoIGQ9Ik0wIDBoMjR2MjRIMHoiIGZpbGw9Im5vbmUiLz4KICAgIDxwYXRoIGQ9Ik03IDE0SDV2NWg1di0ySDd2LTN6bS0yLTRoMlY3aDNWNUg1djV6bTEyIDdoLTN2Mmg1di01aC0ydjN6TTE0IDV2MmgzdjNoMlY1aC01eiIvPgo8L3N2Zz4=",FullscreenLeave:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgdmVyc2lvbj0iMS4xIiB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggc3R5bGU9ImZpbGw6I2ZmZiIgZD0iTTE0LDE0SDE5VjE2SDE2VjE5SDE0VjE0TTUsMTRIMTBWMTlIOFYxNkg1VjE0TTgsNUgxMFYxMEg1VjhIOFY1TTE5LDhWMTBIMTRWNUgxNlY4SDE5WiIgLz48L3N2Zz4=",VideoPlay:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgdmVyc2lvbj0iMS4xIiB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggc3R5bGU9ImZpbGw6I2ZmZiIgZD0iTTgsNS4xNFYxOS4xNEwxOSwxMi4xNEw4LDUuMTRaIiAvPjwvc3ZnPg==",VideoPause:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgdmVyc2lvbj0iMS4xIiB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggc3R5bGU9ImZpbGw6I2ZmZiIgZD0iTTE0LDE5LjE0SDE4VjUuMTRIMTRNNiwxOS4xNEgxMFY1LjE0SDZWMTkuMTRaIiAvPjwvc3ZnPg==",WhiteTile:"data:image/png;base64,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",Setting:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAABAAAAAQADq8/hgAAADn0lEQVR42u2bzUsVURjGnyO6CPzAMnTjppAo3LTwH1CqTfaxbeOiRS37A0wXtROFVi1aRBs3LWohSIGbQAQXViBGRhG0UIRKUCpK7q/FnOB2uc6cOXNmRnGe3eW+H8/7zLln3vNxpQoVKlQ4wjBFJAFOSRqX1O7osivpvjHmU1nChBZglvSYLYJbS0EanCvIJzWK+gnsyH34/8OuMaYjb265jwCgz6N4SWq3vodbAEmnS/KtBDgoAgyU5BteAOAkMAPcBroc7PskDWfgN+wyDwBdltMMcDI3tYBnde/pHeARMNTErgd4APzweP834oeN1dMkz5DlsFNn/yyv4kdiSK4At4AO4CqwGaDwRmza2B0210qM7YhrXU59ANAq6bWkwQTTn5KO5fIE0uVYlXTeGLOXFMx1DrjlULwKKN41x6DlnIjEEQCckPRe0okCiguJr5LOGGO+xhm5jICJQ1i8LOeJJKPYEQAMKvrtt5ZdjSf2FM0Fq/sZJI2A6UNcvCz36TiDfUcAcE1SPu/U6Mm8k/TFfu6XdFb5iX3dGPM8lQfwNod3+TowBnQ3yddtv1vPIe+b1JIBiwEJ1IAJ208k5W21trWA+V/5CHAcmAtU/A2P/DcCiTAHHE8tgCVhgLvAXgYCk17Jo/yTGfLuWe7Zd72AC8CWB4n3OAz7mLytNkZabAEXMhfeQKYfWEpJZCxA3rGUOZeA/qDF15FpAz47EvlNk9neI2e3jeWCz0BbmvipNkSMMX8kuSZYM8Z8zyqAjbHmaN5mOeYjgIXrU93MWrxHrNQjrqiDkQMLHwG+OdqF3NN3jeXKzU8AoF1SzdH8XKhJUO7HZDXLMbwAwICkJUULFxe0SbqSVQAbw3Xi7Ze0ZLmGAzAKbHs0JGU1QtvAaIjCW4B7ZOvJy2qFa5a730RPtBiaz0CgnkiZi6F5fBZDVMvho7EhcuS3xJJ2hV9IupgTqaLw0hhzab8vq23xOG/r+LDsKjLgYVzxUnU0ltwK2wDezUyJmEwqXgp/PL4rvxthaeCSI+zxuA10J8ZkWdJNSb2SLkvayKHwDRu71+ZajrG941J8agALDQ3GU/a/IvMkYCPzmCbtLNEVmacNtgs5iP9fYVNEV1Q6Hez7yNZSL+J2SarTcpqiyV2iUkG0IvPFvbz5FbEn+KEk3wMjwMeSfCsBXFBdly9CAPk9ydyffpECuB5tZfVJjaKWueOSfinln6YK4lahQoUKRxd/AcRPGTcQCAUQAAAAAElFTkSuQmCC",ChevronRight:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgdmVyc2lvbj0iMS4xIiB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZD0iTTguNTksMTYuNThMMTMuMTcsMTJMOC41OSw3LjQxTDEwLDZMMTYsMTJMMTAsMThMOC41OSwxNi41OFoiIC8+PC9zdmc+",Check:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgdmVyc2lvbj0iMS4xIiB3aWR0aD0iMjQiIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZD0iTTIxLDdMOSwxOUwzLjUsMTMuNUw0LjkxLDEyLjA5TDksMTYuMTdMMTkuNTksNS41OUwyMSw3WiIgLz48L3N2Zz4=",ViewIndicator:"data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPCFET0NUWVBFIHN2ZyBQVUJMSUMgIi0vL1czQy8vRFREIFNWRyAxLjEvL0VOIiAiaHR0cDovL3d3dy53My5vcmcvR3JhcGhpY3MvU1ZHLzEuMS9EVEQvc3ZnMTEuZHRkIj4KPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiBpZD0idmlldy1pbmRpY2F0b3IiIGhlaWdodD0iMzAiIHdpZHRoPSIzMCIgdmlld0JveD0iLTIuNSAtMSAzMCAzMCI+Cgk8c3R5bGUgdHlwZT0idGV4dC9jc3MiPi5zdDB7c3Ryb2tlLXdpZHRoOjI7c3Ryb2tlLW1pdGVybGltaXQ6MTA7ZmlsbDpub25lO30uc3Qxe3N0cm9rZS13aWR0aDo2O3N0cm9rZS1taXRlcmxpbWl0OjEwO30KCTwvc3R5bGU+Cgk8Zz4KCQk8cGF0aCBjbGFzcz0ic3QwIiBkPSJNIDEyLjUgMCBBIDEyLjUgMTIuNSAwIDAgMCAtMTIuNSAwIEEgMTIuNSAxMi41IDAgMCAwIDEyLjUgMCIgdHJhbnNmb3JtPSJtYXRyaXgoMSwwLDAsMSwxMywxNS41KSI+PC9wYXRoPgoJCTxwYXRoIGNsYXNzPSJzdDIiIGQ9Ik0gMTMgMCBMIDEwIDIgTCAxNiAyIFoiPjwvcGF0aD4KCQk8cGF0aCBjbGFzcz0ic3QyIiBkPSJNIDIgMCBBIDIgMiAwIDAgMCAtMiAwIEEgMiAyIDAgMCAwIDIgMCIgdHJhbnNmb3JtPSJtYXRyaXgoMSwwLDAsMSwxMywxNS41KSI+PC9wYXRoPgoJCTxwYXRoIGNsYXNzPSJzdDEiIGlkPSJpbmRpY2F0b3IiIHRyYW5zZm9ybT0ibWF0cml4KDEsMCwwLDEsMTMsMTUuNSkiPjwvcGF0aD4KCTwvZz4KPC9zdmc+"},l={load:function(t,e=()=>{},n=()=>{},i=()=>{}){X.Cache.enabled=!0;let s,o,a,r,c,h,l;for(var d in p)p.hasOwnProperty(d)&&t===p[d]&&(l=d);if(void 0!==(s=X.Cache.get(l||t)))return e&&setTimeout(function(){n({loaded:1,total:1}),e(s)},0),s;c=window.URL||window.webkitURL,h=document.createElementNS("http://www.w3.org/1999/xhtml","img"),X.Cache.add(l||t,h);const u=()=>{c.revokeObjectURL(h.src),e(h)};if(0===t.indexOf("data:"))return h.addEventListener("load",u,!1),h.src=t,h;h.crossOrigin=void 0!==this.crossOrigin?this.crossOrigin:"",(o=new window.XMLHttpRequest).open("GET",t,!0),o.responseType="arraybuffer",o.addEventListener("error",i),o.addEventListener("progress",t=>{var e,i;t&&({loaded:t,total:e,lengthComputable:i}=t,i)&&n({loaded:t,total:e})}),o.addEventListener("loadend",t=>{t&&({response:t}=t["currentTarget"],a=new Uint8Array(t),r=new window.Blob([a]),h.addEventListener("load",u,!1),h.src=c.createObjectURL(r))}),o.send(null)}},c={load:function(e,i=()=>{},t,n){const s=new X.Texture;return l.load(e,function(t){s.image=t;t=0<e.search(/\.(jpg|jpeg)$/)||0===e.search(/^data\:image\/jpeg/);s.format=t?X.RGBFormat:X.RGBAFormat,s.needsUpdate=!0,i(s)},t,n),s}},s={load:function(t,e=()=>{},n=()=>{},s){let o,a,r,c,h;return o=new X.CubeTexture([]),a=0,r={},c={},t.map(function(t,i){l.load(t,function(t){o.images[i]=t,6===++a&&(o.needsUpdate=!0,e(o))},function(t){for(var e in r[i]={loaded:t.loaded,total:t.total},c.loaded=0,c.total=0,h=0,r)h++,c.loaded+=r[e].loaded,c.total+=r[e].total;h<6&&(c.total=c.total/h*6),n(c)},s)}),o}};function o(t){this.constraints=Object.assign({video:{width:{ideal:1920},height:{ideal:1080},facingMode:{exact:"environment"}},audio:!1},t),this.container=null,this.scene=null,this.element=null,this.devices=[],this.stream=null,this.ratioScalar=1,this.videoDeviceIndex=0}function h(t=.064){this.format=null,this.eyeSep=t,this.loffset=new X.Vector2,this.roffset=new X.Vector2}function d(t=16777215,e=!0,i=1500){this.dpr=window.devicePixelRatio;var{canvas:n,context:s}=this.createCanvas(),o=new X.SpriteMaterial({color:t,map:this.createCanvasTexture(n)});X.Sprite.call(this,o),this.canvasWidth=n.width,this.canvasHeight=n.height,this.context=s,this.color=t instanceof X.Color?t:new X.Color(t),this.autoSelect=e,this.dwellTime=i,this.rippleDuration=500,this.position.z=-10,this.center.set(.5,.5),this.scale.set(.5,.5,1),this.startTimestamp=null,this.timerId=null,this.callback=null,this.frustumCulled=!1,this.updateCanvasArcByProgress(0)}o.prototype=Object.assign(Object.create(X.EventDispatcher.prototype),{setContainer:function(t){this.container=t},setScene:function(t){this.scene=t},enumerateDevices:function(){const e=this.devices;var t=new Promise(t=>{t(e)});return 0<e.length?t:window.navigator.mediaDevices.enumerateDevices()},switchNextVideoDevice:function(){const e=this.stop.bind(this),i=this.start.bind(this),n=this.setVideDeviceIndex.bind(this);let s=this.videoDeviceIndex;this.getDevices("video").then(t=>{e(),++s>=t.length?(n(0),s--):n(s),i(t[s])})},getDevices:function(i="video"){const e=this.devices;return this.enumerateDevices().then(t=>t.map(t=>(e.includes(t)||e.push(t),t))).then(t=>{const e=new RegExp(i,"i");return t.filter(t=>e.test(t.kind))})},getUserMedia:function(t){var e=this.setMediaStream.bind(this),i=this.playVideo.bind(this);return window.navigator.mediaDevices.getUserMedia(t).then(e).then(i).catch(t=>{console.warn("PANOLENS.Media: "+t)})},setVideDeviceIndex:function(t){this.videoDeviceIndex=t},start:function(e){const i=this.constraints,n=this.getUserMedia.bind(this);return this.element=this.createVideoElement(),this.getDevices().then(t=>{if(t&&0!==t.length)return t=e||t[0],i.video.deviceId=t.deviceId,n(i);throw Error("no video device found")})},stop:function(){var t=this.stream;t&&t.active&&(t.getTracks()[0].stop(),window.removeEventListener("resize",this.onWindowResize.bind(this)),this.element=null,this.stream=null)},setMediaStream:function(t){this.stream=t,this.element.srcObject=t,this.scene&&(this.scene.background=this.createVideoTexture()),window.addEventListener("resize",this.onWindowResize.bind(this))},playVideo:function(){var t=this["element"];t&&(t.play(),this.dispatchEvent({type:"play"}))},pauseVideo:function(){var t=this["element"];t&&(t.pause(),this.dispatchEvent({type:"pause"}))},createVideoTexture:function(){var t=this.element,e=new X.VideoTexture(t);return e.generateMipmaps=!1,e.minFilter=X.LinearFilter,e.magFilter=X.LinearFilter,e.format=X.RGBFormat,e.center.set(.5,.5),t.addEventListener("canplay",this.onWindowResize.bind(this)),e},createVideoElement:function(){const t=this.dispatchEvent.bind(this);var e=document.createElement("video");return e.setAttribute("autoplay",""),e.setAttribute("muted",""),e.setAttribute("playsinline",""),e.style.position="absolute",e.style.top="0",e.style.left="0",e.style.width="100%",e.style.height="100%",e.style.objectPosition="center",e.style.objectFit="cover",e.style.display=this.scene?"none":"",e.addEventListener("canplay",()=>t({type:"canplay"})),e},onWindowResize:function(){var t,e,i,n,s;this.element&&this.element.videoWidth&&this.element.videoHeight&&this.scene&&({clientWidth:t,clientHeight:e}=this.container,i=this.scene.background,{videoWidth:n,videoHeight:s}=this.element,s=s/n*(this.container?t/e:1)*this.ratioScalar,e<t?i.repeat.set(s,1):i.repeat.set(1,1/s))}}),Object.assign(h.prototype,{constructor:h,updateUniformByFormat:function(t,e){this.format=t;var i=e.repeat.value,n=e.offset.value,s=this.loffset,o=this.roffset;switch(t){case r.TAB:i.set(1,.5),n.set(0,.5),s.set(0,.5),o.set(0,0);break;case r.SBS:i.set(.5,1),n.set(0,0),s.set(0,0),o.set(.5,0)}},updateTextureToLeft:function(t){t.copy(this.loffset)},updateTextureToRight:function(t){t.copy(this.roffset)}}),d.prototype=Object.assign(Object.create(X.Sprite.prototype),{constructor:d,setColor:function(t){this.material.color.copy(t instanceof X.Color?t:new X.Color(t))},createCanvasTexture:function(t){t=new X.CanvasTexture(t);return t.minFilter=X.LinearFilter,t.magFilter=X.LinearFilter,t.generateMipmaps=!1,t},createCanvas:function(){var t=document.createElement("canvas"),e=t.getContext("2d"),i=this.dpr;return t.width=32*i,t.height=32*i,e.scale(i,i),e.shadowBlur=5,e.shadowColor="rgba(200,200,200,0.9)",{canvas:t,context:e}},updateCanvasArcByProgress:function(t){var e=this.context,{canvasWidth:i,canvasHeight:n,material:s}=this,o=this.dpr,a=t*Math.PI*2,r=this.color.getStyle(),c=.5*i/o,o=.5*n/o;e.clearRect(0,0,i,n),e.beginPath(),0===t?(e.arc(c,o,i/16,0,2*Math.PI),e.fillStyle=r,e.fill()):(e.arc(c,o,i/4-3,-Math.PI/2,-Math.PI/2+a),e.strokeStyle=r,e.lineWidth=3,e.stroke()),e.closePath(),s.map.needsUpdate=!0},ripple:function(){const s=this.context,{canvasWidth:o,canvasHeight:a,material:r}=this,c=this.rippleDuration,h=performance.now(),l=this.color,d=this.dpr,u=.5*o/d,p=.5*a/d,m=()=>{var t=window.requestAnimationFrame(m),e=(performance.now()-h)/c,i=0<1-e?1-e:0,n=e*o*.5/d;s.clearRect(0,0,o,a),s.beginPath(),s.arc(u,p,n,0,2*Math.PI),s.fillStyle=`rgba(${255*l.r}, ${255*l.g}, ${255*l.b}, ${i})`,s.fill(),s.closePath(),1<=e&&(window.cancelAnimationFrame(t),this.updateCanvasArcByProgress(0),this.dispatchEvent({type:"reticle-ripple-end"})),r.map.needsUpdate=!0};this.dispatchEvent({type:"reticle-ripple-start"}),m()},show:function(){this.visible=!0},hide:function(){this.visible=!1},start:function(t){this.autoSelect&&(this.dispatchEvent({type:"reticle-start"}),this.startTimestamp=performance.now(),this.callback=t,this.update())},end:function(){this.startTimestamp&&(window.cancelAnimationFrame(this.timerId),this.updateCanvasArcByProgress(0),this.callback=null,this.timerId=null,this.startTimestamp=null,this.dispatchEvent({type:"reticle-end"}))},update:function(){this.timerId=window.requestAnimationFrame(this.update.bind(this));var t=(performance.now()-this.startTimestamp)/this.dwellTime;this.updateCanvasArcByProgress(t),this.dispatchEvent({type:"reticle-update",progress:t}),1<=t&&(window.cancelAnimationFrame(this.timerId),this.callback&&this.callback(),this.end(),this.ripple())}});(function(t){function e(){this._tweens={},this._tweensAddedDuringUpdate={}}e.prototype={getAll:function(){return Object.keys(this._tweens).map(function(t){return this._tweens[t]}.bind(this))},removeAll:function(){this._tweens={}},add:function(t){this._tweens[t.getId()]=t,this._tweensAddedDuringUpdate[t.getId()]=t},remove:function(t){delete this._tweens[t.getId()],delete this._tweensAddedDuringUpdate[t.getId()]},update:function(t,e){var i=Object.keys(this._tweens);if(0===i.length)return!1;for(t=void 0!==t?t:r.now();0<i.length;){this._tweensAddedDuringUpdate={};for(var n=0;n<i.length;n++){var s=this._tweens[i[n]];s&&!1===s.update(t)&&(s._isPlaying=!1,e||delete this._tweens[i[n]])}i=Object.keys(this._tweensAddedDuringUpdate)}return!0}};var n,r=new e;r.Group=e,r._nextId=0,r.nextId=function(){return r._nextId++},"undefined"==typeof self&&"undefined"!=typeof process&&process.hrtime?r.now=function(){var t=process.hrtime();return 1e3*t[0]+t[1]/1e6}:"undefined"!=typeof self&&void 0!==self.performance&&void 0!==self.performance.now?r.now=self.performance.now.bind(self.performance):void 0!==Date.now?r.now=Date.now:r.now=function(){return(new Date).getTime()},r.Tween=function(t,e){this._object=t,this._valuesStart={},this._valuesEnd={},this._valuesStartRepeat={},this._duration=1e3,this._repeat=0,this._repeatDelayTime=void 0,this._yoyo=!1,this._isPlaying=!1,this._reversed=!1,this._delayTime=0,this._startTime=null,this._easingFunction=r.Easing.Linear.None,this._interpolationFunction=r.Interpolation.Linear,this._chainedTweens=[],this._onStartCallback=null,this._onStartCallbackFired=!1,this._onUpdateCallback=null,this._onRepeatCallback=null,this._onCompleteCallback=null,this._onStopCallback=null,this._group=e||r,this._id=r.nextId()},r.Tween.prototype={getId:function(){return this._id},isPlaying:function(){return this._isPlaying},to:function(t,e){return this._valuesEnd=Object.create(t),void 0!==e&&(this._duration=e),this},duration:function(t){return this._duration=t,this},start:function(t){for(var e in this._group.add(this),this._isPlaying=!0,this._onStartCallbackFired=!1,this._startTime=void 0!==t?"string"==typeof t?r.now()+parseFloat(t):t:r.now(),this._startTime+=this._delayTime,this._valuesEnd){if(this._valuesEnd[e]instanceof Array){if(0===this._valuesEnd[e].length)continue;this._valuesEnd[e]=[this._object[e]].concat(this._valuesEnd[e])}void 0!==this._object[e]&&(this._valuesStart[e]=this._object[e],this._valuesStart[e]instanceof Array==!1&&(this._valuesStart[e]*=1),this._valuesStartRepeat[e]=this._valuesStart[e]||0)}return this},stop:function(){return this._isPlaying&&(this._group.remove(this),this._isPlaying=!1,null!==this._onStopCallback&&this._onStopCallback(this._object),this.stopChainedTweens()),this},end:function(){return this.update(1/0),this},stopChainedTweens:function(){for(var t=0,e=this._chainedTweens.length;t<e;t++)this._chainedTweens[t].stop()},group:function(t){return this._group=t,this},delay:function(t){return this._delayTime=t,this},repeat:function(t){return this._repeat=t,this},repeatDelay:function(t){return this._repeatDelayTime=t,this},yoyo:function(t){return this._yoyo=t,this},easing:function(t){return this._easingFunction=t,this},interpolation:function(t){return this._interpolationFunction=t,this},chain:function(){return this._chainedTweens=arguments,this},onStart:function(t){return this._onStartCallback=t,this},onUpdate:function(t){return this._onUpdateCallback=t,this},onRepeat:function(t){return this._onRepeatCallback=t,this},onComplete:function(t){return this._onCompleteCallback=t,this},onStop:function(t){return this._onStopCallback=t,this},update:function(t){var e,i,n,s,o,a;if(t<this._startTime)return!0;for(e in!1===this._onStartCallbackFired&&(null!==this._onStartCallback&&this._onStartCallback(this._object),this._onStartCallbackFired=!0),i=(t-this._startTime)/this._duration,i=0===this._duration||1<i?1:i,n=this._easingFunction(i),this._valuesEnd)void 0!==this._valuesStart[e]&&(s=this._valuesStart[e]||0,(o=this._valuesEnd[e])instanceof Array?this._object[e]=this._interpolationFunction(o,n):"number"==typeof(o="string"==typeof o?"+"===o.charAt(0)||"-"===o.charAt(0)?s+parseFloat(o):parseFloat(o):o)&&(this._object[e]=s+(o-s)*n));if(null!==this._onUpdateCallback&&this._onUpdateCallback(this._object,i),1!=i)return!0;if(0<this._repeat){for(e in isFinite(this._repeat)&&this._repeat--,this._valuesStartRepeat)"string"==typeof this._valuesEnd[e]&&(this._valuesStartRepeat[e]=this._valuesStartRepeat[e]+parseFloat(this._valuesEnd[e])),this._yoyo&&(a=this._valuesStartRepeat[e],this._valuesStartRepeat[e]=this._valuesEnd[e],this._valuesEnd[e]=a),this._valuesStart[e]=this._valuesStartRepeat[e];return this._yoyo&&(this._reversed=!this._reversed),void 0!==this._repeatDelayTime?this._startTime=t+this._repeatDelayTime:this._startTime=t+this._delayTime,null!==this._onRepeatCallback&&this._onRepeatCallback(this._object),!0}null!==this._onCompleteCallback&&this._onCompleteCallback(this._object);for(var r=0,c=this._chainedTweens.length;r<c;r++)this._chainedTweens[r].start(this._startTime+this._duration);return!1}},r.Easing={Linear:{None:function(t){return t}},Quadratic:{In:function(t){return t*t},Out:function(t){return t*(2-t)},InOut:function(t){return(t*=2)<1?.5*t*t:-.5*(--t*(t-2)-1)}},Cubic:{In:function(t){return t*t*t},Out:function(t){return--t*t*t+1},InOut:function(t){return(t*=2)<1?.5*t*t*t:.5*((t-=2)*t*t+2)}},Quartic:{In:function(t){return t*t*t*t},Out:function(t){return 1- --t*t*t*t},InOut:function(t){return(t*=2)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2)}},Quintic:{In:function(t){return t*t*t*t*t},Out:function(t){return--t*t*t*t*t+1},InOut:function(t){return(t*=2)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)}},Sinusoidal:{In:function(t){return 1-Math.cos(t*Math.PI/2)},Out:function(t){return Math.sin(t*Math.PI/2)},InOut:function(t){return.5*(1-Math.cos(Math.PI*t))}},Exponential:{In:function(t){return 0===t?0:Math.pow(1024,t-1)},Out:function(t){return 1===t?1:1-Math.pow(2,-10*t)},InOut:function(t){return 0===t?0:1===t?1:(t*=2)<1?.5*Math.pow(1024,t-1):.5*(2-Math.pow(2,-10*(t-1)))}},Circular:{In:function(t){return 1-Math.sqrt(1-t*t)},Out:function(t){return Math.sqrt(1- --t*t)},InOut:function(t){return(t*=2)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)}},Elastic:{In:function(t){return 0===t?0:1===t?1:-Math.pow(2,10*(t-1))*Math.sin(5*(t-1.1)*Math.PI)},Out:function(t){return 0===t?0:1===t?1:Math.pow(2,-10*t)*Math.sin(5*(t-.1)*Math.PI)+1},InOut:function(t){return 0===t?0:1===t?1:(t*=2)<1?-.5*Math.pow(2,10*(t-1))*Math.sin(5*(t-1.1)*Math.PI):.5*Math.pow(2,-10*(t-1))*Math.sin(5*(t-1.1)*Math.PI)+1}},Back:{In:function(t){return t*t*(2.70158*t-1.70158)},Out:function(t){return--t*t*(2.70158*t+1.70158)+1},InOut:function(t){var e=2.5949095;return(t*=2)<1?t*t*((1+e)*t-e)*.5:.5*((t-=2)*t*((1+e)*t+e)+2)}},Bounce:{In:function(t){return 1-r.Easing.Bounce.Out(1-t)},Out:function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375},InOut:function(t){return t<.5?.5*r.Easing.Bounce.In(2*t):.5*r.Easing.Bounce.Out(2*t-1)+.5}}},r.Interpolation={Linear:function(t,e){var i=t.length-1,n=i*e,s=Math.floor(n),o=r.Interpolation.Utils.Linear;return e<0?o(t[0],t[1],n):1<e?o(t[i],t[i-1],i-n):o(t[s],t[i<s+1?i:s+1],n-s)},Bezier:function(t,e){for(var i=0,n=t.length-1,s=Math.pow,o=r.Interpolation.Utils.Bernstein,a=0;a<=n;a++)i+=s(1-e,n-a)*s(e,a)*t[a]*o(n,a);return i},CatmullRom:function(t,e){var i=t.length-1,n=i*e,s=Math.floor(n),o=r.Interpolation.Utils.CatmullRom;return t[0]===t[i]?o(t[((s=e<0?Math.floor(n=i*(1+e)):s)-1+i)%i],t[s],t[(s+1)%i],t[(s+2)%i],n-s):e<0?t[0]-(o(t[0],t[0],t[1],t[1],-n)-t[0]):1<e?t[i]-(o(t[i],t[i],t[i-1],t[i-1],n-i)-t[i]):o(t[s?s-1:0],t[s],t[i<s+1?i:s+1],t[i<s+2?i:s+2],n-s)},Utils:{Linear:function(t,e,i){return(e-t)*i+t},Bernstein:function(t,e){var i=r.Interpolation.Utils.Factorial;return i(t)/i(e)/i(t-e)},Factorial:(n=[1],function(t){var e=1;if(n[t])return n[t];for(var i=t;1<i;i--)e*=i;return n[t]=e}),CatmullRom:function(t,e,i,n,s){var t=.5*(i-t),n=.5*(n-e),o=s*s;return(2*e-2*i+t+n)*(s*o)+(-3*e+3*i-2*t-n)*o+t*s+e}}},t.exports=r})(u={exports:{}});var u,v=u.exports;function f(n=300,t,e){t=t||p.Info,X.Sprite.call(this),this.type="infospot",this.animated=void 0===e||e,this.isHovering=!1,this.frustumCulled=!1,this.element=null,this.toPanorama=null,this.cursorStyle=null,this.mode=m.NORMAL,this.scale.set(n,n,1),this.rotation.y=Math.PI,this.container=null,this.originalRaycast=this.raycast,this.HANDLER_FOCUS=null,this.material.side=X.DoubleSide,this.material.depthTest=!1,this.material.transparent=!0,this.material.opacity=0,this.scaleUpAnimation=new v.Tween,this.scaleDownAnimation=new v.Tween;e=function(t){var e,i;this.material&&(e=t.image.width/t.image.height,i=new X.Vector3,t.image.width=t.image.naturalWidth||64,t.image.height=t.image.naturalHeight||64,this.scale.set(e*n,n,1),i.copy(this.scale),this.scaleUpAnimation=new v.Tween(this.scale).to({x:1.3*i.x,y:1.3*i.y},500).easing(v.Easing.Elastic.Out),this.scaleDownAnimation=new v.Tween(this.scale).to({x:i.x,y:i.y},500).easing(v.Easing.Elastic.Out),this.material.map=t,this.material.needsUpdate=!0)}.bind(this);this.showAnimation=new v.Tween(this.material).to({opacity:1},500).onStart(this.enableRaycast.bind(this,!0)).easing(v.Easing.Quartic.Out),this.hideAnimation=new v.Tween(this.material).to({opacity:0},500).onStart(this.enableRaycast.bind(this,!1)).easing(v.Easing.Quartic.Out),this.addEventListener("click",this.onClick),this.addEventListener("hover",this.onHover),this.addEventListener("hoverenter",this.onHoverStart),this.addEventListener("hoverleave",this.onHoverEnd),this.addEventListener("panolens-dual-eye-effect",this.onDualEyeEffect),this.addEventListener("panolens-container",this.setContainer.bind(this)),this.addEventListener("dismiss",this.onDismiss),this.addEventListener("panolens-infospot-focus",this.setFocusMethod),c.load(t,e)}function g(t){t||console.warn("PANOLENS.Widget: No container specified"),X.EventDispatcher.call(this),this.DEFAULT_TRANSITION="all 0.27s ease",this.TOUCH_ENABLED=!!("ontouchstart"in window||window.DocumentTouch&&document instanceof DocumentTouch),this.PREVENT_EVENT_HANDLER=function(t){t.preventDefault(),t.stopPropagation()},this.container=t,this.barElement=null,this.fullscreenElement=null,this.videoElement=null,this.settingElement=null,this.mainMenu=null,this.activeMainItem=null,this.activeSubMenu=null,this.mask=null}f.prototype=Object.assign(Object.create(X.Sprite.prototype),{constructor:f,setContainer:function(t){let e;t instanceof HTMLElement?e=t:t&&t.container&&(e=t.container),e&&this.element&&e.appendChild(this.element),this.container=e},getContainer:function(){return this.container},onClick:function(t){this.element&&this.getContainer()&&(this.onHoverStart(t),this.lockHoverElement())},onDismiss:function(){this.element&&(this.unlockHoverElement(),this.onHoverEnd())},onHover:function(){},onHoverStart:function(t){var e,i,n,s;this.getContainer()&&(i=this.cursorStyle||(this.mode===m.NORMAL?"pointer":"default"),{scaleDownAnimation:n,scaleUpAnimation:s,element:e}=this,this.isHovering=!0,this.container.style.cursor=i,this.animated&&(n.stop(),s.start()),e)&&0<=t.mouseEvent.clientX&&0<=t.mouseEvent.clientY&&({left:i,right:n,style:s}=e,this.mode===m.CARDBOARD||this.mode===m.STEREO?(s.display="none",i.style.display="block",n.style.display="block",e._width=i.clientWidth,e._height=i.clientHeight):(s.display="block",i&&(i.style.display="none"),n&&(n.style.display="none"),e._width=e.clientWidth,e._height=e.clientHeight))},onHoverEnd:function(){var t,e,i;this.getContainer()&&({scaleDownAnimation:e,scaleUpAnimation:t,element:i}=this,this.isHovering=!1,this.container.style.cursor="default",this.animated&&(t.stop(),e.start()),i)&&!this.element.locked&&({left:t,right:e,style:i}=i,i.display="none",t&&(t.style.display="none"),e&&(e.style.display="none"),this.unlockHoverElement())},onDualEyeEffect:function(t){var e,i;this.getContainer()&&(this.mode=t.mode,t=this.element,e=this.container.clientWidth/2,i=this.container.clientHeight/2,t)&&(t.left||t.right||(t.left=t.cloneNode(!0),t.right=t.cloneNode(!0)),this.mode===m.CARDBOARD||this.mode===m.STEREO?(t.left.style.display=t.style.display,t.right.style.display=t.style.display,t.style.display="none"):(t.style.display=t.left.style.display,t.left.style.display="none",t.right.style.display="none"),this.translateElement(e,i),this.container.appendChild(t.left),this.container.appendChild(t.right))},translateElement:function(r,c){if(this.element._width&&this.element._height&&this.getContainer()){let t,e,i,n,s,o,a;a=this.container,n=(i=this.element)._width/2,s=i._height/2,o=void 0!==i.verticalDelta?i.verticalDelta:40,t=r-n,e=c-s-o,this.mode!==m.CARDBOARD&&this.mode!==m.STEREO||!i.left||!i.right||r===a.clientWidth/2&&c===a.clientHeight/2?this.setElementStyle("transform",i,"translate("+t+"px, "+e+"px)"):(t=a.clientWidth/4-n+(r-a.clientWidth/2),e=a.clientHeight/2-s-o+(c-a.clientHeight/2),this.setElementStyle("transform",i.left,"translate("+t+"px, "+e+"px)"),t+=a.clientWidth/2,this.setElementStyle("transform",i.right,"translate("+t+"px, "+e+"px)"))}},setElementStyle:function(t,e,i){e=e.style;"transform"===t&&(e.webkitTransform=e.msTransform=e.transform=i)},setText:function(t){this.element&&(this.element.textContent=t)},setCursorHoverStyle:function(t){this.cursorStyle=t},addHoverText:function(t,e=40){this.element||(this.element=document.createElement("div"),this.element.style.display="none",this.element.style.color="#fff",this.element.style.top=0,this.element.style.maxWidth="50%",this.element.style.maxHeight="50%",this.element.style.textShadow="0 0 3px #000000",this.element.style.fontFamily='"Trebuchet MS", Helvetica, sans-serif',this.element.style.position="absolute",this.element.classList.add("panolens-infospot"),this.element.verticalDelta=e),this.setText(t)},addHoverElement:function(t,e=40){this.element||(this.element=t.cloneNode(!0),this.element.style.display="none",this.element.style.top=0,this.element.style.position="absolute",this.element.classList.add("panolens-infospot"),this.element.verticalDelta=e)},removeHoverElement:function(){this.element&&(this.element.left&&(this.container.removeChild(this.element.left),this.element.left=null),this.element.right&&(this.container.removeChild(this.element.right),this.element.right=null),this.container.removeChild(this.element),this.element=null)},lockHoverElement:function(){this.element&&(this.element.locked=!0)},unlockHoverElement:function(){this.element&&(this.element.locked=!1)},enableRaycast:function(t=!0){this.raycast=t?this.originalRaycast:()=>{}},show:function(t=0){var{animated:e,hideAnimation:i,showAnimation:n,material:s}=this;e?(i.stop(),n.delay(t).start()):(this.enableRaycast(!0),s.opacity=1)},hide:function(t=0){var{animated:e,hideAnimation:i,showAnimation:n,material:s}=this;e?(n.stop(),i.delay(t).start()):(this.enableRaycast(!1),s.opacity=0)},setFocusMethod:function(t){t&&(this.HANDLER_FOCUS=t.method)},focus:function(t,e){this.HANDLER_FOCUS&&(this.HANDLER_FOCUS(this.position,t,e),this.onDismiss())},dispose:function(){var{geometry:t,material:e}=this,i=e["map"];this.removeHoverElement(),this.parent&&this.parent.remove(this),i&&(i.dispose(),e.map=null),t&&(t.dispose(),this.geometry=null),e&&(e.dispose(),this.material=null)}}),g.prototype=Object.assign(Object.create(X.EventDispatcher.prototype),{constructor:g,addControlBar:function(){if(this.container){const e=this;var t="linear-gradient(bottom, rgba(0,0,0,0.2), rgba(0,0,0,0))";const i=document.createElement("div");i.style.width="100%",i.style.height="44px",i.style.float="left",i.style.transform=i.style.webkitTransform=i.style.msTransform="translateY(-100%)",i.style.background="-webkit-"+t,i.style.background="-moz-"+t,i.style.background="-o-"+t,i.style.background="-ms-"+t,i.style.background=t,i.style.transition=this.DEFAULT_TRANSITION,i.style.pointerEvents="none",i.isHidden=!1,i.toggle=function(){i.isHidden=!i.isHidden;var t=i.isHidden?"translateY(0)":"translateY(-100%)",e=i.isHidden?0:1;i.style.transform=i.style.webkitTransform=i.style.msTransform=t,i.style.opacity=e};t=this.createDefaultMenu(),t=(this.mainMenu=this.createMainMenu(t),i.appendChild(this.mainMenu),this.createMask());this.mask=t,this.container.appendChild(t),i.dispose=function(){e.fullscreenElement&&(i.removeChild(e.fullscreenElement),e.fullscreenElement.dispose(),e.fullscreenElement=null),e.settingElement&&(i.removeChild(e.settingElement),e.settingElement.dispose(),e.settingElement=null),e.videoElement&&(i.removeChild(e.videoElement),e.videoElement.dispose(),e.videoElement=null)},this.container.appendChild(i),this.mask.addEventListener("mousemove",this.PREVENT_EVENT_HANDLER,!0),this.mask.addEventListener("mouseup",this.PREVENT_EVENT_HANDLER,!0),this.mask.addEventListener("mousedown",this.PREVENT_EVENT_HANDLER,!0),this.mask.addEventListener(e.TOUCH_ENABLED?"touchend":"click",function(t){t.preventDefault(),t.stopPropagation(),e.mask.hide(),e.settingElement.deactivate()},!1),this.addEventListener("control-bar-toggle",i.toggle),this.barElement=i}else console.warn("Widget container not set")},createDefaultMenu:function(){const i=this;function t(t,e){return function(){i.dispatchEvent({type:"panolens-viewer-handler",method:t,data:e})}}return[{title:"Control",subMenu:[{title:this.TOUCH_ENABLED?"Touch":"Mouse",handler:t("enableControl",a.ORBIT)},{title:"Sensor",handler:t("enableControl",a.DEVICEORIENTATION)}]},{title:"Mode",subMenu:[{title:"Normal",handler:t("disableEffect")},{title:"Cardboard",handler:t("enableEffect",m.CARDBOARD)},{title:"Stereoscopic",handler:t("enableEffect",m.STEREO)}]}]},addControlButton:function(t){let e;switch(t){case"fullscreen":e=this.createFullscreenButton(),this.fullscreenElement=e;break;case"setting":e=this.createSettingButton(),this.settingElement=e;break;case"video":e=this.createVideoControl(),this.videoElement=e;break;default:return}e&&this.barElement.appendChild(e)},createMask:function(){var t=document.createElement("div");return t.style.position="absolute",t.style.top=0,t.style.left=0,t.style.width="100%",t.style.height="100%",t.style.background="transparent",t.style.display="none",t.show=function(){this.style.display="block"},t.hide=function(){this.style.display="none"},t},createSettingButton:function(){let e=this,t;return(t=this.createCustomItem({style:{backgroundImage:'url("'+p.Setting+'")',webkitTransition:this.DEFAULT_TRANSITION,transition:this.DEFAULT_TRANSITION},onTap:function(t){t.preventDefault(),t.stopPropagation(),e.mainMenu.toggle(),this.activated?this.deactivate():this.activate()}})).activate=function(){this.style.transform="rotate3d(0,0,1,90deg)",this.activated=!0,e.mask.show()},t.deactivate=function(){this.style.transform="rotate3d(0,0,0,0)",this.activated=!1,e.mask.hide(),e.mainMenu&&e.mainMenu.visible&&e.mainMenu.hide(),e.activeSubMenu&&e.activeSubMenu.visible&&e.activeSubMenu.hide(),e.mainMenu&&e.mainMenu._width&&(e.mainMenu.changeSize(e.mainMenu._width),e.mainMenu.unslideAll())},t.activated=!1,t},createFullscreenButton:function(){let t=this,e,i=!1,n=!0,s;const o=this["container"];var a;if(s="panolens-style-addon",document.fullscreenEnabled||document.webkitFullscreenEnabled||document.mozFullScreenEnabled||document.msFullscreenEnabled)return document.addEventListener("fullscreenchange",r,!1),document.addEventListener("webkitfullscreenchange",r,!1),document.addEventListener("mozfullscreenchange",r,!1),document.addEventListener("MSFullscreenChange",r,!1),e=this.createCustomItem({style:{backgroundImage:'url("'+p.FullscreenEnter+'")'},onTap:function(t){t.preventDefault(),t.stopPropagation(),n=!1,i=i?(document.exitFullscreen&&document.exitFullscreen(),document.msExitFullscreen&&document.msExitFullscreen(),document.mozCancelFullScreen&&document.mozCancelFullScreen(),document.webkitExitFullscreen&&document.webkitExitFullscreen(),!1):(o.requestFullscreen&&o.requestFullscreen(),o.msRequestFullscreen&&o.msRequestFullscreen(),o.mozRequestFullScreen&&o.mozRequestFullScreen(),o.webkitRequestFullscreen&&o.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT),!0),this.style.backgroundImage=i?'url("'+p.FullscreenLeave+'")':'url("'+p.FullscreenEnter+'")'}}),document.querySelector(s)||((a=document.createElement("style")).id=s,a.innerHTML=":-webkit-full-screen { width: 100% !important; height: 100% !important }",document.body.appendChild(a)),e;function r(){n&&(i=!i,e.style.backgroundImage=i?'url("'+p.FullscreenLeave+'")':'url("'+p.FullscreenEnter+'")'),t.dispatchEvent({type:"panolens-viewer-handler",method:"onWindowResize"}),n=!0}},createVideoControl:function(){const t=document.createElement("span");return t.style.display="none",t.show=function(){t.style.display=""},t.hide=function(){t.style.display="none",t.controlButton.paused=!0,t.controlButton.update()},t.controlButton=this.createVideoControlButton(),t.seekBar=this.createVideoControlSeekbar(),t.appendChild(t.controlButton),t.appendChild(t.seekBar),t.dispose=function(){t.removeChild(t.controlButton),t.removeChild(t.seekBar),t.controlButton.dispose(),t.controlButton=null,t.seekBar.dispose(),t.seekBar=null},this.addEventListener("video-control-show",t.show),this.addEventListener("video-control-hide",t.hide),t},createVideoControlButton:function(){const e=this;const i=this.createCustomItem({style:{float:"left",backgroundImage:'url("'+p.VideoPlay+'")'},onTap:function(t){t.preventDefault(),t.stopPropagation(),e.dispatchEvent({type:"panolens-viewer-handler",method:"toggleVideoPlay",data:!this.paused}),this.paused=!this.paused,i.update()}});return i.paused=!0,i.update=function(t){this.paused=void 0!==t?t:this.paused,this.style.backgroundImage='url("'+(this.paused?p.VideoPlay:p.VideoPause)+'")'},i},createVideoControlSeekbar:function(){let i=this,n,e,s,o=!1,a,r,c;function t(t){t.stopPropagation(),o=!0,a=t.clientX||t.changedTouches&&t.changedTouches[0].clientX,r=parseInt(e.style.width)/100,i.container.addEventListener("mousemove",h,{passive:!0}),i.container.addEventListener("mouseup",l,{passive:!0}),i.container.addEventListener("touchmove",h,{passive:!0}),i.container.addEventListener("touchend",l,{passive:!0})}function h(t){o&&(t=t.clientX||t.changedTouches&&t.changedTouches[0].clientX,c=(t-a)/n.clientWidth,c=1<(c=r+c)?1:c<0?0:c,n.setProgress(c),i.dispatchEvent({type:"panolens-viewer-handler",method:"setVideoCurrentTime",data:c}))}function l(t){t.stopPropagation(),o=!1,d()}function d(){i.container.removeEventListener("mousemove",h,!1),i.container.removeEventListener("mouseup",l,!1),i.container.removeEventListener("touchmove",h,!1),i.container.removeEventListener("touchend",l,!1)}return(e=document.createElement("div")).style.width="0%",e.style.height="100%",e.style.backgroundColor="#fff",(s=document.createElement("div")).style.float="right",s.style.width="14px",s.style.height="14px",s.style.transform="translate(7px, -5px)",s.style.borderRadius="50%",s.style.backgroundColor="#ddd",s.addEventListener("mousedown",t,{passive:!0}),s.addEventListener("touchstart",t,{passive:!0}),e.appendChild(s),(n=this.createCustomItem({style:{float:"left",width:"30%",height:"4px",marginTop:"20px",backgroundColor:"rgba(188,188,188,0.8)"},onTap:function(t){var e;t.preventDefault(),t.stopPropagation(),t.target!==s&&(e=t.changedTouches&&0<t.changedTouches.length?(t.changedTouches[0].pageX-t.target.getBoundingClientRect().left)/this.clientWidth:t.offsetX/this.clientWidth,i.dispatchEvent({type:"panolens-viewer-handler",method:"setVideoCurrentTime",data:e}),n.setProgress(t.offsetX/this.clientWidth))},onDispose:function(){d(),e=null,s=null}})).appendChild(e),n.setProgress=function(t){e.style.width=100*t+"%"},this.addEventListener("video-update",function(t){n.setProgress(t.percentage)}),n.progressElement=e,n.progressElementControl=s,n},createMenuItem:function(t){const i=this;var e=document.createElement("a");return e.textContent=t,e.style.display="block",e.style.padding="10px",e.style.textDecoration="none",e.style.cursor="pointer",e.style.pointerEvents="auto",e.style.transition=this.DEFAULT_TRANSITION,e.slide=function(t){this.style.transform="translateX("+(t?"":"-")+"100%)"},e.unslide=function(){this.style.transform="translateX(0)"},e.setIcon=function(t){this.icon&&(this.icon.style.backgroundImage="url("+t+")")},e.setSelectionTitle=function(t){this.selection&&(this.selection.textContent=t)},e.addSelection=function(t){var e=document.createElement("span");return e.style.fontSize="13px",e.style.fontWeight="300",e.style.float="right",this.selection=e,this.setSelectionTitle(t),this.appendChild(e),this},e.addIcon=function(t=p.ChevronRight,e=!1,i=!1){var n=document.createElement("span");return n.style.float=e?"left":"right",n.style.width="17px",n.style.height="17px",n.style["margin"+(e?"Right":"Left")]="12px",n.style.backgroundSize="cover",i&&(n.style.transform="rotateZ(180deg)"),this.icon=n,this.setIcon(t),this.appendChild(n),this},e.addSubMenu=function(t,e){return this.subMenu=i.createSubMenu(t,e),this},e.addEventListener("mouseenter",function(){this.style.backgroundColor="#e0e0e0"},!1),e.addEventListener("mouseleave",function(){this.style.backgroundColor="#fafafa"},!1),e},createMenuItemHeader:function(t){t=this.createMenuItem(t);return t.style.borderBottom="1px solid #333",t.style.paddingBottom="15px",t},createMainMenu:function(e){let n=this,i=this.createMenu();function s(t){t.preventDefault(),t.stopPropagation();let e=n.mainMenu,i=this.subMenu;e.hide(),e.slideAll(),e.parentElement.appendChild(i),n.activeMainItem=this,n.activeSubMenu=i,window.requestAnimationFrame(function(){e.changeSize(i.clientWidth),i.show(),i.unslideAll()})}i._width=200,i.changeSize(i._width);for(let t=0;t<e.length;t++){var o,a=i.addItem(e[t].title);a.style.paddingLeft="20px",a.addIcon().addEventListener(n.TOUCH_ENABLED?"touchend":"click",s,!1),e[t].subMenu&&0<e[t].subMenu.length&&(o=e[t].subMenu[0].title,a.addSelection(o).addSubMenu(e[t].title,e[t].subMenu))}return i},createSubMenu:function(t,e){let i=this,n,s=this.createMenu();function o(t){t.preventDefault(),t.stopPropagation(),(n=i.mainMenu).changeSize(n._width),n.unslideAll(),n.show(),s.slideAll(!0),s.hide(),"header"!==this.type&&(s.setActiveItem(this),i.activeMainItem.setSelectionTitle(this.textContent),this.handler)&&this.handler()}s.items=e,s.activeItem=null,s.addHeader(t).addIcon(void 0,!0,!0).addEventListener(i.TOUCH_ENABLED?"touchend":"click",o,!1);for(let t=0;t<e.length;t++){var a=s.addItem(e[t].title);a.style.fontWeight=300,a.handler=e[t].handler,a.addIcon(" ",!0),a.addEventListener(i.TOUCH_ENABLED?"touchend":"click",o,!1),s.activeItem||s.setActiveItem(a)}return s.slideAll(!0),s},createMenu:function(){const e=this,i=document.createElement("span");var t=i.style;return t.padding="5px 0",t.position="fixed",t.bottom="100%",t.right="14px",t.backgroundColor="#fafafa",t.fontFamily="Helvetica Neue",t.fontSize="14px",t.visibility="hidden",t.opacity=0,t.boxShadow="0 0 12pt rgba(0,0,0,0.25)",t.borderRadius="2px",t.overflow="hidden",t.willChange="width, height, opacity",t.pointerEvents="auto",t.transition=this.DEFAULT_TRANSITION,i.visible=!1,i.changeSize=function(t,e){t&&(this.style.width=t+"px"),e&&(this.style.height=e+"px")},i.show=function(){this.style.opacity=1,this.style.visibility="visible",this.visible=!0},i.hide=function(){this.style.opacity=0,this.style.visibility="hidden",this.visible=!1},i.toggle=function(){this.visible?this.hide():this.show()},i.slideAll=function(e){for(let t=0;t<i.children.length;t++)i.children[t].slide&&i.children[t].slide(e)},i.unslideAll=function(){for(let t=0;t<i.children.length;t++)i.children[t].unslide&&i.children[t].unslide()},i.addHeader=function(t){t=e.createMenuItemHeader(t);return t.type="header",this.appendChild(t),t},i.addItem=function(t){t=e.createMenuItem(t);return t.type="item",this.appendChild(t),t},i.setActiveItem=function(t){this.activeItem&&this.activeItem.setIcon(" "),t.setIcon(p.Check),this.activeItem=t},i.addEventListener("mousemove",this.PREVENT_EVENT_HANDLER,!0),i.addEventListener("mouseup",this.PREVENT_EVENT_HANDLER,!0),i.addEventListener("mousedown",this.PREVENT_EVENT_HANDLER,!0),i},createCustomItem:function(t={}){const e=this,i=t.element||document.createElement("span"),n=t["onDispose"];return i.style.cursor="pointer",i.style.float="right",i.style.width="44px",i.style.height="100%",i.style.backgroundSize="60%",i.style.backgroundRepeat="no-repeat",i.style.backgroundPosition="center",i.style.webkitUserSelect=i.style.MozUserSelect=i.style.userSelect="none",i.style.position="relative",i.style.pointerEvents="auto",i.addEventListener(e.TOUCH_ENABLED?"touchstart":"mouseenter",function(){i.style.filter=i.style.webkitFilter="drop-shadow(0 0 5px rgba(255,255,255,1))"},{passive:!0}),i.addEventListener(e.TOUCH_ENABLED?"touchend":"mouseleave",function(){i.style.filter=i.style.webkitFilter=""},{passive:!0}),this.mergeStyleOptions(i,t.style),t.onTap&&i.addEventListener(e.TOUCH_ENABLED?"touchend":"click",t.onTap,!1),i.dispose=function(){i.removeEventListener(e.TOUCH_ENABLED?"touchend":"click",t.onTap,!1),n&&t.onDispose()},i},mergeStyleOptions:function(t,e={}){for(var i in e)e.hasOwnProperty(i)&&(t.style[i]=e[i]);return t},dispose:function(){this.barElement&&(this.container.removeChild(this.barElement),this.barElement.dispose(),this.barElement=null)}});const A={uniforms:{tEquirect:{value:new X.Texture},repeat:{value:new X.Vector2(1,1)},offset:{value:new X.Vector2(0,0)},opacity:{value:1}},vertexShader:`
        varying vec3 vWorldDirection;
        #include <common>
        void main() {
            vWorldDirection = transformDirection( position, modelMatrix );
            #include <begin_vertex>
            #include <project_vertex>
        }
    `,fragmentShader:`
        uniform sampler2D tEquirect;
        uniform vec2 repeat;
        uniform vec2 offset;
        uniform float opacity;
        varying vec3 vWorldDirection;
        #include <common>
        void main() {
            vec3 direction = normalize( vWorldDirection );
            vec2 sampleUV;
            sampleUV.y = asin( clamp( direction.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;
            sampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;
            sampleUV *= repeat;
            sampleUV += offset;
            vec4 texColor = texture2D( tEquirect, sampleUV );
            gl_FragColor = mapTexelToLinear( texColor );
            gl_FragColor.a *= opacity;
            #include <tonemapping_fragment>
            #include <encodings_fragment>
        }
    `};function y(){this.edgeLength=1e4,X.Mesh.call(this,this.createGeometry(this.edgeLength),this.createMaterial()),this.type="panorama",this.ImageQualityLow=1,this.ImageQualityFair=2,this.ImageQualityMedium=3,this.ImageQualityHigh=4,this.ImageQualitySuperHigh=5,this.animationDuration=1e3,this.defaultInfospotSize=350,this.container=void 0,this.loaded=!1,this.linkedSpots=[],this.isInfospotVisible=!1,this.linkingImageURL=void 0,this.linkingImageScale=void 0,this.renderOrder=-1,this.active=!1,this.infospotAnimation=new v.Tween(this).to({},this.animationDuration/2),this.addEventListener("load",this.fadeIn.bind(this)),this.addEventListener("panolens-container",this.setContainer.bind(this)),this.addEventListener("click",this.onClick.bind(this)),this.setupTransitions()}function E(t){y.call(this),this.src=t,this.type="image_panorama"}function b(){y.call(this),this.type="empty_panorama"}function w(t=[]){y.call(this),this.images=t,this.type="cube_panorama"}function M(){var e=[];for(let t=0;t<6;t++)e.push(p.WhiteTile);w.call(this,e),this.type="basic_panorama"}function C(t,e={}){y.call(this),this.src=t,this.options=Object.assign({videoElement:document.createElement("video"),loop:!0,muted:!0,autoplay:!1,playsinline:!0,crossOrigin:"anonymous"},e),this.videoElement=this.options.videoElement,this.videoProgress=0,this.type="video_panorama",this.addEventListener("leave",this.pauseVideo.bind(this)),this.addEventListener("enter-fade-start",this.resumeVideoProgress.bind(this)),this.addEventListener("video-toggle",this.toggleVideo.bind(this)),this.addEventListener("video-time",this.setVideoCurrentTime.bind(this))}function I(t={}){this._parameters=t,this._zoom=null,this._panoId=null,this._panoClient=new google.maps.StreetViewService,this._count=0,this._total=0,this._canvas=[],this._ctx=[],this._wc=0,this._hc=0,this.result=null,this.rotation=0,this.copyright="",this.onSizeChange=null,this.onPanoramaLoad=null,this.levelsW=[1,2,4,7,13,26],this.levelsH=[1,1,2,4,7,13],this.widths=[416,832,1664,3328,6656,13312],this.heights=[416,416,832,1664,3328,6656],this.maxW=6656,this.maxH=6656;let e;try{var i=document.createElement("canvas");e=(e=i.getContext("experimental-webgl"))||i.getContext("webgl")}catch(t){}this.maxW=Math.max(e.getParameter(e.MAX_TEXTURE_SIZE),this.maxW),this.maxH=Math.max(e.getParameter(e.MAX_TEXTURE_SIZE),this.maxH)}function L(t,e){E.call(this),this.panoId=t,this.gsvLoader=null,this.loadRequested=!1,this.setupGoogleMapAPI(e),this.type="google_streetview_panorama"}y.prototype=Object.assign(Object.create(X.Mesh.prototype),{constructor:y,createGeometry:function(t){return new X.BoxBufferGeometry(t,t,t)},createMaterial:function(t=new X.Vector2(1,1),e=new X.Vector2(0,0)){var{fragmentShader:i,vertexShader:n}=A,s=X.UniformsUtils.clone(A.uniforms),t=(s.repeat.value.copy(t),s.offset.value.copy(e),s.opacity.value=0,new X.ShaderMaterial({fragmentShader:i,vertexShader:n,uniforms:s,side:X.BackSide,transparent:!0,opacity:0}));return t},add:function(t){if(1<arguments.length){for(let t=0;t<arguments.length;t++)this.add(arguments[t]);return this}var e;t instanceof f&&(e=this["container"],e&&t.dispatchEvent({type:"panolens-container",container:e}),t.dispatchEvent({type:"panolens-infospot-focus",method:function(t,e,i){this.dispatchEvent({type:"panolens-viewer-handler",method:"tweenControlCenter",data:[t,e,i]})}.bind(this)})),X.Object3D.prototype.add.call(this,t)},getTexture:function(){return this.material.uniforms.tEquirect.value},load:function(){this.onLoad()},onClick:function(t){t.intersects&&0===t.intersects.length&&this.traverse(function(t){t.dispatchEvent({type:"dismiss"})})},setContainer:function(t){let e;t instanceof HTMLElement?e=t:t&&t.container&&(e=t.container),e&&(this.children.forEach(function(t){t instanceof f&&t.dispatchEvent&&t.dispatchEvent({type:"panolens-container",container:e})}),this.container=e)},onLoad:function(){this.loaded=!0,this.dispatchEvent({type:"load"})},onProgress:function(t){this.dispatchEvent({type:"progress",progress:t})},onError:function(){this.dispatchEvent({type:"error"})},getZoomLevel:function(){let t;return t=window.innerWidth<=800?this.ImageQualityFair:800<window.innerWidth&&window.innerWidth<=1280?this.ImageQualityMedium:1280<window.innerWidth&&window.innerWidth<=1920?this.ImageQualityHigh:1920<window.innerWidth?this.ImageQualitySuperHigh:this.ImageQualityLow},updateTexture:function(t){this.material.uniforms.tEquirect.value=t},toggleInfospotVisibility:function(t,e){e=void 0!==e?e:0;const i=void 0!==t?t:!this.isInfospotVisible;this.traverse(function(t){t instanceof f&&(i?t.show(e):t.hide(e))}),this.isInfospotVisible=i,this.infospotAnimation.onComplete(function(){this.dispatchEvent({type:"infospot-animation-complete",visible:i})}.bind(this)).delay(e).start()},setLinkingImage:function(t,e){this.linkingImageURL=t,this.linkingImageScale=e},link:function(t,e,i,n){let s,o;this.visible=!0,e?(s=void 0!==i?i:void 0!==t.linkingImageScale?t.linkingImageScale:300,o=n||t.linkingImageURL||p.Arrow,(i=new f(s,o)).position.copy(e),i.toPanorama=t,i.addEventListener("click",function(){this.dispatchEvent({type:"panolens-viewer-handler",method:"setPanorama",data:t})}.bind(this)),this.linkedSpots.push(i),this.add(i),this.visible=!1):console.warn("Please specify infospot position for linking")},reset:function(){this.children.length=0},setupTransitions:function(){this.fadeInAnimation=new v.Tween(this.material).easing(v.Easing.Quartic.Out).onStart(function(){this.visible=!0,this.dispatchEvent({type:"enter-fade-start"})}.bind(this)),this.fadeOutAnimation=new v.Tween(this.material).easing(v.Easing.Quartic.Out).onComplete(function(){this.visible=!1,this.dispatchEvent({type:"leave-complete"})}.bind(this)),this.enterTransition=new v.Tween(this).easing(v.Easing.Quartic.Out).onComplete(function(){this.dispatchEvent({type:"enter-complete"})}.bind(this)).start(),this.leaveTransition=new v.Tween(this).easing(v.Easing.Quartic.Out)},onFadeAnimationUpdate:function(){var t=this.material.opacity,e=this.material["uniforms"];e&&e.opacity&&(e.opacity.value=t)},fadeIn:function(t){t=0<=t?t:this.animationDuration,this.fadeOutAnimation.stop(),this.fadeInAnimation.to({opacity:1},t).onUpdate(this.onFadeAnimationUpdate.bind(this)).onComplete(function(){this.toggleInfospotVisibility(!0,t/2),this.dispatchEvent({type:"enter-fade-complete"})}.bind(this)).start()},fadeOut:function(t){t=0<=t?t:this.animationDuration,this.fadeInAnimation.stop(),this.fadeOutAnimation.to({opacity:0},t).onUpdate(this.onFadeAnimationUpdate.bind(this)).start()},onEnter:function(){const t=this.animationDuration;this.dispatchEvent({type:"enter"}),this.leaveTransition.stop(),this.enterTransition.to({},t).onStart(function(){this.dispatchEvent({type:"enter-start"}),this.loaded?this.fadeIn(t):this.load()}.bind(this)).start(),this.children.forEach(t=>{t.dispatchEvent({type:"panorama-enter"})}),this.active=!0},onLeave:function(){const t=this.animationDuration;this.enterTransition.stop(),this.leaveTransition.to({},t).onStart(function(){this.dispatchEvent({type:"leave-start"}),this.fadeOut(t),this.toggleInfospotVisibility(!1)}.bind(this)).start(),this.dispatchEvent({type:"leave"}),this.children.forEach(t=>{t.dispatchEvent({type:"panorama-leave"})}),this.active=!1},dispose:function(){var t=this["material"];t&&t.uniforms&&t.uniforms.tEquirect&&t.uniforms.tEquirect.value.dispose(),this.infospotAnimation.stop(),this.fadeInAnimation.stop(),this.fadeOutAnimation.stop(),this.enterTransition.stop(),this.leaveTransition.stop(),this.dispatchEvent({type:"panolens-viewer-handler",method:"onPanoramaDispose",data:this}),function e(i){var{geometry:t,material:n}=i;for(let t=i.children.length-1;0<=t;t--)e(i.children[t]),i.remove(i.children[t]);i instanceof f&&i.dispose(),t&&(t.dispose(),i.geometry=null),n&&(n.dispose(),i.material=null)}(this),this.parent&&this.parent.remove(this)}}),E.prototype=Object.assign(Object.create(y.prototype),{constructor:E,load:function(t){(t=t||this.src)?"string"==typeof t?c.load(t,this.onLoad.bind(this),this.onProgress.bind(this),this.onError.bind(this)):t instanceof HTMLImageElement&&this.onLoad(new X.Texture(t)):console.warn("Image source undefined")},onLoad:function(t){t.minFilter=t.magFilter=X.LinearFilter,t.needsUpdate=!0,this.updateTexture(t),window.requestAnimationFrame(y.prototype.onLoad.bind(this))},reset:function(){y.prototype.reset.call(this)},dispose:function(){X.Cache.remove(this.src),y.prototype.dispose.call(this)}}),b.prototype=Object.assign(Object.create(y.prototype),{constructor:b,createGeometry:function(){var t=new X.BufferGeometry;return t.addAttribute("position",new X.BufferAttribute(new Float32Array,1)),t},createMaterial:function(){new X.MeshBasicMaterial({color:0,opacity:0,transparent:!0})},getTexture:function(){return null}}),w.prototype=Object.assign(Object.create(y.prototype),{constructor:w,createMaterial:function(){var{fragmentShader:t,vertexShader:e,uniforms:i}=X.ShaderLib.cube,i=X.UniformsUtils.clone(i),t=(i.opacity.value=0,new X.ShaderMaterial({fragmentShader:t,vertexShader:e,uniforms:i,side:X.BackSide,transparent:!0,opacity:0}));return t},load:function(){s.load(this.images,this.onLoad.bind(this),this.onProgress.bind(this),this.onError.bind(this))},onLoad:function(t){this.material.uniforms.tCube.value=t,y.prototype.onLoad.call(this)},getTexture:function(){return this.material.uniforms.tCube.value},dispose:function(){var t=this.material.uniforms.tCube["value"];this.images.forEach(t=>{X.Cache.remove(t)}),t instanceof X.CubeTexture&&t.dispose(),y.prototype.dispose.call(this)}}),M.prototype=Object.assign(Object.create(w.prototype),{constructor:M}),C.prototype=Object.assign(Object.create(y.prototype),{constructor:C,isMobile:function(){let t=!1;var e;return e=window.navigator.userAgent||window.navigator.vendor||window.opera,t=/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(e)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(e.substr(0,4))?!0:t},load:function(){const{muted:e,loop:t,autoplay:i,playsinline:n,crossOrigin:s}=this.options,o=this.videoElement,a=this.onProgress.bind(this),r=this.onLoad.bind(this);o.loop=t,o.autoplay=i,o.playsinline=n,o.crossOrigin=s,o.muted=e,n&&(o.setAttribute("playsinline",""),o.setAttribute("webkit-playsinline",""));function c(){const t=this.setVideoTexture(o);i&&this.dispatchEvent({type:"panolens-viewer-handler",method:"updateVideoPlayButton",data:!1}),this.isMobile()&&(o.pause(),i&&e?this.dispatchEvent({type:"panolens-viewer-handler",method:"updateVideoPlayButton",data:!1}):this.dispatchEvent({type:"panolens-viewer-handler",method:"updateVideoPlayButton",data:!0})),window.requestAnimationFrame(()=>{a({loaded:1,total:1}),r(t)})}var h;2<o.readyState?c.call(this):(0===o.querySelectorAll("source").length&&((h=document.createElement("source")).src=this.src,o.appendChild(h)),o.load()),o.addEventListener("loadeddata",c.bind(this)),o.addEventListener("timeupdate",function(){this.videoProgress=0<=o.duration?o.currentTime/o.duration:0,this.dispatchEvent({type:"panolens-viewer-handler",method:"onVideoUpdate",data:this.videoProgress})}.bind(this)),o.addEventListener("ended",function(){t||(this.resetVideo(),this.dispatchEvent({type:"panolens-viewer-handler",method:"updateVideoPlayButton",data:!0}))}.bind(this),!1)},onLoad:function(){y.prototype.onLoad.call(this)},setVideoTexture:function(t){if(t)return(t=new X.VideoTexture(t)).minFilter=X.LinearFilter,t.magFilter=X.LinearFilter,t.format=X.RGBFormat,this.updateTexture(t),t},reset:function(){this.videoElement=void 0,y.prototype.reset.call(this)},isVideoPaused:function(){return this.videoElement.paused},toggleVideo:function(){var t=this.videoElement;t&&t[t.paused?"play":"pause"]()},setVideoCurrentTime:function({percentage:t}){var e=this.videoElement;e&&!Number.isNaN(t)&&1!==t&&(e.currentTime=e.duration*t,this.dispatchEvent({type:"panolens-viewer-handler",method:"onVideoUpdate",data:t}))},playVideo:function(){var t=this.videoElement;const e=this.playVideo.bind(this),i=this.dispatchEvent.bind(this);t&&t.paused&&t.play().then(()=>{i({type:"play"})}).catch(t=>{window.requestAnimationFrame(e),i({type:"play-error",error:t})})},pauseVideo:function(){var t=this.videoElement;t&&!t.paused&&t.pause(),this.dispatchEvent({type:"pause"})},resumeVideoProgress:function(){var t=this.videoElement;4<=t.readyState&&t.autoplay&&!this.isMobile()?(this.playVideo(),this.dispatchEvent({type:"panolens-viewer-handler",method:"updateVideoPlayButton",data:!1})):(this.pauseVideo(),this.dispatchEvent({type:"panolens-viewer-handler",method:"updateVideoPlayButton",data:!0})),this.setVideoCurrentTime({percentage:this.videoProgress})},resetVideo:function(){this.videoElement&&this.setVideoCurrentTime({percentage:0})},isVideoMuted:function(){return this.videoElement.muted},muteVideo:function(){var t=this.videoElement;t&&!t.muted&&(t.muted=!0),this.dispatchEvent({type:"volumechange"})},unmuteVideo:function(){var t=this.videoElement;t&&this.isVideoMuted()&&(t.muted=!1),this.dispatchEvent({type:"volumechange"})},getVideoElement:function(){return this.videoElement},dispose:function(){this.pauseVideo(),this.removeEventListener("leave",this.pauseVideo.bind(this)),this.removeEventListener("enter-fade-start",this.resumeVideoProgress.bind(this)),this.removeEventListener("video-toggle",this.toggleVideo.bind(this)),this.removeEventListener("video-time",this.setVideoCurrentTime.bind(this)),y.prototype.dispose.call(this)}}),Object.assign(I.prototype,{constructor:I,setProgress:function(t,e){this.onProgress&&this.onProgress({loaded:t,total:e})},adaptTextureToZoom:function(){var i=this.widths[this._zoom],n=this.heights[this._zoom],s=this.maxW,o=this.maxH;this._wc=Math.ceil(i/s),this._hc=Math.ceil(n/o);for(let e=0;e<this._hc;e++)for(let t=0;t<this._wc;t++){var a=document.createElement("canvas");t<this._wc-1?a.width=s:a.width=i-s*t,e<this._hc-1?a.height=o:a.height=n-o*e,this._canvas.push(a),this._ctx.push(a.getContext("2d"))}},composeFromTile:function(t,e,i){var n=this.maxW,s=this.maxH,o=(t*=512,e*=512,Math.floor(t/n)),a=Math.floor(e/s);this._ctx[a*this._wc+o].drawImage(i,0,0,i.width,i.height,t-=o*n,e-=a*s,512,512),this.progress()},progress:function(){this._count++,this.setProgress(this._count,this._total),this._count===this._total&&(this.canvas=this._canvas,this.panoId=this._panoId,this.zoom=this._zoom,this.onPanoramaLoad)&&this.onPanoramaLoad(this._canvas[0])},composePanorama:function(){this.setProgress(0,1);var i=this.levelsW[this._zoom],t=this.levelsH[this._zoom];const s=this,o=(this._count=0,this._total=i*t,this._parameters)["useWebGL"];for(let e=0;e<t;e++)for(let t=0;t<i;t++){const a="https://geo0.ggpht.com/cbk?cb_client=maps_sv.tactile&authuser=0&hl=en&output=tile&zoom="+this._zoom+"&x="+t+"&y="+e+"&panoid="+this._panoId+"&nbt&fover=2";!function(t,e){if(o){const n=c.load(a,null,function(){s.composeFromTile(t,e,n)})}else{var i=new Image;i.addEventListener("load",function(){s.composeFromTile(t,e,this)}),i.crossOrigin="",i.src=a}}(t,e)}},load:function(t){this.loadPano(t)},loadPano:function(t){const i=this;this._panoClient.getPanoramaById(t,function(t,e){e===google.maps.StreetViewStatus.OK&&(i.result=t,i.copyright=t.copyright,i._panoId=t.location.pano,i.composePanorama())})},setZoom:function(t){this._zoom=t,this.adaptTextureToZoom()}}),L.prototype=Object.assign(Object.create(E.prototype),{constructor:L,load:function(t){this.loadRequested=!0,(t=t||this.panoId||{})&&this.gsvLoader&&this.loadGSVLoader(t)},setupGoogleMapAPI:function(t){var e=document.createElement("script");e.src="https://maps.googleapis.com/maps/api/js?",e.src+=t?"key="+t:"",e.onreadystatechange=this.setGSVLoader.bind(this),e.onload=this.setGSVLoader.bind(this),document.querySelector("head").appendChild(e)},setGSVLoader:function(){this.gsvLoader=new I,this.loadRequested&&this.load()},getGSVLoader:function(){return this.gsvLoader},loadGSVLoader:function(t){this.loadRequested=!1,this.gsvLoader.onProgress=this.onProgress.bind(this),this.gsvLoader.onPanoramaLoad=this.onLoad.bind(this),this.gsvLoader.setZoom(this.getZoomLevel()),this.gsvLoader.load(t),this.gsvLoader.loaded=!0},onLoad:function(t){E.prototype.onLoad.call(this,new X.Texture(t))},reset:function(){this.gsvLoader=void 0,E.prototype.reset.call(this)}});const P={uniforms:{tDiffuse:{value:new X.Texture},resolution:{value:1},transform:{value:new X.Matrix4},zoom:{value:1},opacity:{value:1}},vertexShader:`

        varying vec2 vUv;

        void main() {

            vUv = uv;
            gl_Position = vec4( position, 1.0 );

        }

    `,fragmentShader:`

        uniform sampler2D tDiffuse;
        uniform float resolution;
        uniform mat4 transform;
        uniform float zoom;
        uniform float opacity;

        varying vec2 vUv;

        const float PI = 3.141592653589793;

        void main(){

            vec2 position = -1.0 +  2.0 * vUv;

            position *= vec2( zoom * resolution, zoom * 0.5 );

            float x2y2 = position.x * position.x + position.y * position.y;
            vec3 sphere_pnt = vec3( 2. * position, x2y2 - 1. ) / ( x2y2 + 1. );

            sphere_pnt = vec3( transform * vec4( sphere_pnt, 1.0 ) );

            vec2 sampleUV = vec2(
                (atan(sphere_pnt.y, sphere_pnt.x) / PI + 1.0) * 0.5,
                (asin(sphere_pnt.z) / PI + 0.5)
            );

            gl_FragColor = texture2D( tDiffuse, sampleUV );
            gl_FragColor.a *= opacity;

        }
    `};function T(t="image",e){"image"===t&&E.call(this,e),this.EPS=1e-6,this.frameId=null,this.dragging=!1,this.userMouse=new X.Vector2,this.quatA=new X.Quaternion,this.quatB=new X.Quaternion,this.quatCur=new X.Quaternion,this.quatSlerp=new X.Quaternion,this.vectorX=new X.Vector3(1,0,0),this.vectorY=new X.Vector3(0,1,0),this.type="little_planet",this.addEventListener("window-resize",this.onWindowResize)}function R(t){T.call(this,"image",t),this.type="image_little_planet"}function S(t){y.call(this),this.media=new o(t),this.type="camera_panorama",this.addEventListener("enter",this.start.bind(this)),this.addEventListener("leave",this.stop.bind(this)),this.addEventListener("panolens-container",this.onPanolensContainer.bind(this)),this.addEventListener("panolens-scene",this.onPanolensScene.bind(this))}function x(t,e=new h){E.call(this,t),this.stereo=e,this.type="stereo_image_panorama"}function O(t,e={},i=new h){C.call(this,t,e),this.stereo=i,this.type="stereo_video_panorama"}function D(t,V){this.object=t,this.domElement=void 0!==V?V:document,this.frameId=null,this.enabled=!0,this.target=new X.Vector3,this.center=this.target,this.noZoom=!1,this.zoomSpeed=1,this.minDistance=0,this.maxDistance=1/0,this.minZoom=0,this.maxZoom=1/0,this.noRotate=!1,this.rotateSpeed=-.15,this.noPan=!0,this.keyPanSpeed=7,this.autoRotate=!1,this.autoRotateSpeed=2,this.minPolarAngle=0,this.maxPolarAngle=Math.PI,this.momentumDampingFactor=.9,this.momentumScalingFactor=-.005,this.momentumKeydownFactor=20,this.minFov=30,this.maxFov=120,this.minAzimuthAngle=-1/0,this.maxAzimuthAngle=1/0,this.noKeys=!1,this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40},this.mouseButtons={ORBIT:X.MOUSE.LEFT,ZOOM:X.MOUSE.MIDDLE,PAN:X.MOUSE.RIGHT};const s=this,o=new X.Vector2,a=new X.Vector2,r=new X.Vector2,c=new X.Vector2,h=new X.Vector2,l=new X.Vector2,i=new X.Vector3,n=new X.Vector3,d=new X.Vector2,u=new X.Vector2,p=new X.Vector2;let m=0,v=0,f=0,g=0,A=1;const y=new X.Vector3,E=new X.Vector3,b=new X.Quaternion;let w=0,M=0,C,I=!1,e,L,T,R;const S={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_DOLLY:4,TOUCH_PAN:5};let x=S.NONE;this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.zoom0=this.object.zoom;const U=(new X.Quaternion).setFromUnitVectors(t.up,new X.Vector3(0,1,0)),B=U.clone().inverse(),O={type:"change"},D={type:"start"},k={type:"end"};function j(){return 2*Math.PI/60/60*s.autoRotateSpeed}function _(){return Math.pow(.95,s.zoomSpeed)}function N(t){if(I=!1,w=M=0,!1!==s.enabled){if(t.preventDefault(),t.button===s.mouseButtons.ORBIT){if(!0===s.noRotate)return;x=S.ROTATE,o.set(t.clientX,t.clientY)}else if(t.button===s.mouseButtons.ZOOM){if(!0===s.noZoom)return;x=S.DOLLY,d.set(t.clientX,t.clientY)}else if(t.button===s.mouseButtons.PAN){if(!0===s.noPan)return;x=S.PAN,c.set(t.clientX,t.clientY)}x!==S.NONE&&(document.addEventListener("mousemove",z,!1),document.addEventListener("mouseup",F,!1),s.dispatchEvent(D)),s.update()}}function z(t){if(!1!==s.enabled){t.preventDefault();var e=s.domElement===document?s.domElement.body:s.domElement;if(x===S.ROTATE){if(!0===s.noRotate)return;a.set(t.clientX,t.clientY),r.subVectors(a,o),s.rotateLeft(2*Math.PI*r.x/e.clientWidth*s.rotateSpeed),s.rotateUp(2*Math.PI*r.y/e.clientHeight*s.rotateSpeed),o.copy(a),C&&(w=t.clientX-C.clientX,M=t.clientY-C.clientY),C=t}else if(x===S.DOLLY){if(!0===s.noZoom)return;u.set(t.clientX,t.clientY),p.subVectors(u,d),0<p.y?s.dollyIn():p.y<0&&s.dollyOut(),d.copy(u)}else if(x===S.PAN){if(!0===s.noPan)return;h.set(t.clientX,t.clientY),l.subVectors(h,c),s.pan(l.x,l.y),c.copy(h)}x!==S.NONE&&s.update()}}function F(){I=!0,C=void 0,!1!==s.enabled&&(document.removeEventListener("mousemove",z,!1),document.removeEventListener("mouseup",F,!1),s.dispatchEvent(k),x=S.NONE)}function P(e){if(!1!==s.enabled&&!0!==s.noZoom&&x===S.NONE){e.preventDefault(),e.stopPropagation();let t=0;void 0!==e.wheelDelta?t=e.wheelDelta:void 0!==e.detail&&(t=-e.detail),0<t?(s.object.fov=s.object.fov<s.maxFov?s.object.fov+1:s.maxFov,s.object.updateProjectionMatrix()):t<0&&(s.object.fov=s.object.fov>s.minFov?s.object.fov-1:s.minFov,s.object.updateProjectionMatrix()),s.update(),s.dispatchEvent(O),s.dispatchEvent(D),s.dispatchEvent(k)}}function H(t){switch(t.keyCode){case s.keys.UP:e=!1;break;case s.keys.BOTTOM:L=!1;break;case s.keys.LEFT:T=!1;break;case s.keys.RIGHT:R=!1}}function W(t){if(!1!==s.enabled&&!0!==s.noKeys&&!0!==s.noRotate){switch(t.keyCode){case s.keys.UP:e=!0;break;case s.keys.BOTTOM:L=!0;break;case s.keys.LEFT:T=!0;break;case s.keys.RIGHT:R=!0}(e||L||T||R)&&(I=!0,e&&(M=-s.rotateSpeed*s.momentumKeydownFactor),L&&(M=s.rotateSpeed*s.momentumKeydownFactor),T&&(w=-s.rotateSpeed*s.momentumKeydownFactor),R)&&(w=s.rotateSpeed*s.momentumKeydownFactor)}}function Z(t){if(I=!1,w=M=0,!1!==s.enabled){switch(t.touches.length){case 1:if(!0===s.noRotate)return;x=S.TOUCH_ROTATE,o.set(t.touches[0].pageX,t.touches[0].pageY);break;case 2:if(!0===s.noZoom)return;x=S.TOUCH_DOLLY;var e=t.touches[0].pageX-t.touches[1].pageX,i=t.touches[0].pageY-t.touches[1].pageY,e=Math.sqrt(e*e+i*i);d.set(0,e);break;case 3:if(!0===s.noPan)return;x=S.TOUCH_PAN,c.set(t.touches[0].pageX,t.touches[0].pageY);break;default:x=S.NONE}x!==S.NONE&&s.dispatchEvent(D)}}function Q(t){if(!1!==s.enabled){t.preventDefault(),t.stopPropagation();var e,i,n=s.domElement===document?s.domElement.body:s.domElement;switch(t.touches.length){case 1:!0!==s.noRotate&&x===S.TOUCH_ROTATE&&(a.set(t.touches[0].pageX,t.touches[0].pageY),r.subVectors(a,o),s.rotateLeft(2*Math.PI*r.x/n.clientWidth*s.rotateSpeed),s.rotateUp(2*Math.PI*r.y/n.clientHeight*s.rotateSpeed),o.copy(a),C&&(w=t.touches[0].pageX-C.pageX,M=t.touches[0].pageY-C.pageY),C={pageX:t.touches[0].pageX,pageY:t.touches[0].pageY},s.update());break;case 2:!0!==s.noZoom&&x===S.TOUCH_DOLLY&&(i=t.touches[0].pageX-t.touches[1].pageX,e=t.touches[0].pageY-t.touches[1].pageY,i=Math.sqrt(i*i+e*e),u.set(0,i),p.subVectors(u,d),p.y<0?(s.object.fov=s.object.fov<s.maxFov?s.object.fov+1:s.maxFov,s.object.updateProjectionMatrix()):0<p.y&&(s.object.fov=s.object.fov>s.minFov?s.object.fov-1:s.minFov,s.object.updateProjectionMatrix()),d.copy(u),s.update(),s.dispatchEvent(O));break;case 3:!0!==s.noPan&&x===S.TOUCH_PAN&&(h.set(t.touches[0].pageX,t.touches[0].pageY),l.subVectors(h,c),s.pan(l.x,l.y),c.copy(h),s.update());break;default:x=S.NONE}}}function G(){I=!0,C=void 0,!1!==s.enabled&&(s.dispatchEvent(k),x=S.NONE)}this.setLastQuaternion=function(t){b.copy(t),s.object.quaternion.copy(t)},this.getLastPosition=function(){return E},this.rotateLeft=function(t){void 0===t&&(t=j()),g-=t},this.rotateUp=function(t){void 0===t&&(t=j()),f-=t},this.panLeft=function(t){var e=this.object.matrix.elements;i.set(e[0],e[1],e[2]),i.multiplyScalar(-t),y.add(i)},this.panUp=function(t){var e=this.object.matrix.elements;i.set(e[4],e[5],e[6]),i.multiplyScalar(t),y.add(i)},this.pan=function(t,e){var i,n=s.domElement===document?s.domElement.body:s.domElement;s.object instanceof X.PerspectiveCamera?(i=s.object.position.clone().sub(s.target).length(),i*=Math.tan(s.object.fov/2*Math.PI/180),s.panLeft(2*t*i/n.clientHeight),s.panUp(2*e*i/n.clientHeight)):s.object instanceof X.OrthographicCamera?(s.panLeft(t*(s.object.right-s.object.left)/n.clientWidth),s.panUp(e*(s.object.top-s.object.bottom)/n.clientHeight)):console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled.")},this.momentum=function(){I&&(Math.abs(w)<1e-4&&Math.abs(M)<1e-4?I=!1:(M*=this.momentumDampingFactor,w*=this.momentumDampingFactor,g-=this.momentumScalingFactor*w,f-=this.momentumScalingFactor*M))},this.dollyIn=function(t){void 0===t&&(t=_()),s.object instanceof X.PerspectiveCamera?A/=t:s.object instanceof X.OrthographicCamera?(s.object.zoom=Math.max(this.minZoom,Math.min(this.maxZoom,this.object.zoom*t)),s.object.updateProjectionMatrix(),s.dispatchEvent(O)):console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled.")},this.dollyOut=function(t){void 0===t&&(t=_()),s.object instanceof X.PerspectiveCamera?A*=t:s.object instanceof X.OrthographicCamera?(s.object.zoom=Math.max(this.minZoom,Math.min(this.maxZoom,this.object.zoom/t)),s.object.updateProjectionMatrix(),s.dispatchEvent(O)):console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled.")},this.update=function(t){var e=this.object.position,i=(n.copy(e).sub(this.target),n.applyQuaternion(U),m=Math.atan2(n.x,n.z),v=Math.atan2(Math.sqrt(n.x*n.x+n.z*n.z),n.y),this.autoRotate&&x===S.NONE&&this.rotateLeft(j()),this.momentum(),m+=g,v+=f,m=Math.max(this.minAzimuthAngle,Math.min(this.maxAzimuthAngle,m)),v=Math.max(this.minPolarAngle,Math.min(this.maxPolarAngle,v)),v=Math.max(1e-7,Math.min(Math.PI-1e-7,v)),n.length()*A),i=Math.max(this.minDistance,Math.min(this.maxDistance,i));this.target.add(y),n.x=i*Math.sin(v)*Math.sin(m),n.y=i*Math.cos(v),n.z=i*Math.sin(v)*Math.cos(m),n.applyQuaternion(B),e.copy(this.target).add(n),this.object.lookAt(this.target),g=0,f=0,A=1,y.set(0,0,0),(1e-7<E.distanceToSquared(this.object.position)||1e-7<8*(1-b.dot(this.object.quaternion)))&&(!0!==t&&this.dispatchEvent(O),E.copy(this.object.position),b.copy(this.object.quaternion))},this.reset=function(){x=S.NONE,this.target.copy(this.target0),this.object.position.copy(this.position0),this.object.zoom=this.zoom0,this.object.updateProjectionMatrix(),this.dispatchEvent(O),this.update()},this.getPolarAngle=function(){return v},this.getAzimuthalAngle=function(){return m},this.dispose=function(){this.domElement.removeEventListener("mousedown",N),this.domElement.removeEventListener("mousewheel",P),this.domElement.removeEventListener("DOMMouseScroll",P),this.domElement.removeEventListener("touchstart",Z),this.domElement.removeEventListener("touchend",G),this.domElement.removeEventListener("touchmove",Q),window.removeEventListener("keyup",H),window.removeEventListener("keydown",W)},this.domElement.addEventListener("mousedown",N,{passive:!1}),this.domElement.addEventListener("mousewheel",P,{passive:!1}),this.domElement.addEventListener("DOMMouseScroll",P,{passive:!1}),this.domElement.addEventListener("touchstart",Z,{passive:!1}),this.domElement.addEventListener("touchend",G,{passive:!1}),this.domElement.addEventListener("touchmove",Q,{passive:!1}),window.addEventListener("keyup",H,{passive:!1}),window.addEventListener("keydown",W,{passive:!1}),this.update()}function k(t,e){const p=this,m={type:"change"};let v=0,i=0,n=0;this.camera=t,this.camera.rotation.reorder("YXZ"),this.domElement=void 0!==e?e:document,this.enabled=!0,this.deviceOrientation=null,this.screenOrientation=0,this.alpha=0,this.alphaOffsetAngle=0;function s(t){p.deviceOrientation=t}function o(){p.screenOrientation=window.orientation||0}function a(t){t.preventDefault(),t.stopPropagation(),i=t.touches[0].pageX,n=t.touches[0].pageY}function r(t){t.preventDefault(),t.stopPropagation(),v+=X.Math.degToRad((n-t.touches[0].pageY)/4),p.rotateLeft(-X.Math.degToRad((t.touches[0].pageX-i)/4)),i=t.touches[0].pageX,n=t.touches[0].pageY}this.connect=function(){o(),window.addEventListener("orientationchange",o,{passive:!0}),window.addEventListener("deviceorientation",s,{passive:!0}),window.addEventListener("deviceorientation",this.update.bind(this),{passive:!0}),p.domElement.addEventListener("touchstart",a,{passive:!1}),p.domElement.addEventListener("touchmove",r,{passive:!1}),p.enabled=!0},this.disconnect=function(){window.removeEventListener("orientationchange",o,!1),window.removeEventListener("deviceorientation",s,!1),window.removeEventListener("deviceorientation",this.update.bind(this),!1),p.domElement.removeEventListener("touchstart",a,!1),p.domElement.removeEventListener("touchmove",r,!1),p.enabled=!1},this.update=function(t){if(!1!==p.enabled&&p.deviceOrientation){var e=p.deviceOrientation.alpha?X.Math.degToRad(p.deviceOrientation.alpha)+p.alphaOffsetAngle:0,i=p.deviceOrientation.beta?X.Math.degToRad(p.deviceOrientation.beta):0,n=p.deviceOrientation.gamma?X.Math.degToRad(p.deviceOrientation.gamma):0,s=p.screenOrientation?X.Math.degToRad(p.screenOrientation):0;{var o=p.camera.quaternion;var a=e;var r=new X.Vector3(0,0,1),c=new X.Euler,h=new X.Quaternion,l=new X.Quaternion(-Math.sqrt(.5),0,0,Math.sqrt(.5));let t;var d=new X.Quaternion,u=new X.Quaternion;0==p.screenOrientation?(t=new X.Vector3(1,0,0),d.setFromAxisAngle(t,-v)):180==p.screenOrientation?(t=new X.Vector3(1,0,0),d.setFromAxisAngle(t,v)):90==p.screenOrientation?(t=new X.Vector3(0,1,0),d.setFromAxisAngle(t,v)):-90==p.screenOrientation&&(t=new X.Vector3(0,1,0),d.setFromAxisAngle(t,-v)),l.multiply(d),l.multiply(u),c.set(i,a,-n,"YXZ"),o.setFromEuler(c),o.multiply(l),o.multiply(h.setFromAxisAngle(r,-s))}p.alpha=e,!0!==t&&p.dispatchEvent(m)}},this.updateAlphaOffsetAngle=function(t){this.alphaOffsetAngle=t},this.updateRotX=function(t){v=t},this.rotateLeft=function(t){this.updateAlphaOffsetAngle(this.alphaOffsetAngle-t)},this.rotateUp=function(t){this.updateRotX(v+t)},this.dispose=function(){this.disconnect()},this.connect()}function V(o){const a=new X.OrthographicCamera(-1,1,1,-1,0,1),r=new X.Scene,c=new X.StereoCamera;c.aspect=.5;var t={minFilter:X.LinearFilter,magFilter:X.NearestFilter,format:X.RGBAFormat};const h=new X.WebGLRenderTarget(512,512,t);h.scissorTest=!0,h.texture.generateMipmaps=!1;var i=new X.Vector2(.441,.156),t=new X.PlaneBufferGeometry(1,1,10,20).removeAttribute("normal").toNonIndexed(),e=t.attributes.position.array,n=t.attributes.uv.array,s=(t.attributes.position.count*=2,t.attributes.uv.count*=2,new Float32Array(2*e.length)),l=(s.set(e),s.set(e,e.length),new Float32Array(2*n.length)),d=(l.set(n),l.set(n,n.length),new X.Vector2),u=e.length/3;for(let t=0,e=s.length/3;t<e;t++){d.x=s[3*t+0],d.y=s[3*t+1];var p=d.dot(d),p=1.5+(i.x+i.y*p)*p,m=t<u?0:1;s[3*t+0]=d.x/p*1.5-.5+m,s[3*t+1]=d.y/p*3,l[2*t]=.5*(l[2*t]+m)}t.attributes.position.array=s,t.attributes.uv.array=l;n=new X.MeshBasicMaterial({map:h.texture}),e=new X.Mesh(t,n);r.add(e),this.setEyeSeparation=function(t){c.eyeSep=t},this.setSize=function(t,e){o.setSize(t,e);var i=o.getPixelRatio();h.setSize(t*i,e*i)},this.render=function(t,e,i){var n=i instanceof x||i instanceof O,e=(t.updateMatrixWorld(),n&&this.setEyeSeparation(i.stereo.eyeSep),null===e.parent&&e.updateMatrixWorld(),c.update(e),h.width/2),s=h.height;o.autoClear&&o.clear(),n&&i.updateTextureToLeft(),h.scissor.set(0,0,e,s),h.viewport.set(0,0,e,s),o.setRenderTarget(h),o.render(t,c.cameraL),o.clearDepth(),n&&i.updateTextureToRight(),h.scissor.set(e,0,e,s),h.viewport.set(e,0,e,s),o.setRenderTarget(h),o.render(t,c.cameraR),o.clearDepth(),o.setRenderTarget(null),o.render(r,a)}}T.prototype=Object.assign(Object.create(E.prototype),{constructor:T,add:function(t){if(1<arguments.length){for(let t=0;t<arguments.length;t++)this.add(arguments[t]);return this}t instanceof f&&(t.material.depthTest=!1),E.prototype.add.call(this,t)},createGeometry:function(t){return new X.PlaneBufferGeometry(t,.5*t)},createMaterial:function(t=this.edgeLength){var{fragmentShader:e,vertexShader:i,uniforms:n}=P,n=X.UniformsUtils.clone(n);return n.zoom.value=t,n.opacity.value=0,new X.ShaderMaterial({vertexShader:i,fragmentShader:e,uniforms:n,transparent:!0,opacity:0})},registerMouseEvents:function(){this.container.addEventListener("mousedown",this.onMouseDown.bind(this),{passive:!0}),this.container.addEventListener("mousemove",this.onMouseMove.bind(this),{passive:!0}),this.container.addEventListener("mouseup",this.onMouseUp.bind(this),{passive:!0}),this.container.addEventListener("touchstart",this.onMouseDown.bind(this),{passive:!0}),this.container.addEventListener("touchmove",this.onMouseMove.bind(this),{passive:!0}),this.container.addEventListener("touchend",this.onMouseUp.bind(this),{passive:!0}),this.container.addEventListener("mousewheel",this.onMouseWheel.bind(this),{passive:!1}),this.container.addEventListener("DOMMouseScroll",this.onMouseWheel.bind(this),{passive:!1}),this.container.addEventListener("contextmenu",this.onContextMenu.bind(this),{passive:!0})},unregisterMouseEvents:function(){this.container.removeEventListener("mousedown",this.onMouseDown.bind(this),!1),this.container.removeEventListener("mousemove",this.onMouseMove.bind(this),!1),this.container.removeEventListener("mouseup",this.onMouseUp.bind(this),!1),this.container.removeEventListener("touchstart",this.onMouseDown.bind(this),!1),this.container.removeEventListener("touchmove",this.onMouseMove.bind(this),!1),this.container.removeEventListener("touchend",this.onMouseUp.bind(this),!1),this.container.removeEventListener("mousewheel",this.onMouseWheel.bind(this),!1),this.container.removeEventListener("DOMMouseScroll",this.onMouseWheel.bind(this),!1),this.container.removeEventListener("contextmenu",this.onContextMenu.bind(this),!1)},onMouseDown:function(t){switch(t.touches&&t.touches.length||1){case 1:var e=(0<=t.clientX?t:t.touches[0]).clientX,i=(0<=t.clientY?t:t.touches[0]).clientY;this.dragging=!0,this.userMouse.set(e,i);break;case 2:e=t.touches[0].pageX-t.touches[1].pageX,i=t.touches[0].pageY-t.touches[1].pageY,e=Math.sqrt(e*e+i*i);this.userMouse.pinchDistance=e}this.onUpdateCallback()},onMouseMove:function(t){switch(t.touches&&t.touches.length||1){case 1:var e=(0<=t.clientX?t:t.touches[0]).clientX,i=(0<=t.clientY?t:t.touches[0]).clientY,n=.4*X.Math.degToRad(e-this.userMouse.x),s=.4*X.Math.degToRad(i-this.userMouse.y);this.dragging&&(this.quatA.setFromAxisAngle(this.vectorY,n),this.quatB.setFromAxisAngle(this.vectorX,s),this.quatCur.multiply(this.quatA).multiply(this.quatB),this.userMouse.set(e,i));break;case 2:n=t.touches[0].pageX-t.touches[1].pageX,s=t.touches[0].pageY-t.touches[1].pageY,e=Math.sqrt(n*n+s*s);this.addZoomDelta(this.userMouse.pinchDistance-e)}},onMouseUp:function(){this.dragging=!1},onMouseWheel:function(t){t.preventDefault(),t.stopPropagation();let e=0;void 0!==t.wheelDelta?e=t.wheelDelta:void 0!==t.detail&&(e=-t.detail),this.addZoomDelta(e),this.onUpdateCallback()},addZoomDelta:function(t){var e=this.material.uniforms,i=.1*this.size,n=10*this.size;e.zoom.value+=t,e.zoom.value<=i?e.zoom.value=i:e.zoom.value>=n&&(e.zoom.value=n)},onUpdateCallback:function(){this.frameId=window.requestAnimationFrame(this.onUpdateCallback.bind(this)),this.quatSlerp.slerp(this.quatCur,.1),this.material&&this.material.uniforms.transform.value.makeRotationFromQuaternion(this.quatSlerp),!this.dragging&&1-this.quatSlerp.clone().dot(this.quatCur)<this.EPS&&window.cancelAnimationFrame(this.frameId)},reset:function(){this.quatCur.set(0,0,0,1),this.quatSlerp.set(0,0,0,1),this.onUpdateCallback()},updateTexture:function(t){this.material.uniforms.tDiffuse.value=t},getTexture:function(){return this.material.uniforms.tDiffuse.value},onLoad:function(t){this.material.uniforms.resolution.value=this.container.clientWidth/this.container.clientHeight,this.registerMouseEvents(),this.onUpdateCallback(),this.dispatchEvent({type:"panolens-viewer-handler",method:"disableControl"}),E.prototype.onLoad.call(this,t)},onLeave:function(){this.unregisterMouseEvents(),this.dispatchEvent({type:"panolens-viewer-handler",method:"enableControl",data:a.ORBIT}),window.cancelAnimationFrame(this.frameId),E.prototype.onLeave.call(this)},onWindowResize:function(){this.material.uniforms.resolution.value=this.container.clientWidth/this.container.clientHeight},onContextMenu:function(){this.dragging=!1},dispose:function(){this.unregisterMouseEvents(),E.prototype.dispose.call(this)}}),R.prototype=Object.assign(Object.create(T.prototype),{constructor:R,onLoad:function(t){this.updateTexture(t),T.prototype.onLoad.call(this,t)},updateTexture:function(t){t.minFilter=t.magFilter=X.LinearFilter,this.material.uniforms.tDiffuse.value=t},dispose:function(){var t=this.material.uniforms.tDiffuse;t&&t.value&&t.value.dispose(),T.prototype.dispose.call(this)}}),S.prototype=Object.assign(Object.create(y.prototype),{constructor:S,onPanolensContainer:function({container:t}){this.media.setContainer(t)},onPanolensScene:function({scene:t}){this.media.setScene(t)},start:function(){return this.media.start()},stop:function(){this.media.stop()}}),x.prototype=Object.assign(Object.create(E.prototype),{constructor:x,onLoad:function(t){var{width:e,height:i}=t.image;let n=null;n=e/i==4?r.SBS:r.TAB,this.stereo.updateUniformByFormat(n,this.material.uniforms),this.material.uniforms.tEquirect.value=t,E.prototype.onLoad.call(this,t)},updateTextureToLeft:function(){this.stereo.updateTextureToLeft(this.material.uniforms.offset.value)},updateTextureToRight:function(){this.stereo.updateTextureToRight(this.material.uniforms.offset.value)},dispose:function(){var t=this.material.uniforms.tEquirect["value"];t instanceof X.Texture&&t.dispose(),E.prototype.dispose.call(this)}}),O.prototype=Object.assign(Object.create(C.prototype),{constructor:O,onLoad:function(t){var{videoWidth:e,videoHeight:i}=t.image;let n=null;n=e/i==4?r.SBS:r.TAB,this.stereo.updateUniformByFormat(n,this.material.uniforms),this.material.uniforms.tEquirect.value=t,C.prototype.onLoad.call(this)},updateTextureToLeft:function(){this.stereo.updateTextureToLeft(this.material.uniforms.offset.value)},updateTextureToRight:function(){this.stereo.updateTextureToRight(this.material.uniforms.offset.value)},dispose:function(){var t=this.material.uniforms.tEquirect["value"];t instanceof X.Texture&&t.dispose(),C.prototype.dispose.call(this)}}),D.prototype=Object.assign(Object.create(X.EventDispatcher.prototype),{constructor:D}),k.prototype=Object.assign(Object.create(X.EventDispatcher.prototype),{constructor:k});function U(s){const o=new X.StereoCamera,a=(o.aspect=.5,new X.Vector2);this.setEyeSeparation=function(t){o.eyeSep=t},this.setSize=function(t,e){s.setSize(t,e)},this.render=function(t,e,i){var n=i instanceof x||i instanceof O;t.updateMatrixWorld(),null===e.parent&&e.updateMatrixWorld(),n&&this.setEyeSeparation(i.stereo.eyeSep),o.update(e),s.getSize(a),s.autoClear&&s.clear(),s.setScissorTest(!0),n&&i.updateTextureToLeft(),s.setScissor(0,0,a.width/2,a.height),s.setViewport(0,0,a.width/2,a.height),s.render(t,o.cameraL),n&&i.updateTextureToRight(),s.setScissor(a.width/2,0,a.width/2,a.height),s.setViewport(a.width/2,0,a.width/2,a.height),s.render(t,o.cameraR),s.setScissorTest(!1),n&&i.updateTextureToLeft()}}function j(t={}){this.options=Object.assign({container:this.setupContainer(t.container),controlBar:!0,controlButtons:["fullscreen","setting","video"],autoHideControlBar:!1,autoHideInfospot:!0,horizontalView:!1,clickTolerance:10,cameraFov:60,reverseDragging:!1,enableReticle:!1,dwellTime:1500,autoReticleSelect:!0,viewIndicator:!1,indicatorSize:30,output:null,autoRotate:!1,autoRotateSpeed:2,autoRotateActivationDuration:5e3,initialLookAt:new X.Vector3(0,0,-Number.MAX_SAFE_INTEGER)},t);var{container:t,cameraFov:e,controlBar:i,controlButtons:n,viewIndicator:s,indicatorSize:o,enableReticle:a,reverseDragging:r,output:c,scene:h,camera:l,renderer:d}=this.options,{clientWidth:u,clientHeight:p}=t;this.container=t,this.scene=this.setupScene(h),this.sceneReticle=new X.Scene,this.camera=this.setupCamera(e,u/p,l),this.renderer=this.setupRenderer(d,t),this.reticle=this.addReticle(this.camera,this.sceneReticle),this.control=this.setupControls(this.camera,t),this.effect=this.setupEffects(this.renderer,t),this.mode=m.NORMAL,this.panorama=null,this.widget=null,this.hoverObject=null,this.infospot=null,this.pressEntityObject=null,this.pressObject=null,this.raycaster=new X.Raycaster,this.raycasterPoint=new X.Vector2,this.userMouse=new X.Vector2,this.updateCallbacks=[],this.requestAnimationId=null,this.cameraFrustum=new X.Frustum,this.cameraViewProjectionMatrix=new X.Matrix4,this.autoRotateRequestId=null,this.outputDivElement=null,this.touchSupported="ontouchstart"in window||window.DocumentTouch&&document instanceof DocumentTouch,this.tweenLeftAnimation=new v.Tween,this.tweenUpAnimation=new v.Tween,this.outputEnabled=!1,this.viewIndicatorSize=o,this.tempEnableReticle=a,this.handlerMouseUp=this.onMouseUp.bind(this),this.handlerMouseDown=this.onMouseDown.bind(this),this.handlerMouseMove=this.onMouseMove.bind(this),this.handlerWindowResize=this.onWindowResize.bind(this),this.handlerKeyDown=this.onKeyDown.bind(this),this.handlerKeyUp=this.onKeyUp.bind(this),this.handlerTap=this.onTap.bind(this,{clientX:u/2,clientY:p/2}),i&&this.addDefaultControlBar(n),s&&this.addViewIndicator(),r&&this.reverseDraggingDirection(),a?this.enableReticleControl():this.registerMouseAndTouchEvents(),"overlay"===c&&this.addOutputElement(),this.registerEventListeners(),this.animate.call(this)}j.prototype=Object.assign(Object.create(X.EventDispatcher.prototype),{constructor:j,setupScene:function(t=new X.Scene){return t},setupCamera:function(t,e,i=new X.PerspectiveCamera(t,e,1,1e4)){return i},setupRenderer:function(t=new X.WebGLRenderer({alpha:!0,antialias:!1}),e){var{clientWidth:i,clientHeight:n}=e;return t.setPixelRatio(window.devicePixelRatio),t.setSize(i,n),t.setClearColor(0,0),t.autoClear=!1,t.domElement.classList.add("panolens-canvas"),t.domElement.style.display="block",e.style.backgroundColor="#000",e.appendChild(t.domElement),t},setupControls:function(t,e){var{autoRotate:i,autoRotateSpeed:n,horizontalView:s}=this.options,o=new D(t,e),i=(o.id="orbit",o.index=a.ORBIT,o.minDistance=1,o.noPan=!0,o.autoRotate=i,o.autoRotateSpeed=n,s&&(o.minPolarAngle=Math.PI/2,o.maxPolarAngle=Math.PI/2),new k(t,e));return i.id="device-orientation",i.index=a.DEVICEORIENTATION,i.enabled=!1,this.controls=[o,i],this.OrbitControls=o,this.DeviceOrientationControls=i,o},setupEffects:function(t,{clientWidth:e,clientHeight:i}){var n=new V(t),t=(n.setSize(e,i),new U(t));return t.setSize(e,i),this.CardboardEffect=n,this.StereoEffect=t,n},setupContainer:function(t){return t?(t._width=t.clientWidth,t._height=t.clientHeight,t):((t=document.createElement("div")).classList.add("panolens-container"),t.style.width="100%",t.style.height="100%",document.body.appendChild(t),t)},add:function(t){if(1<arguments.length){for(let t=0;t<arguments.length;t++)this.add(arguments[t]);return this}var e;this.scene.add(t),t.addEventListener&&t.addEventListener("panolens-viewer-handler",this.eventHandler.bind(this)),t instanceof y&&t.dispatchEvent&&t.dispatchEvent({type:"panolens-container",container:this.container}),t instanceof S&&t.dispatchEvent({type:"panolens-scene",scene:this.scene}),t instanceof y&&(this.addPanoramaEventListener(t),this.panorama||(e=this.options["initialLookAt"],this.setPanorama(t),this.setControlCenter(e)))},remove:function(t){t.removeEventListener&&t.removeEventListener("panolens-viewer-handler",this.eventHandler.bind(this)),this.scene.remove(t)},addDefaultControlBar:function(t){if(this.widget)console.warn("Default control bar exists");else{const e=new g(this.container);e.addEventListener("panolens-viewer-handler",this.eventHandler.bind(this)),e.addControlBar(),t.forEach(t=>{e.addControlButton(t)}),this.widget=e}},setPanorama:function(t){const e=this.panorama;if(t instanceof y&&e!==t){this.hideInfospot();const i=function(){e&&e.onLeave(),t.removeEventListener("enter-fade-start",i)};t.addEventListener("enter-fade-start",i),(this.panorama=t).onEnter()}},eventHandler:function(t){t.method&&this[t.method]&&this[t.method](t.data)},dispatchEventToChildren:function(e){this.scene.traverse(function(t){t.dispatchEvent&&t.dispatchEvent(e)})},activateWidgetItem:function(t,e){var i=this.widget.mainMenu,n=i.children[0],s=i.children[1];let o;if(void 0!==t){switch(t){case 0:o=n.subMenu.children[1];break;case 1:o=n.subMenu.children[2];break;default:o=n.subMenu.children[1]}n.subMenu.setActiveItem(o),n.setSelectionTitle(o.textContent)}if(void 0!==e){switch(e){case m.CARDBOARD:o=s.subMenu.children[2];break;case m.STEREO:o=s.subMenu.children[3];break;default:o=s.subMenu.children[1]}s.subMenu.setActiveItem(o),s.setSelectionTitle(o.textContent)}},enableEffect:function(t){if(this.mode!==t)if(t===m.NORMAL)this.disableEffect();else{this.mode=t;var e=this.camera.fov;switch(t){case m.CARDBOARD:this.effect=this.CardboardEffect,this.enableReticleControl();break;case m.STEREO:this.effect=this.StereoEffect,this.enableReticleControl();break;default:this.effect=null,this.disableReticleControl()}this.activateWidgetItem(void 0,this.mode),this.dispatchEventToChildren({type:"panolens-dual-eye-effect",mode:this.mode}),this.camera.fov=e+.01,this.effect.setSize(this.container.clientWidth,this.container.clientHeight),this.render(),this.camera.fov=e,this.dispatchEvent({type:"mode-change",mode:this.mode})}},disableEffect:function(){this.mode!==m.NORMAL&&(this.mode=m.NORMAL,this.disableReticleControl(),this.activateWidgetItem(void 0,this.mode),this.dispatchEventToChildren({type:"panolens-dual-eye-effect",mode:this.mode}),this.renderer.setSize(this.container.clientWidth,this.container.clientHeight),this.render(),this.dispatchEvent({type:"mode-change",mode:this.mode}))},enableReticleControl:function(){this.reticle.visible||(this.tempEnableReticle=!0,this.unregisterMouseAndTouchEvents(),this.reticle.show(),this.registerReticleEvent(),this.updateReticleEvent())},disableReticleControl:function(){this.tempEnableReticle=!1,this.options.enableReticle?this.updateReticleEvent():(this.reticle.hide(),this.unregisterReticleEvent(),this.registerMouseAndTouchEvents())},enableAutoRate:function(){this.options.autoRotate=!0,this.OrbitControls.autoRotate=!0},disableAutoRate:function(){clearTimeout(this.autoRotateRequestId),this.options.autoRotate=!1,this.OrbitControls.autoRotate=!1},toggleVideoPlay:function(t){this.panorama instanceof C&&this.panorama.dispatchEvent({type:"video-toggle",pause:t})},setVideoCurrentTime:function(t){this.panorama instanceof C&&this.panorama.dispatchEvent({type:"video-time",percentage:t})},onVideoUpdate:function(t){var e=this["widget"];e&&e.dispatchEvent({type:"video-update",percentage:t})},addUpdateCallback:function(t){t&&this.updateCallbacks.push(t)},removeUpdateCallback:function(t){var e=this.updateCallbacks.indexOf(t);t&&0<=e&&this.updateCallbacks.splice(e,1)},showVideoWidget:function(){var t=this["widget"];t&&t.dispatchEvent({type:"video-control-show"})},hideVideoWidget:function(){var t=this["widget"];t&&t.dispatchEvent({type:"video-control-hide"})},updateVideoPlayButton:function(t){var e=this["widget"];e&&e.videoElement&&e.videoElement.controlButton&&e.videoElement.controlButton.update(t)},addPanoramaEventListener:function(t){t.addEventListener("enter",this.setCameraControl.bind(this)),t instanceof C&&(t.addEventListener("enter-fade-start",this.showVideoWidget.bind(this)),t.addEventListener("leave",function(){this.panorama instanceof C||this.hideVideoWidget.call(this)}.bind(this)))},setCameraControl:function(){this.OrbitControls.target.copy(this.panorama.position)},getControl:function(){return this.control},getScene:function(){return this.scene},getCamera:function(){return this.camera},getRenderer:function(){return this.renderer},getContainer:function(){return this.container},getControlId:function(){return this.control.id},getNextControlId:function(){return this.controls[this.getNextControlIndex()].id},getNextControlIndex:function(){var t=this.controls,e=this.control,e=t.indexOf(e)+1;return e>=t.length?0:e},setCameraFov:function(t){this.camera.fov=t,this.camera.updateProjectionMatrix()},getRaycastViewCenter:function(){var t=new X.Raycaster,t=(t.setFromCamera(new X.Vector2(0,0),this.camera),t.intersectObject(this.panorama));return 0<t.length?t[0].point:new X.Vector3(0,0,-1)},enableControl:function(t){t=0<=t&&t<this.controls.length?t:0,this.control.enabled=!1,this.control=this.controls[t],this.control.enabled=!0,this.control.update(),this.setControlCenter(this.getRaycastViewCenter()),this.activateWidgetItem(t,void 0),this.onChange()},disableControl:function(){this.control.enabled=!1},toggleNextControl:function(){this.enableControl(this.getNextControlIndex())},getScreenVector:function(t){var t=t.clone(),e=this.container.clientWidth/2,i=this.container.clientHeight/2;return t.project(this.camera),t.x=t.x*e+e,t.y=-t.y*i+i,t.z=0,t},checkSpriteInViewport:function(t){return this.camera.matrixWorldInverse.getInverse(this.camera.matrixWorld),this.cameraViewProjectionMatrix.multiplyMatrices(this.camera.projectionMatrix,this.camera.matrixWorldInverse),this.cameraFrustum.setFromMatrix(this.cameraViewProjectionMatrix),t.visible&&this.cameraFrustum.intersectsSprite(t)},reverseDraggingDirection:function(){this.OrbitControls.rotateSpeed*=-1,this.OrbitControls.momentumScalingFactor*=-1},addReticle:function(t,e){var i=new d(16777215,!0,this.options.dwellTime);return i.hide(),t.add(i),e.add(t),i},rotateControlLeft:function(t){this.control.rotateLeft(t)},rotateControlUp:function(t){this.control.rotateUp(t)},rotateOrbitControl:function(t,e){this.rotateControlLeft(t),this.rotateControlUp(e)},calculateCameraDirectionDelta:function(t){var e,i=this.camera.getWorldDirection(new X.Vector3),n=i.clone(),s=this.panorama.getWorldPosition(new X.Vector3).sub(this.camera.getWorldPosition(new X.Vector3)),t=t.clone();return t.add(s).normalize(),s=t.clone(),i.y=0,t.y=0,e=(e=(e=Math.atan2(t.z,t.x)-Math.atan2(i.z,i.x))>Math.PI?e-2*Math.PI:e)<-Math.PI?e+2*Math.PI:e,i=Math.abs(n.angleTo(i)+(n.y*s.y<=0?s.angleTo(t):-s.angleTo(t))),{left:e,up:i*=s.y<n.y?1:-1}},setControlCenter:function(t){var{left:t,up:e}=this.calculateCameraDirectionDelta(t);this.rotateOrbitControl(t,e)},tweenControlCenter:function(t,e,i){t instanceof Array&&(e=(t=t[0])[1],i=t[2]),e=void 0!==e?e:1e3,i=i||v.Easing.Exponential.Out;var{left:t,up:n}=this.calculateCameraDirectionDelta(t);const s=this.rotateControlLeft.bind(this),o=this.rotateControlUp.bind(this);var a={left:0,up:0};const r={left:0,up:0};this.tweenLeftAnimation.stop(),this.tweenUpAnimation.stop(),this.tweenLeftAnimation=new v.Tween(a).to({left:t},e).easing(i).onUpdate(function(t){s(t.left-r.left),r.left=t.left}).start(),this.tweenUpAnimation=new v.Tween(a).to({up:n},e).easing(i).onUpdate(function(t){o(t.up-r.up),r.up=t.up}).start()},tweenControlCenterByObject:function(t,e,i){this.tweenControlCenter(t.getWorldPosition(new X.Vector3),e,i)},onWindowResize:function(t,e){let i,n;var s=this.container.classList.contains("panolens-container")||this.container.isFullscreen;void 0!==t&&void 0!==e?(i=t,n=e,this.container._width=t,this.container._height=e):(e=(t=/(android)/i.test(window.navigator.userAgent))?Math.min(document.documentElement.clientWidth,window.innerWidth||0):Math.max(document.documentElement.clientWidth,window.innerWidth||0),t=t?Math.min(document.documentElement.clientHeight,window.innerHeight||0):Math.max(document.documentElement.clientHeight,window.innerHeight||0),i=s?e:this.container.clientWidth,n=s?t:this.container.clientHeight,this.container._width=i,this.container._height=n),this.camera.aspect=i/n,this.camera.updateProjectionMatrix(),this.renderer.setSize(i,n),(this.options.enableReticle||this.tempEnableReticle)&&this.updateReticleEvent(),this.dispatchEvent({type:"window-resize",width:i,height:n}),this.scene.traverse(function(t){t.dispatchEvent&&t.dispatchEvent({type:"window-resize",width:i,height:n})})},addOutputElement:function(){var t=document.createElement("div");t.style.position="absolute",t.style.right="10px",t.style.top="10px",t.style.color="#fff",this.container.appendChild(t),this.outputDivElement=t},outputPosition:function(){var t=this.raycaster.intersectObject(this.panorama,!0);if(0<t.length){var t=t[0].point.clone(),e=this.panorama.getWorldPosition(new X.Vector3),i=(t.sub(e),`${t.x.toFixed(2)}, ${t.y.toFixed(2)}, `+t.z.toFixed(2));if(0!==t.length())switch(this.options.output){case"console":console.info(i);break;case"overlay":this.outputDivElement.textContent=i}}},onMouseDown:function(t){t.preventDefault(),this.userMouse.x=(0<=t.clientX?t:t.touches[0]).clientX,this.userMouse.y=(0<=t.clientY?t:t.touches[0]).clientY,this.userMouse.type="mousedown",this.onTap(t)},onMouseMove:function(t){t.preventDefault(),this.userMouse.type="mousemove",this.onTap(t)},onMouseUp:function(t){let e=!1;this.userMouse.type="mouseup";var i,n,s=this.userMouse.x>=t.clientX-this.options.clickTolerance&&this.userMouse.x<=t.clientX+this.options.clickTolerance&&this.userMouse.y>=t.clientY-this.options.clickTolerance&&this.userMouse.y<=t.clientY+this.options.clickTolerance||t.changedTouches&&this.userMouse.x>=t.changedTouches[0].clientX-this.options.clickTolerance&&this.userMouse.x<=t.changedTouches[0].clientX+this.options.clickTolerance&&this.userMouse.y>=t.changedTouches[0].clientY-this.options.clickTolerance&&this.userMouse.y<=t.changedTouches[0].clientY+this.options.clickTolerance?"click":void 0;t&&t.target&&!t.target.classList.contains("panolens-canvas")||(t.preventDefault(),e=t.changedTouches&&1===t.changedTouches.length?this.onTap({clientX:t.changedTouches[0].clientX,clientY:t.changedTouches[0].clientY},s):this.onTap(t,s),this.userMouse.type="none",e)||"click"===s&&({options:{autoHideInfospot:t,autoHideControlBar:s},panorama:i,toggleControlBar:n}=this,t&&i&&i.toggleInfospotVisibility(),s)&&n()},onTap:function(t,e){var{left:i,top:n}=this.container.getBoundingClientRect(),{clientWidth:s,clientHeight:o}=this.container;if(this.raycasterPoint.x=(t.clientX-i)/s*2-1,this.raycasterPoint.y=-(t.clientY-n)/o*2+1,this.raycaster.setFromCamera(this.raycasterPoint,this.camera),this.panorama){("mousedown"!==t.type&&this.touchSupported||this.outputEnabled)&&this.outputPosition();i=this.raycaster.intersectObjects(this.panorama.children,!0),s=this.getConvertedIntersect(i),n=0<i.length?i[0].object:void 0;if("mouseup"===this.userMouse.type&&(s&&this.pressEntityObject===s&&this.pressEntityObject.dispatchEvent&&this.pressEntityObject.dispatchEvent({type:"pressstop-entity",mouseEvent:t}),this.pressEntityObject=void 0),"mouseup"===this.userMouse.type&&(n&&this.pressObject===n&&this.pressObject.dispatchEvent&&this.pressObject.dispatchEvent({type:"pressstop",mouseEvent:t}),this.pressObject=void 0),"click"===e?(this.panorama.dispatchEvent({type:"click",intersects:i,mouseEvent:t}),s&&s.dispatchEvent&&s.dispatchEvent({type:"click-entity",mouseEvent:t}),n&&n.dispatchEvent&&n.dispatchEvent({type:"click",mouseEvent:t})):(this.panorama.dispatchEvent({type:"hover",intersects:i,mouseEvent:t}),(this.hoverObject&&0<i.length&&this.hoverObject!==s||this.hoverObject&&0===i.length)&&(this.hoverObject.dispatchEvent&&(this.hoverObject.dispatchEvent({type:"hoverleave",mouseEvent:t}),this.reticle.end()),this.hoverObject=void 0),s&&0<i.length&&(this.hoverObject!==s&&(this.hoverObject=s,this.hoverObject.dispatchEvent)&&(this.hoverObject.dispatchEvent({type:"hoverenter",mouseEvent:t}),this.options.autoReticleSelect&&this.options.enableReticle||this.tempEnableReticle)&&this.reticle.start(this.onTap.bind(this,t,"click")),"mousedown"===this.userMouse.type&&this.pressEntityObject!=s&&(this.pressEntityObject=s,this.pressEntityObject.dispatchEvent)&&this.pressEntityObject.dispatchEvent({type:"pressstart-entity",mouseEvent:t}),"mousedown"===this.userMouse.type&&this.pressObject!=n&&(this.pressObject=n,this.pressObject.dispatchEvent)&&this.pressObject.dispatchEvent({type:"pressstart",mouseEvent:t}),"mousemove"===this.userMouse.type||this.options.enableReticle)&&(n&&n.dispatchEvent&&n.dispatchEvent({type:"hover",mouseEvent:t}),this.pressEntityObject&&this.pressEntityObject.dispatchEvent&&this.pressEntityObject.dispatchEvent({type:"pressmove-entity",mouseEvent:t}),this.pressObject)&&this.pressObject.dispatchEvent&&this.pressObject.dispatchEvent({type:"pressmove",mouseEvent:t}),!s&&this.pressEntityObject&&this.pressEntityObject.dispatchEvent&&(this.pressEntityObject.dispatchEvent({type:"pressstop-entity",mouseEvent:t}),this.pressEntityObject=void 0),!n&&this.pressObject&&this.pressObject.dispatchEvent&&(this.pressObject.dispatchEvent({type:"pressstop",mouseEvent:t}),this.pressObject=void 0)),n&&n instanceof f){if(this.infospot=n,"click"===e)return!0}else this.infospot&&this.hideInfospot();this.options.autoRotate&&"mousemove"!==this.userMouse.type&&(clearTimeout(this.autoRotateRequestId),this.control===this.OrbitControls)&&(this.OrbitControls.autoRotate=!1,this.autoRotateRequestId=window.setTimeout(this.enableAutoRate.bind(this),this.options.autoRotateActivationDuration))}},getConvertedIntersect:function(e){let i;for(let t=0;t<e.length;t++)if(0<=e[t].distance&&e[t].object&&!e[t].object.passThrough&&(!e[t].object.entity||!e[t].object.entity.passThrough)){if(e[t].object.entity&&!e[t].object.entity.passThrough){i=e[t].object.entity;break}i=e[t].object;break}return i},hideInfospot:function(){this.infospot&&(this.infospot.onHoverEnd(),this.infospot=void 0)},toggleControlBar:function(){var t=this["widget"];t&&t.dispatchEvent({type:"control-bar-toggle"})},onKeyDown:function(t){this.options.output&&"none"!==this.options.output&&"Control"===t.key&&(this.outputEnabled=!0)},onKeyUp:function(){this.outputEnabled=!1},update:function(){v.update(),this.updateCallbacks.forEach(function(t){t()}),this.control.update(),this.scene.traverse(function(t){var e,i;t instanceof f&&t.element&&(this.hoverObject===t||"none"!==t.element.style.display||t.element.left&&"none"!==t.element.left.style.display||t.element.right&&"none"!==t.element.right.style.display)&&(this.checkSpriteInViewport(t)?({x:e,y:i}=this.getScreenVector(t.getWorldPosition(new X.Vector3)),t.translateElement(e,i)):t.onDismiss())}.bind(this))},render:function(){(this.mode===m.CARDBOARD||this.mode===m.STEREO?(this.renderer.clear(),this.effect.render(this.scene,this.camera,this.panorama),this.effect):(this.renderer.clear(),this.renderer.render(this.scene,this.camera),this.renderer.clearDepth(),this.renderer)).render(this.sceneReticle,this.camera)},animate:function(){this.requestAnimationId=window.requestAnimationFrame(this.animate.bind(this)),this.onChange()},onChange:function(){this.update(),this.render()},registerMouseAndTouchEvents:function(){var t={passive:!1};this.container.addEventListener("mousedown",this.handlerMouseDown,t),this.container.addEventListener("mousemove",this.handlerMouseMove,t),this.container.addEventListener("mouseup",this.handlerMouseUp,t),this.container.addEventListener("touchstart",this.handlerMouseDown,t),this.container.addEventListener("touchend",this.handlerMouseUp,t)},unregisterMouseAndTouchEvents:function(){this.container.removeEventListener("mousedown",this.handlerMouseDown,!1),this.container.removeEventListener("mousemove",this.handlerMouseMove,!1),this.container.removeEventListener("mouseup",this.handlerMouseUp,!1),this.container.removeEventListener("touchstart",this.handlerMouseDown,!1),this.container.removeEventListener("touchend",this.handlerMouseUp,!1)},registerReticleEvent:function(){this.addUpdateCallback(this.handlerTap)},unregisterReticleEvent:function(){this.removeUpdateCallback(this.handlerTap)},updateReticleEvent:function(){var t=this.container.clientWidth/2+this.container.offsetLeft,e=this.container.clientHeight/2;this.removeUpdateCallback(this.handlerTap),this.handlerTap=this.onTap.bind(this,{clientX:t,clientY:e}),this.addUpdateCallback(this.handlerTap)},registerEventListeners:function(){window.addEventListener("resize",this.handlerWindowResize,!0),window.addEventListener("keydown",this.handlerKeyDown,!0),window.addEventListener("keyup",this.handlerKeyUp,!0)},unregisterEventListeners:function(){window.removeEventListener("resize",this.handlerWindowResize,!0),window.removeEventListener("keydown",this.handlerKeyDown,!0),window.removeEventListener("keyup",this.handlerKeyUp,!0)},dispose:function(){this.disableAutoRate(),this.tweenLeftAnimation.stop(),this.tweenUpAnimation.stop(),this.unregisterEventListeners(),function e(i){for(let t=i.children.length-1;0<=t;t--)e(i.children[t]),i.remove(i.children[t]);i instanceof y||i instanceof f?i.dispose():i.dispatchEvent&&i.dispatchEvent("dispose")}(this.scene),this.widget&&(this.widget.dispose(),this.widget=null),X.Cache&&X.Cache.enabled&&X.Cache.clear()},destroy:function(){this.dispose(),this.render(),window.cancelAnimationFrame(this.requestAnimationId)},onPanoramaDispose:function(t){t instanceof C&&this.hideVideoWidget(),t===this.panorama&&(this.panorama=null)},loadAsyncRequest:function(t,e=()=>{}){var i=new window.XMLHttpRequest;i.onloadend=function(t){e(t)},i.open("GET",t,!0),i.send(null)},addViewIndicator:function(){const i=this;this.loadAsyncRequest(p.ViewIndicator,function(t){if(0!==t.loaded){t=t.target.responseXML.documentElement;t.style.width=i.viewIndicatorSize+"px",t.style.height=i.viewIndicatorSize+"px",t.style.position="absolute",t.style.top="10px",t.style.left="10px",t.style.opacity="0.5",t.style.cursor="pointer",t.id="panolens-view-indicator-container",i.container.appendChild(t);const e=t.querySelector("#indicator");i.addUpdateCallback(function(){i.radius=.225*i.viewIndicatorSize,i.currentPanoAngle=i.camera.rotation.y-X.Math.degToRad(90),i.fovAngle=X.Math.degToRad(i.camera.fov),i.leftAngle=-i.currentPanoAngle-i.fovAngle/2,i.rightAngle=-i.currentPanoAngle+i.fovAngle/2,i.leftX=i.radius*Math.cos(i.leftAngle),i.leftY=i.radius*Math.sin(i.leftAngle),i.rightX=i.radius*Math.cos(i.rightAngle),i.rightY=i.radius*Math.sin(i.rightAngle),i.indicatorD="M "+i.leftX+" "+i.leftY+" A "+i.radius+" "+i.radius+" 0 0 1 "+i.rightX+" "+i.rightY,i.leftX&&i.leftY&&i.rightX&&i.rightY&&i.radius&&e.setAttribute("d",i.indicatorD)});t.addEventListener("mouseenter",function(){this.style.opacity="1"}),t.addEventListener("mouseleave",function(){this.style.opacity="0.5"})}})},appendControlItem:function(t){var e=this.widget.createCustomItem(t);return("video"===t.group?this.widget.videoElement:this.widget.barElement).appendChild(e),e},clearAllCache:function(){X.Cache.clear()}}),X.REVISION!=n&&console.warn("three.js version is not matched. Please consider use the target revision "+n),window.TWEEN=v,t.BasicPanorama=M,t.CONTROLS=a,t.CameraPanorama=S,t.CubePanorama=w,t.CubeTextureLoader=s,t.DataImage=p,t.EmptyPanorama=b,t.GoogleStreetviewPanorama=L,t.ImageLittlePlanet=R,t.ImageLoader=l,t.ImagePanorama=E,t.Infospot=f,t.LittlePlanet=T,t.MODES=m,t.Media=o,t.Panorama=y,t.REVISION=e,t.Reticle=d,t.STEREOFORMAT=r,t.Stereo=h,t.StereoImagePanorama=x,t.StereoVideoPanorama=O,t.THREE_REVISION=n,t.THREE_VERSION=i,t.TextureLoader=c,t.VERSION="0.11.0",t.VideoPanorama=C,t.Viewer=j,t.Widget=g,Object.defineProperty(t,"__esModule",{value:!0})});