(function ($) {
    'use strict';

    $(function () {
        var $body = $('body');
        var $dropdownWrapper = $('body .makbet-dropdown-filter');
        $body.on('click', '.filter-toggle', function (e) {
            e.preventDefault();
            $('.filter-toggle').toggleClass('active-filter-toggle');
            if ($body.hasClass('shop_filter_dropdown') && $(window).width() > 1023) {
                $dropdownWrapper.toggleClass('active-dropdown').slideToggle();
            } else if ($body.hasClass('shop_filter_drawing') && $(window).width() > 1023) {

                const productsList = document.querySelector(".makbet-products-grid");
                $body.toggleClass('active-drawing');
                if ($body.hasClass('active-drawing')) {
                    productsList.className = productsList.dataset.filtersClosedClasses
                } else {
                    productsList.className = productsList.dataset.filtersOpenClasses
                }

            } else {
                $('html').toggleClass('off-canvas-active');

            }
            setTimeout(function () {
                $(window).trigger('resize');
            }, 500)
        });

        $body.on('click', '.filter-close, .makbet-overlay-filter', function (e) {
            e.preventDefault();
            $('html').toggleClass('off-canvas-active');
        });

        function clone_sidebar() {
            var $canvas = $('.makbet-canvas-filter-wrap');
            if (!$('body').hasClass('shop_filter_canvas')) {
                if ($(window).width() <= 1024) {
                    $('#secondary').children().appendTo(".makbet-canvas-filter-wrap");
                    $('.makbet-dropdown-filter-wrap').children().appendTo(".makbet-canvas-filter-wrap");
                } else {
                    $canvas.children().appendTo("#secondary");
                    $canvas.children().appendTo(".makbet-dropdown-filter-wrap");
                }
            }
        }

        // menu filter width min max
        function wooMenuFilter() {
            let $widget_filter = $('.makbet-menu-filter-wrap .widget'),
                count = $widget_filter.length,
                $parrent_filter = $('.makbet-sorting'),
                parrent_width = $parrent_filter.outerWidth(),
                child_width = 0;

            if ($widget_filter.length > 0) {
                $widget_filter.each((index, element) => {
                    child_width += $(element).outerWidth() + 30;
                    if (!--count) addClassActive(parrent_width, child_width, $parrent_filter);
                });
            }

            function addClassActive(parrent_width, child_width, $parrent_filter) {
                if (child_width > (parrent_width - 300)) {
                    $parrent_filter.addClass('active-filter-toggle');
                } else {
                    $parrent_filter.removeClass('active-filter-toggle');
                }
            }
        }

        $(document).ready(function () {
            clone_sidebar();
            $(window).on('resize', function () {
                clone_sidebar();
                wooMenuFilter();
            });
        });
    });

})(jQuery);
