<?php

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Makbet')) :

    /**
     * The main Makbet class
     */
    class Makbet {

        /**
         * Setup class.
         *
         * @since 1.0
         */
        public function __construct() {
            add_action('after_setup_theme', array($this, 'setup'));
            add_action('after_setup_theme', array($this, 'includes'));
            add_action('wp_head', [$this, 'preload'], 1);
            add_action('widgets_init', array($this, 'widgets_init'));
            add_filter('makbet_theme_sidebar', array($this, 'set_sidebar'), 20);
            add_action('wp_enqueue_scripts', array($this, 'register_scripts_addon'), 5);
            add_action('wp_enqueue_scripts', array($this, 'scripts'), 10);
            add_action('admin_enqueue_scripts', [$this, 'admin_scripts']);
            add_action('wp_enqueue_scripts', array($this, 'child_scripts'), 30); // After WooCommerce.
            add_action('enqueue_block_assets', array($this, 'block_assets'));
            add_filter('body_class', array($this, 'body_classes'));
            add_filter('wp_page_menu_args', array($this, 'page_menu_args'));
            add_filter('navigation_markup_template', array($this, 'navigation_markup_template'));
            add_filter('block_editor_settings_all', array($this, 'custom_editor_settings'), 10, 2);
            add_action('tgmpa_register', [$this, 'register_required_plugins']);
            add_filter('gutenberg_use_widgets_block_editor', '__return_false');
            add_filter('use_widgets_block_editor', '__return_false');
            add_filter('dynamic_sidebar_params', [$this, 'check_sidebar_params']);
            add_filter('get_etb_after_header_id', function ($id) {
                if (get_page_template_slug() == 'template-homepage.php') {
                    return false;
                }
                return $id;
            });

            if (makbet_is_contactform_activated()) {
                add_filter('wpcf7_autop_or_not', '__return_false');
            }
        }

        public function preload() {
            get_template_part('template-parts/preload');
        }

        public function register_required_plugins() {
            /**
             * Array of plugin arrays. Required keys are name and slug.
             * If the source is NOT from the .org repo, then source is also required.
             */
            $plugins = array(
                array(
                    'name'     => 'Pavo Core',
                    'slug'     => 'pavo-core',
                    'required' => true,
                    'source'   => 'https://source.wpopal.com/plugins/pavo-core/pavo-core.zip'
                ),
                array(
                    'name'     => 'Make Column Clickable Elementor',
                    'slug'     => 'make-column-clickable-elementor',
                    'required' => false,
                ),
                array(
                    'name'     => 'Elementor',
                    'slug'     => 'elementor',
                    'required' => true,
                ),
                array(
                    'name'     => 'Contact Form 7',
                    'slug'     => 'contact-form-7',
                    'required' => false,
                ),
                array(
                    'name'     => 'Mailchimp For Wordpress',
                    'slug'     => 'mailchimp-for-wp',
                    'required' => false,
                ),
                array(
                    'name'     => 'CMB2',
                    'slug'     => 'cmb2',
                    'required' => false,
                ),

                //====start_premium
                array(
                    'name'     => 'Revslider',
                    'slug'     => 'revslider',
                    'required' => true,
                    'source'   => esc_url('http://source.wpopal.com/plugins/new/revslider.zip'),
                )
                //====end_premium
            );

            /*
             * Array of configuration settings. Amend each line as needed.
             *
             * TGMPA will start providing localized text strings soon. If you already have translations of our standard
             * strings available, please help us make TGMPA even better by giving us access to these translations or by
             * sending in a pull-request with .po file(s) with the translations.
             *
             * Only uncomment the strings in the config array if you want to customize the strings.
             */
            $config = array(
                'id'           => 'makbet',
                // Unique ID for hashing notices for multiple instances of TGMPA.
                'default_path' => '',
                // Default absolute path to bundled plugins.
                'menu'         => 'tgmpa-install-plugins',
                // Menu slug.
                'has_notices'  => true,
                // Show admin notices or not.
                'dismissable'  => true,
                // If false, a user cannot dismiss the nag message.
                'dismiss_msg'  => '',
                // If 'dismissable' is false, this message will be output at top of nag.
                'is_automatic' => false,
                // Automatically activate plugins after installation or not.
                'message'      => '',
            );

            tgmpa($plugins, $config);
        }

        /**
         * Sets up theme defaults and registers support for various WordPress features.
         *
         * Note that this function is hooked into the after_setup_theme hook, which
         * runs before the init hook. The init hook is too late for some features, such
         * as indicating support for post thumbnails.
         */
        public function setup() {

            // Loads wp-content/themes/child-theme-name/languages/makbet.mo.
            load_theme_textdomain('makbet', get_stylesheet_directory() . '/languages');

            // Loads wp-content/themes/makbet/languages/makbet.mo.
            load_theme_textdomain('makbet', get_template_directory() . '/languages');

            /**
             * Add default posts and comments RSS feed links to head.
             */
            add_theme_support('automatic-feed-links');


            /*
             * Enable support for Post Thumbnails on posts and pages.
             *
             * @link https://developer.wordpress.org/reference/functions/add_theme_support/#Post_Thumbnails
             */
            add_theme_support('post-thumbnails');
            set_post_thumbnail_size(1290, 700, true);

            add_image_size('makbet-post-small', 330, 240, true);
            add_image_size('makbet-post-medium', 410, 300, true);
            add_image_size('makbet-post-large', 860, 630, true);
            add_image_size('makbet-post-xlarge', 680, 360, true);

            add_image_size('makbet-service', 380, 278, true);
            add_image_size('makbet-service-large', 630, 680, true);

            add_image_size('makbet-portfolio', 410, 320, true);
            add_image_size('makbet-portfolio-medium', 450, 580, true);
            add_image_size('makbet-portfolio-large', 730, 480, true);

            /**
             * Register menu locations.
             */
            register_nav_menus(
                apply_filters(
                    'makbet_register_nav_menus', array(
                        'primary'  => esc_html__('Primary Menu', 'makbet'),
                        'handheld' => esc_html__('Handheld Menu', 'makbet'),
                    )
                )
            );

            // Add theme support for Custom Logo.
            add_theme_support('custom-logo', array(
                'width'       => 300,
                'height'      => 200,
                'flex-width'  => true,
                'flex-height' => true,
            ));

            /*
             * Switch default core markup for search form, comment form, comments, galleries, captions and widgets
             * to output valid HTML5.
             */
            add_theme_support(
                'html5', apply_filters(
                    'makbet_html5_args', array(
                        'search-form',
                        'comment-form',
                        'comment-list',
                        'gallery',
                        'caption',
                        'widgets',
                        'script',
                        'style',
                    )
                )
            );

            /**
             * Declare support for title theme feature.
             */
            add_theme_support('title-tag');

            /**
             * Declare support for selective refreshing of widgets.
             */
            add_theme_support('customize-selective-refresh-widgets');

            /**
             * Add support for Block Styles.
             */
            add_theme_support('wp-block-styles');

            /**
             * Add support for full and wide align images.
             */
            add_theme_support('align-wide');

            /**
             * Add support for editor styles.
             */
            add_theme_support('editor-styles');

            /**
             * Add support for editor font sizes.
             */
            add_theme_support('editor-font-sizes', array(
                array(
                    'name' => esc_html__('Small', 'makbet'),
                    'size' => 14,
                    'slug' => 'small',
                ),
                array(
                    'name' => esc_html__('Normal', 'makbet'),
                    'size' => 16,
                    'slug' => 'normal',
                ),
                array(
                    'name' => esc_html__('Medium', 'makbet'),
                    'size' => 23,
                    'slug' => 'medium',
                ),
                array(
                    'name' => esc_html__('Large', 'makbet'),
                    'size' => 26,
                    'slug' => 'large',
                ),
                array(
                    'name' => esc_html__('Huge', 'makbet'),
                    'size' => 37,
                    'slug' => 'huge',
                ),
            ));

            /**
             * Enqueue editor styles.
             */
            add_editor_style(array('assets/css/base/gutenberg-editor.css', $this->google_fonts()));

            /**
             * Add support for responsive embedded content.
             */
            add_theme_support('responsive-embeds');
        }

        public function includes() {

            // Merlin WP Setup Wizard
            require_once get_theme_file_path('inc/merlin/vendor/autoload.php');
            require_once get_theme_file_path('inc/merlin/class-merlin.php');
            require_once get_theme_file_path('inc/merlin-config.php');

            if (class_exists('Pavo_CPT')) {
                $files = glob(trailingslashit(get_template_directory()) . 'inc/core/*.php');
                foreach ($files as $file) {
                    require $file;
                }
            }
        }

        /**
         * Register widget area.
         *
         * @link https://codex.wordpress.org/Function_Reference/register_sidebar
         */
        public function widgets_init() {
            $sidebar_args['sidebar']        = array(
                'name'        => esc_html__('Sidebar Archive', 'makbet'),
                'id'          => 'sidebar-blog',
                'description' => '',
            );
            $sidebar_args['sidebar-single'] = array(
                'name'        => esc_html__('Sidebar Single Post', 'makbet'),
                'id'          => 'sidebar-single',
                'description' => '',
            );


            $sidebar_args = apply_filters('makbet_sidebar_args', $sidebar_args);

            foreach ($sidebar_args as $sidebar => $args) {
                $widget_tags = array(
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<span class="gamma widget-title">',
                    'after_title'   => '</span>',
                );

                $filter_hook = sprintf('makbet_%s_widget_tags', $sidebar);
                $widget_tags = apply_filters($filter_hook, $widget_tags);

                if (is_array($widget_tags)) {
                    register_sidebar($args + $widget_tags);
                }
            }
        }

        public function check_sidebar_params($params) {
            global $wp_registered_widgets;
            $settings_getter = $wp_registered_widgets[$params[0]['widget_id']]['callback'][0];
            $settings        = $settings_getter->get_settings();
            $settings        = $settings[$params[1]['number']];
            if ($params[0]['after_widget'] == '</div>' && isset($settings['title'])) {
                if (!empty($settings['title'])) {
                    $params[0]['after_title']  .= '<div class="widget-content">';
                    $params[0]['after_widget'] .= '</div>';
                } else {
                    $params[0]['before_widget'] .= '<div class="widget-content">';
                    $params[0]['after_widget']  .= '</div>';
                }
            }

            return $params;
        }

        public function admin_scripts() {
            wp_enqueue_style('makbet-admin-style', get_theme_file_uri('assets/css/admin/admin.css'));
        }

        public function register_scripts_addon() {
            /**
             * Scripts Makbet
             */
            wp_register_script('makbet-theme', get_template_directory_uri() . '/assets/js/frontend/main' . MAKBET_SUFFIX . '.js', array('jquery', 'wp-util', 'swiper'), MAKBET_VERSION, true);
            wp_register_script('makbet-swiper', get_template_directory_uri() . '/assets/js/frontend/swiper' . MAKBET_SUFFIX . '.js', array('jquery', 'wp-util', 'swiper'), MAKBET_VERSION, true);
            wp_register_script('makbet-countdown', get_template_directory_uri() . '/assets/js/frontend/countdown' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);
            wp_register_script('makbet-text-editor', get_template_directory_uri() . '/assets/js/frontend/text-editor' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);
            wp_register_script('makbet-nav-mobile', get_template_directory_uri() . '/assets/js/frontend/nav-mobile' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);
            wp_register_script('makbet-search-popup', get_template_directory_uri() . '/assets/js/frontend/search-popup' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);
            wp_register_script('makbet-skip-link-focus-fix', get_template_directory_uri() . '/assets/js/skip-link-focus-fix' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);

            wp_register_script('makbet-button-hover', get_template_directory_uri() . '/assets/js/frontend/button-hover' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);
            wp_register_script('makbet-text-split', get_template_directory_uri() . '/assets/js/frontend/text-split' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);

            //Scripts libs
            wp_register_script('beforeafter', get_template_directory_uri() . '/assets/js/libs/beforeafter.jquery' . MAKBET_SUFFIX . '.js', array(), MAKBET_VERSION, true);
            wp_register_script('tooltipster', get_template_directory_uri() . '/assets/js/libs/tooltipster.bundle' . MAKBET_SUFFIX . '.js', array(), MAKBET_VERSION, true);
            wp_register_script('masonry-pkgd', get_template_directory_uri() . '/assets/js/libs/masonry.pkgd' . MAKBET_SUFFIX . '.js', array(), MAKBET_VERSION, true);
            wp_register_script('jquery-scrollbar', get_template_directory_uri() . '/assets/js/libs/jquery.scrollbar' . MAKBET_SUFFIX . '.js', array(), MAKBET_VERSION, true);
            wp_register_script('isotope', get_template_directory_uri() . '/assets/js/libs/isotope.pkgd' . MAKBET_SUFFIX . '.js', array(), MAKBET_VERSION, true);

            wp_register_script('magnific-popup', get_template_directory_uri() . '/assets/js/libs/jquery.magnific-popup' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);
            wp_register_script('spritespin', get_template_directory_uri() . '/assets/js/libs/spritespin' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);
            wp_register_script('waypoints', get_template_directory_uri() . '/assets/js/libs/jquery.waypoints' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);
            wp_register_script('sticky-kit', get_template_directory_uri() . '/assets/js/libs/jquery.sticky-kit' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);
            wp_register_script('panolens', get_template_directory_uri() . '/assets/js/libs/panolens' . MAKBET_SUFFIX . '.js', array('jquery'), MAKBET_VERSION, true);

            /**
             * Styles Makbet
             */
            wp_register_style('makbet-style', get_template_directory_uri() . '/style.css', '', MAKBET_VERSION);
//            wp_register_style('makbet-font-face', get_template_directory_uri() . '/assets/css/font-face.css', '', MAKBET_VERSION);
            wp_register_style('makbet-icon', get_template_directory_uri() . '/assets/css/icons.css', '', MAKBET_VERSION);
            wp_register_style('makbet-elementor-grid', get_template_directory_uri() . '/assets/css/elementor-grid.css', '', MAKBET_VERSION);

            //libs
            wp_register_style('tooltipster', get_template_directory_uri() . '/assets/css/libs/tooltipster.bundle.min.css', '', MAKBET_VERSION);
            wp_register_style('jquery-scrollbar', get_template_directory_uri() . '/assets/css/libs/jquery.scrollbar.css', '', MAKBET_VERSION);
            wp_register_style('magnific-popup', get_template_directory_uri() . '/assets/css/libs/magnific-popup.css', '', MAKBET_VERSION);

            if (!wp_script_is('swiper', 'enqueued')) {
                wp_register_script('swiper', get_template_directory_uri() . '/assets/js/libs/swiper.js', array(), '8.4.5', true);
            }
            if (!wp_style_is('swiper-css', 'enqueued')) {
                wp_enqueue_style('swiper-css', get_template_directory_uri() . '/assets/css/libs/swiper.css', '', '8.4.5');
            }
            if (!wp_style_is('e-swiper-css', 'enqueued')) {
                wp_enqueue_style('swiper-css', get_template_directory_uri() . '/assets/css/libs/e-swiper.css', '', MAKBET_VERSION);
            }
        }

        /**
         * Enqueue scripts and styles.
         *
         * @since  1.0.0
         */
        public function scripts() {
            /**
             * Google Fonts Default
             */
            wp_enqueue_style('makbet-fonts', $this->google_fonts(), array(), null);
//            wp_enqueue_style('makbet-font-face');

            /**
             * Styles
             */
            wp_enqueue_style('makbet-icon');
            wp_enqueue_style('makbet-style');
            wp_enqueue_style('e-swiper');
            wp_style_add_data('makbet-style', 'rtl', 'replace');

            if (!makbet_is_elementor_activated()) {
                wp_enqueue_style('makbet-elementor-grid');
            }

            /**
             * Scripts
             */
            wp_enqueue_script('sticky-kit');
            wp_enqueue_script('makbet-theme');
            wp_localize_script('makbet-theme', 'makbetAjax', array('ajaxurl' => admin_url('admin-ajax.php')));
            wp_enqueue_script('imagesloaded');
            wp_enqueue_script('makbet-skip-link-focus-fix');
            wp_enqueue_script('makbet-search-popup');
            wp_enqueue_script('makbet-button-hover');
            wp_enqueue_script('makbet-text-split');

            if (is_singular() && comments_open() && get_option('thread_comments')) {
                wp_enqueue_script('comment-reply');
            }
            if (isset(get_nav_menu_locations()['handheld'])) {
                wp_enqueue_script('makbet-nav-mobile');
            }
        }

        /**
         * Register Google fonts.
         *
         * @return string Google fonts URL for the theme.
         * value : 'Fustat' => 'Fustat+Solid:300,400,900',
         * @since 2.4.0
         */
        public function google_fonts() {
            $google_fonts = apply_filters('makbet_google_font_families', array(
                'Cal+Sans'    => 'Cal+Sans',
                'Inter+Tight' => 'Inter+Tight:ital,wght@0,100..900;1,100..900',
            ));

            if (count($google_fonts) <= 0) {
                return false;
            }

            $query_args = array(
                'family'  => implode('&family=', $google_fonts),
                'subset'  => rawurlencode('latin,latin-ext'),
                'display' => 'swap',
            );

            $fonts_url = add_query_arg($query_args, '//fonts.googleapis.com/css2');

            return $fonts_url;
        }

        /**
         * Enqueue block assets.
         *
         * @since 2.5.0
         */
        public function block_assets() {

            // Styles.
            wp_enqueue_style('makbet-gutenberg-blocks', get_template_directory_uri() . '/assets/css/gutenberg-blocks.css', '', MAKBET_VERSION);
            wp_style_add_data('makbet-gutenberg-blocks', 'rtl', 'replace');
        }

        /**
         * Enqueue child theme stylesheet.
         * A separate function is required as the child theme css needs to be enqueued _after_ the parent theme
         * primary css and the separate WooCommerce css.
         *
         * @since  1.5.3
         */
        public function child_scripts() {
            if (is_child_theme()) {
                $child_theme = wp_get_theme(get_stylesheet());
                wp_enqueue_style('makbet-child-style', get_stylesheet_uri(), array(), $child_theme->get('Version'));
            }
        }

        /**
         * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
         *
         * @param array $args Configuration arguments.
         *
         * @return array
         */
        public function page_menu_args($args) {
            $args['show_home'] = true;

            return $args;
        }

        /**
         * Adds custom classes to the array of body classes.
         *
         * @param array $classes Classes for the body element.
         *
         * @return array
         */
        public function body_classes($classes) {
            global $is_lynx, $is_gecko, $is_IE, $is_opera, $is_NS4, $is_safari, $is_chrome, $is_iphone;
            if ($is_lynx) {
                $classes[] = 'lynx';
            } elseif ($is_gecko) {
                $classes[] = 'gecko';
            } elseif ($is_opera) {
                $classes[] = 'opera';
            } elseif ($is_NS4) {
                $classes[] = 'ns4';
            } elseif ($is_safari) {
                $classes[] = 'safari';
            } elseif ($is_chrome) {
                $classes[] = 'chrome';
            } elseif ($is_IE) {
                $classes[] = 'ie';
            }

            if ($is_iphone) {
                $classes[] = 'iphone';
            }

            // Adds a class to blogs with more than 1 published author.
            if (is_multi_author()) {
                $classes[] = 'group-blog';
            }

            /**
             * Adds a class when WooCommerce is not active.
             *
             * @todo Refactor child themes to remove dependency on this class.
             */
            $classes[] = 'no-wc-breadcrumb';

            if (
                is_singular('pavo_portfolio')
                || is_singular('pavo_service')
                || is_post_type_archive('pavo_portfolio')
                || is_post_type_archive('pavo_service')
                || is_tax('pavo_portfolio_cat')
                || is_tax('pavo_service_cat')
            ) {
                $classes[] = 'makbet-full-width-content';
            } elseif (is_singular('post')) {
                if (!is_active_sidebar('sidebar-single')) {
                    $classes[] = 'makbet-full-width-content';
                } else {
                    if (makbet_get_theme_option('blog_single_sidebar') == 'none') {
                        $classes[] = 'makbet-full-width-content';
                    } else {
                        $classes[] = 'makbet-sidebar-' . makbet_get_theme_option('blog_single_sidebar');
                    }
                }
            } else {
                if (is_archive() || is_home() || is_category() || is_tag() || is_author() || is_search()) {
                    if (!is_active_sidebar('sidebar-blog')) {
                        $classes[] = 'makbet-full-width-content';
                    } else {
                        if (makbet_get_theme_option('blog_sidebar') == 'none') {
                            $classes[] = 'makbet-full-width-content';
                        } else {
                            $classes[] = 'makbet-sidebar-' . makbet_get_theme_option('blog_sidebar');
                        }
                    }
                }
            }

            // Add class when using homepage template + featured image.
            if (has_post_thumbnail()) {
                $classes[] = 'has-post-thumbnail';
            }

            return $classes;
        }

        public function set_sidebar($name) {
            if (
                is_singular('pavo_portfolio')
                || is_singular('pavo_service')
                || is_post_type_archive('pavo_portfolio')
                || is_post_type_archive('pavo_service')
                || is_tax('pavo_portfolio_cat')
                || is_tax('pavo_service_cat')
            ) {
                return false;
            }

            if (is_singular('post')) {
                if (is_active_sidebar('sidebar-single') && makbet_get_theme_option('blog_single_sidebar') != 'none') {
                    $name = 'sidebar-single';
                }
            } else {
                if (is_archive() || is_home() || is_category() || is_tag() || is_author() || is_search()) {
                    if (is_active_sidebar('sidebar-blog') && makbet_get_theme_option('blog_sidebar') != 'none') {
                        $name = 'sidebar-blog';
                    }
                }
            }

            return $name;
        }

        /**
         * Adds a custom parameter to the editor settings that is used
         * to track whether the main sidebar has widgets.
         *
         * @param array $settings Default editor settings.
         * @param WP_Post $post Post being edited.
         *
         * @return array Filtered block editor settings.
         * @since 2.4.3
         *
         */
        public function custom_editor_settings($settings, $post) {
            $settings['mainSidebarActive'] = false;

            if (is_active_sidebar('sidebar-blog')) {
                $settings['mainSidebarActive'] = true;
            }

            return $settings;
        }

        /**
         * Custom navigation markup template hooked into `navigation_markup_template` filter hook.
         */
        public function navigation_markup_template() {
            $template = '<nav id="post-navigation" class="navigation %1$s" role="navigation" aria-label="' . esc_attr__('Post Navigation', 'makbet') . '">';
            $template .= '<h2 class="screen-reader-text">%2$s</h2>';
            $template .= '<div class="nav-links">%3$s</div>';
            $template .= '</nav>';

            return apply_filters('makbet_navigation_markup_template', $template);
        }
    }
endif;

return new Makbet();
