<?php

use Elementor\Core\Files\File_Types\Svg;
use Elementor\Plugin;

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Makbet_Elementor')) :

    /**
     * The Makbet Elementor Integration class
     */
    class Makbet_Elementor {

        public function __construct() {
            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'register_auto_scripts_frontend']);
            add_action('wp_enqueue_scripts', [$this, 'add_scripts'], 15);
            add_action('elementor/elements/categories_registered', [$this, 'create_custom_category'], 999);
            add_action('elementor/widgets/register', array($this, 'include_widgets'));

            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'add_js']);

            // Custom Animation Scroll
            add_filter('elementor/controls/animations/additional_animations', [$this, 'add_animations_scroll']);
            add_filter('wp_enqueue_scripts', [$this, 'add_animations_scroll_style']);

            // Backend
            add_action('elementor/editor/after_enqueue_styles', [$this, 'add_style_editor'], 99);

            // Add Icon Custom
            add_action('elementor/icons_manager/native', [$this, 'add_icons_native']);
            add_action('elementor/controls/controls_registered', [$this, 'add_icons']);

            // Add Breakpoints
            add_action('wp_enqueue_scripts', 'makbet_elementor_breakpoints', 9999);
            add_action('elementor/init', function() {
                if ( ! function_exists('makbet_is_elementor_pro_activated') || ! makbet_is_elementor_pro_activated() ) {
                    require_once get_theme_file_path('inc/elementor/motion-fx/controls-group.php');
                    require_once get_theme_file_path('inc/elementor/motion-fx/module.php');
                }
            });

            if (!makbet_is_elementor_pro_activated()) {
                require trailingslashit(get_template_directory()) . 'inc/elementor/class-custom-css.php';
                require trailingslashit(get_template_directory()) . 'inc/elementor/class-section-sticky.php';
                require get_theme_file_path('inc/elementor/motion-fx/controls-group.php');
                require get_theme_file_path('inc/elementor/motion-fx/module.php');
                if (is_admin()) {
                    add_action('manage_elementor_library_posts_columns', [$this, 'admin_columns_headers']);
                    add_action('manage_elementor_library_posts_custom_column', [$this, 'admin_columns_content'], 10, 2);
                }
            }

            add_filter('elementor/fonts/additional_fonts', [$this, 'additional_fonts']);
        }


        public function additional_fonts($fonts) {
            $fonts["Cal Sans"] = 'system';
            return $fonts;
        }

        public function admin_columns_headers($defaults) {
            $defaults['shortcode'] = esc_html__('Shortcode', 'makbet');

            return $defaults;
        }

        public function admin_columns_content($column_name, $post_id) {
            if ('shortcode' === $column_name) {
                ob_start();
                ?>
                <input class="elementor-shortcode-input" type="text" readonly onfocus="this.select()" value="[hfe_template id='<?php echo esc_attr($post_id); ?>']"/>
                <?php
                ob_get_contents();
            }
        }

        public function add_js() {
            wp_enqueue_script('makbet-elementor-frontend', get_theme_file_uri('/assets/js/elementor-frontend' . MAKBET_SUFFIX . '.js'), '', MAKBET_VERSION);
        }

        public function add_style_editor() {
            wp_enqueue_style('makbet-icon', get_template_directory_uri() . '/assets/css/icons.css', '', MAKBET_VERSION);
        }

        public function add_scripts() {
            wp_enqueue_style('makbet-elementor', get_template_directory_uri() . '/assets/css/elementor.css', '', MAKBET_VERSION);
            wp_style_add_data('makbet-elementor', 'rtl', 'replace');

            // Add Scripts
            wp_register_script('tweenmax', get_theme_file_uri('/assets/js/libs/TweenMax.min.js'), array('jquery'), '1.11.1');
            wp_register_script('multi-parallax', get_theme_file_uri('/assets/js/frontend/multi-parallax' . MAKBET_SUFFIX . '.js'), array('jquery'), MAKBET_VERSION);
            if (makbet_elementor_check_type('animated-bg-parallax')) {
                wp_enqueue_script('tweenmax');
                wp_enqueue_script('jquery-panr', get_theme_file_uri('/assets/js/libs/jquery-panr' . MAKBET_SUFFIX . '.js'), array('jquery'), '0.0.1');
            }
        }

        public function register_auto_scripts_frontend() {
            //js;
            wp_register_script('makbet-elementor-about-box', get_theme_file_uri('/assets/js/elementor/about-box' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-brand', get_theme_file_uri('/assets/js/elementor/brand' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-icon-box', get_theme_file_uri('/assets/js/elementor/icon-box' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-image-gallery', get_theme_file_uri('/assets/js/elementor/image-gallery' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-number-box', get_theme_file_uri('/assets/js/elementor/number-box' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-portfolio', get_theme_file_uri('/assets/js/elementor/portfolio' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-posts-grid', get_theme_file_uri('/assets/js/elementor/posts-grid' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-price-table', get_theme_file_uri('/assets/js/elementor/price-table' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-process', get_theme_file_uri('/assets/js/elementor/process' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-progress-bar', get_theme_file_uri('/assets/js/elementor/progress-bar' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-service', get_theme_file_uri('/assets/js/elementor/service' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-slider-scrolling', get_theme_file_uri('/assets/js/elementor/slider-scrolling' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-step', get_theme_file_uri('/assets/js/elementor/step' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-team-box', get_theme_file_uri('/assets/js/elementor/team-box' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-testimonial', get_theme_file_uri('/assets/js/elementor/testimonial' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-transform', get_theme_file_uri('/assets/js/elementor/transform' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
            wp_register_script('makbet-elementor-video', get_theme_file_uri('/assets/js/elementor/video' . MAKBET_SUFFIX . '.js'), array('jquery','elementor-frontend'), MAKBET_VERSION, true);
           
        }

        public function create_custom_category($elements_manager) {
            $elements_manager->add_category(
                'makbet-addons',
                array(
                    'title' => esc_html__('Makbet Addons', 'makbet'),
                    'icon'  => 'fa fa-plug',
                )
            );
        }

        public function get_animations_scroll() {
            $animations = [
                'pavo-move-up'    => 'Move Up',
                'pavo-move-down'  => 'Move Down',
                'pavo-move-left'  => 'Move Left',
                'pavo-move-right' => 'Move Right',
                'pavo-flip'       => 'Flip',
                'pavo-helix'      => 'Helix',
                'pavo-scale-up'   => 'Scale',
                'pavo-am-popup'   => 'Popup',
            ];
            return $animations;
        }

        public function add_animations_scroll($animations) {
            $animations['Makbet Animation'] = $this->get_animations_scroll();
            return $animations;
        }

        public function add_animations_scroll_style() {
            $animations = $this->get_animations_scroll();
            foreach ($animations as $animation => $name) {
                wp_deregister_style('e-animation-' . $animation);
                wp_register_style('e-animation-' . $animation, get_theme_file_uri('/assets/css/animations/' . $animation . '.css'), [], MAKBET_SUFFIX);
            }
        }

        /**
         * @param $widgets_manager Elementor\Widgets_Manager
         */
        public function include_widgets($widgets_manager) {
            require_once get_theme_file_path('/inc/elementor/base/widget-base.php');

            $files_custom = glob(get_theme_file_path('/inc/elementor/custom-widgets/*.php'));
            foreach ($files_custom as $file) {
                if (file_exists($file)) {
                    require_once $file;
                }
            }

            $files = glob(get_theme_file_path('/inc/elementor/widgets/*.php'));
            foreach ($files as $file) {
                if (file_exists($file)) {
                    require_once $file;

                }
            }
        }

        public function add_icons( $manager ) {
            $new_icons = json_decode( '{"makbet-icon-analytical":"analytical","makbet-icon-arrow-drop-down":"arrow-drop-down","makbet-icon-arrow-drop-up":"arrow-drop-up","makbet-icon-arrow-right-normal":"arrow-right-normal","makbet-icon-call":"call","makbet-icon-close-circle-fill":"close-circle-fill","makbet-icon-creative":"creative","makbet-icon-difference":"difference","makbet-icon-drop-down-line":"drop-down-line","makbet-icon-hexagonal":"hexagonal","makbet-icon-increase":"increase","makbet-icon-mail-check":"mail-check","makbet-icon-mail":"mail","makbet-icon-making":"making","makbet-icon-map-pin":"map-pin","makbet-icon-nav-next":"nav-next","makbet-icon-nav-prev":"nav-prev","makbet-icon-phone-call":"phone-call","makbet-icon-search-1":"search-1","makbet-icon-search-lg":"search-lg","makbet-icon-target":"target","makbet-icon-variety":"variety","makbet-icon-versatility":"versatility","makbet-icon-wechat":"wechat","makbet-icon-360":"360","makbet-icon-add-line":"add-line","makbet-icon-add-to-cart":"add-to-cart","makbet-icon-airplane":"airplane","makbet-icon-angle-down":"angle-down","makbet-icon-angle-left":"angle-left","makbet-icon-angle-right":"angle-right","makbet-icon-angle-up":"angle-up","makbet-icon-arrow-alt-circle-down":"arrow-alt-circle-down","makbet-icon-arrow-alt-circle-left":"arrow-alt-circle-left","makbet-icon-arrow-alt-circle-right":"arrow-alt-circle-right","makbet-icon-arrow-alt-circle-up":"arrow-alt-circle-up","makbet-icon-arrow-alt-down":"arrow-alt-down","makbet-icon-arrow-alt-from-bottom":"arrow-alt-from-bottom","makbet-icon-arrow-alt-from-left":"arrow-alt-from-left","makbet-icon-arrow-alt-from-right":"arrow-alt-from-right","makbet-icon-arrow-alt-from-top":"arrow-alt-from-top","makbet-icon-arrow-alt-left":"arrow-alt-left","makbet-icon-arrow-alt-right":"arrow-alt-right","makbet-icon-arrow-alt-square-down":"arrow-alt-square-down","makbet-icon-arrow-alt-square-left":"arrow-alt-square-left","makbet-icon-arrow-alt-square-right":"arrow-alt-square-right","makbet-icon-arrow-alt-square-up":"arrow-alt-square-up","makbet-icon-arrow-alt-to-bottom":"arrow-alt-to-bottom","makbet-icon-arrow-alt-to-left":"arrow-alt-to-left","makbet-icon-arrow-alt-to-right":"arrow-alt-to-right","makbet-icon-arrow-alt-to-top":"arrow-alt-to-top","makbet-icon-arrow-alt-up":"arrow-alt-up","makbet-icon-arrow-circle-down":"arrow-circle-down","makbet-icon-arrow-circle-left":"arrow-circle-left","makbet-icon-arrow-circle-right":"arrow-circle-right","makbet-icon-arrow-circle-up":"arrow-circle-up","makbet-icon-arrow-down":"arrow-down","makbet-icon-arrow-drop-right-line":"arrow-drop-right-line","makbet-icon-arrow-from-bottom":"arrow-from-bottom","makbet-icon-arrow-from-left":"arrow-from-left","makbet-icon-arrow-from-right":"arrow-from-right","makbet-icon-arrow-from-top":"arrow-from-top","makbet-icon-arrow-left-btn":"arrow-left-btn","makbet-icon-arrow-left":"arrow-left","makbet-icon-arrow-right-btn":"arrow-right-btn","makbet-icon-arrow-right":"arrow-right","makbet-icon-arrow-small-top":"arrow-small-top","makbet-icon-arrow-square-down":"arrow-square-down","makbet-icon-arrow-square-left":"arrow-square-left","makbet-icon-arrow-square-right":"arrow-square-right","makbet-icon-arrow-square-up":"arrow-square-up","makbet-icon-arrow-to-bottom":"arrow-to-bottom","makbet-icon-arrow-to-left":"arrow-to-left","makbet-icon-arrow-to-right":"arrow-to-right","makbet-icon-arrow-to-top":"arrow-to-top","makbet-icon-arrow-top":"arrow-top","makbet-icon-arrow-up":"arrow-up","makbet-icon-arrows-alt-h":"arrows-alt-h","makbet-icon-arrows-alt-v":"arrows-alt-v","makbet-icon-arrows-alt":"arrows-alt","makbet-icon-arrows-h":"arrows-h","makbet-icon-arrows-v":"arrows-v","makbet-icon-arrows":"arrows","makbet-icon-calendar-check-02":"calendar-check-02","makbet-icon-calendar":"calendar","makbet-icon-call-calling":"call-calling","makbet-icon-call-history":"call-history","makbet-icon-caret-circle-down":"caret-circle-down","makbet-icon-caret-circle-left":"caret-circle-left","makbet-icon-caret-circle-right":"caret-circle-right","makbet-icon-caret-circle-up":"caret-circle-up","makbet-icon-caret-down":"caret-down","makbet-icon-caret-left":"caret-left","makbet-icon-caret-right":"caret-right","makbet-icon-caret-square-down":"caret-square-down","makbet-icon-caret-square-left":"caret-square-left","makbet-icon-caret-square-right":"caret-square-right","makbet-icon-caret-square-up":"caret-square-up","makbet-icon-caret-up":"caret-up","makbet-icon-cart-arrow-down":"cart-arrow-down","makbet-icon-cart-empty":"cart-empty","makbet-icon-cart-s":"cart-s","makbet-icon-chat":"chat","makbet-icon-check-circle":"check-circle","makbet-icon-check-double":"check-double","makbet-icon-check-fill":"check-fill","makbet-icon-check-s":"check-s","makbet-icon-check-square":"check-square","makbet-icon-check":"check","makbet-icon-checkbox-circle-fill":"checkbox-circle-fill","makbet-icon-chevron-double-down":"chevron-double-down","makbet-icon-chevron-double-left":"chevron-double-left","makbet-icon-chevron-double-right":"chevron-double-right","makbet-icon-chevron-double-up":"chevron-double-up","makbet-icon-chevron-down":"chevron-down","makbet-icon-chevron-left":"chevron-left","makbet-icon-chevron-right":"chevron-right","makbet-icon-chevron-square-down":"chevron-square-down","makbet-icon-chevron-up":"chevron-up","makbet-icon-close":"close","makbet-icon-cloud-download-alt":"cloud-download-alt","makbet-icon-comment-info":"comment-info","makbet-icon-comments-alt":"comments-alt","makbet-icon-compare":"compare","makbet-icon-compress-arrows-alt":"compress-arrows-alt","makbet-icon-credit-card":"credit-card","makbet-icon-dot-circle":"dot-circle","makbet-icon-dotfour":"dotfour","makbet-icon-down-filled-arrow":"down-filled-arrow","makbet-icon-edit":"edit","makbet-icon-envelope":"envelope","makbet-icon-equalizer-line":"equalizer-line","makbet-icon-expand-arrows-alt":"expand-arrows-alt","makbet-icon-expand-arrows":"expand-arrows","makbet-icon-eye-dropper":"eye-dropper","makbet-icon-eye-slash":"eye-slash","makbet-icon-eye":"eye","makbet-icon-facebook-cicrle":"facebook-cicrle","makbet-icon-facebook":"facebook","makbet-icon-file-alt":"file-alt","makbet-icon-file-archive":"file-archive","makbet-icon-filter":"filter","makbet-icon-frown-open":"frown-open","makbet-icon-frown":"frown","makbet-icon-gift-card":"gift-card","makbet-icon-gift":"gift","makbet-icon-gifts":"gifts","makbet-icon-globe":"globe","makbet-icon-heart":"heart","makbet-icon-home":"home","makbet-icon-info-circle":"info-circle","makbet-icon-instagram":"instagram","makbet-icon-layout-grid":"layout-grid","makbet-icon-layout-list":"layout-list","makbet-icon-LinkedIn":"LinkedIn","makbet-icon-liquid":"liquid","makbet-icon-location-arrow":"location-arrow","makbet-icon-location":"location","makbet-icon-long-arrow-alt-down":"long-arrow-alt-down","makbet-icon-long-arrow-alt-left":"long-arrow-alt-left","makbet-icon-long-arrow-alt-right":"long-arrow-alt-right","makbet-icon-long-arrow-alt-up":"long-arrow-alt-up","makbet-icon-long-arrow-down":"long-arrow-down","makbet-icon-long-arrow-left":"long-arrow-left","makbet-icon-long-arrow-right-up":"long-arrow-right-up","makbet-icon-long-arrow-right":"long-arrow-right","makbet-icon-long-arrow-up":"long-arrow-up","makbet-icon-mail-send-line":"mail-send-line","makbet-icon-map-pin-converted":"map-pin-converted","makbet-icon-marker":"marker","makbet-icon-meh-blank":"meh-blank","makbet-icon-meh-rolling-eyes":"meh-rolling-eyes","makbet-icon-meh":"meh","makbet-icon-minus-circle":"minus-circle","makbet-icon-minus":"minus","makbet-icon-mobile":"mobile","makbet-icon-money-check-alt":"money-check-alt","makbet-icon-overlap":"overlap","makbet-icon-paper-plane":"paper-plane","makbet-icon-pen-tool":"pen-tool","makbet-icon-pen":"pen","makbet-icon-phone":"phone","makbet-icon-pin":"pin","makbet-icon-pinterest":"pinterest","makbet-icon-plane-arrival":"plane-arrival","makbet-icon-plane":"plane","makbet-icon-play-fill":"play-fill","makbet-icon-play-yy":"play-yy","makbet-icon-plus-circle":"plus-circle","makbet-icon-plus-thin":"plus-thin","makbet-icon-plus":"plus","makbet-icon-Polygon":"Polygon","makbet-icon-question":"question","makbet-icon-quickview":"quickview","makbet-icon-quotation":"quotation","makbet-icon-quotes":"quotes","makbet-icon-random":"random","makbet-icon-rating-star":"rating-star","makbet-icon-rating":"rating","makbet-icon-repeat":"repeat","makbet-icon-reply-line":"reply-line","makbet-icon-reply":"reply","makbet-icon-return":"return","makbet-icon-right-bold":"right-bold","makbet-icon-right":"right","makbet-icon-search-plus":"search-plus","makbet-icon-search":"search","makbet-icon-share-all":"share-all","makbet-icon-share":"share","makbet-icon-shopping-bag":"shopping-bag","makbet-icon-shopping-basket":"shopping-basket","makbet-icon-shopping-cart":"shopping-cart","makbet-icon-sign-out-alt":"sign-out-alt","makbet-icon-smile":"smile","makbet-icon-sp-cart":"sp-cart","makbet-icon-spinner-01":"spinner-01","makbet-icon-spinner-third":"spinner-third","makbet-icon-square-fill":"square-fill","makbet-icon-square-full":"square-full","makbet-icon-star-exclamation":"star-exclamation","makbet-icon-star-half-alt":"star-half-alt","makbet-icon-star-half":"star-half","makbet-icon-star-o":"star-o","makbet-icon-star":"star","makbet-icon-stars":"stars","makbet-icon-sub-line":"sub-line","makbet-icon-sync-alt":"sync-alt","makbet-icon-sync":"sync","makbet-icon-telephone":"telephone","makbet-icon-th-list":"th-list","makbet-icon-time-line":"time-line","makbet-icon-times-circle":"times-circle","makbet-icon-times":"times","makbet-icon-twitter":"twitter","makbet-icon-unlock":"unlock","makbet-icon-user-circle":"user-circle","makbet-icon-user":"user","makbet-icon-video":"video","makbet-icon-wishlist":"wishlist","makbet-icon-world":"world","makbet-icon-youtube-o":"youtube-o","makbet-icon-youtube":"youtube","makbet-icon-zoom-in":"zoom-in"}', true );
			$icons     = $manager->get_control( 'icon' )->get_settings( 'options' );
			$new_icons = array_merge(
				$new_icons,
				$icons
			);
			// Then we set a new list of icons as the options of the icon control
			$manager->get_control( 'icon' )->set_settings( 'options', $new_icons ); 
        }

        public function add_icons_native($tabs) {
            $tabs['pavo-custom'] = [
                'name'          => 'makbet-icon',
                'label'         => esc_html__('Makbet Icon', 'makbet'),
                'prefix'        => 'makbet-icon-',
                'displayPrefix' => 'makbet-icon-',
                'labelIcon'     => 'fab fa-font-awesome-alt',
                'ver'           => MAKBET_VERSION,
                'fetchJson'     => get_theme_file_uri('/inc/elementor/icons.json'),
                'native'        => true,
            ];

            return $tabs;
        }
    }

endif;

return new Makbet_Elementor();
