<?php
// Image
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
add_action('elementor/element/nested-tabs/section_tabs/before_section_end', function ($element, $args) {
    $default_args = [
        'section_condition' => [],
    ];
    $args = wp_parse_args( $args, $default_args );

    $element->update_control( 'tabs_justify_horizontal', [
        'condition' => array_merge(
            $args['section_condition'],
            [ 'tab_background_style!' => [ 'yes' ] ]
        ),
    ] );

    $element->update_control( 'title_alignment', [
        'condition' => array_merge(
            $args['section_condition'],
            [ 'tab_background_style!' => [ 'yes' ] ]
        ),
    ] );
    $element->update_control( 'tabs_direction', [
        'condition' => array_merge(
            $args['section_condition'],
            [ 'tab_background_style!' => [ 'yes' ] ]
        ),
    ] );
    $element->add_control(
        'tab_background_style',
        [
            'label'      => esc_html__('Style Background', 'makbet'),
            'type'      => Controls_Manager::SWITCHER,
            'default'   => 'no',
            'prefix_class' => 'style-background-',
        ]
    );

}, 10, 2);

