<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Makbet\Elementor\Makbet_Base_Widgets;


class Makbet_Elementor_About_Box extends Makbet_Base_Widgets {

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @return string Widget name.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'makbet-about-box';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @return string Widget title.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_title() {
        return esc_html__('Makbet About Box', 'makbet');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @return string Widget icon.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'eicon-archive';
    }

    public function get_script_depends() {
        return ['makbet-elementor-about-box'];
    }

    public function get_style_depends() {
        return [ 'e-swiper' ];
    }

    public function get_categories() {
        return array('makbet-addons');
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_about_box',
            [
                'label' => esc_html__('Item', 'makbet'),
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'about_box_icon_type',
            [
                'label' => esc_html__('Icon Type', 'makbet'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'icon',
                'options' => [
                    'icon' => esc_html__('Icon', 'makbet'),
                    'gif'  => esc_html__('GIF Image', 'makbet'),
                ],
            ]
        );

        $repeater->add_control(
            'about_box_icon',
            [
                'label' => esc_html__('Icon', 'makbet'),
                'type'  => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'about_box_icon_type' => 'icon',
                ],
            ]
        );

        $repeater->add_control(
            'about_box_gif',
            [
                'label' => esc_html__('GIF Image', 'makbet'),
                'type'  => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['image'],
                'condition' => [
                    'about_box_icon_type' => 'gif',
                ],
            ]
        );


        $repeater->add_control(
            'about_title',
            [
                'label'   => esc_html__('Title', 'makbet'),
                'default' => 'Clarity and Goal Setting',
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'about_content',
            [
                'label'       => esc_html__('Content', 'makbet'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => 'Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
                'label_block' => true,
                'rows'        => '6',
            ]
        );
        $repeater->add_control(
            'about_image',
            [
                'label'      => esc_html__('Choose Image', 'makbet'),
                'default' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
                'type'       => Controls_Manager::MEDIA,
                'show_label' => false,
            ]
        );
        $repeater->add_control(
            'about_link',
            [
                'label'       => esc_html__('Link to', 'makbet'),
                'placeholder' => esc_html__('https://your-link.com', 'makbet'),
                'type'        => Controls_Manager::URL,
            ]
        );
        $this->add_control(
            'about_box',
            [
                'label'       => esc_html__('Items', 'makbet'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ about_title }}}',
            ]
        );
        $this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name'      => 'about_image',
                'default'   => 'full',
                'separator' => 'none',
            ]
        );
        $this->add_control(
            'about_layout',
            [
                'label'   => esc_html__('Layout', 'makbet'),
                'type'    => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => 'Style 1',
                    '2' => 'Style 2',
                ],
                'prefix_class' => 'about-style-',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_about_box',
            [
                'label' => esc_html__('Box', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'about_box_gap',
            [
                'label'      => esc_html__('Gap', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption' => 'Gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'color_about_box_background',
            [
                'label'     => esc_html__('Background Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-about-box-item' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius_about_box',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding_about_box',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_about_title',
            [
                'label' => esc_html__('Title', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'about_title_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .about-title, {{WRAPPER}} .elementor-about-box-item .about-box-caption .about-title a'                                 => 'color: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'about_title_color_hover',
            [
                'label'     => esc_html__('Color Hover', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .about-title:hover, {{WRAPPER}} .elementor-about-box-item .about-box-caption .about-title a:hover'                   => 'color: {{VALUE}};',


                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'about_title_typography',
                'selector' => '{{WRAPPER}} .elementor-about-box-item .about-box-caption .about-title',
            ]
        );

        $this->add_responsive_control(
            'about_title_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .about-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_about_content',
            [
                'label' => esc_html__('Content', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'about_content_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-about-box-item .content-image .about-content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'about_content_typography',
                'selector' => '{{WRAPPER}} .elementor-about-box-item .content-image .about-content',
            ]
        );

        $this->add_responsive_control(
            'content_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item .content-image .about-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item .content-image .about-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_about_image',
            [
                'label' => esc_html__('Image', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'border_radius_image',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item .elementor-about-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_about_image_gif',
            [
                'label' => esc_html__('Image Gif', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'about_box_width_gif',
            [
                'label'      => esc_html__('Width', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', '%', 'vw'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .icon img' => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'about_box_height_gif',
            [
                'label'      => esc_html__('Height', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'vh', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .icon img' => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_about_icon',
            [
                'label' => esc_html__('Icon', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'about_icon_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .icon svg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'about_icon_size',
            [
                'label'      => esc_html__('Size', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'about_ic_width_svg',
            [
                'label'          => esc_html__('Width SVG', 'makbet'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'unit' => 'px',
                ],
                'size_units'     => ['%', 'px', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'about_ic_height_svg',
            [
                'label'          => esc_html__('Height SVG', 'makbet'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'unit' => 'px',
                ],
                'size_units'     => ['%', 'px', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .icon svg' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'about_icon_padding',
            [
                'label'      => esc_html__('Padding Icon', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-about-box-item .about-box-caption .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->get_controls_column();
        // Carousel options
        $this->get_control_carousel();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        if (!empty($settings['about_box']) && is_array($settings['about_box'])) {
            $this->add_render_attribute('wrapper', 'class', 'elementor-about-box-wrapper');
            $this->get_data_elementor_columns();
            $this->add_render_attribute('item', 'class', 'elementor-grid-item elementor-about-box-item');
            ?>
            <div <?php $this->print_render_attribute_string('wrapper'); ?>>
                <div <?php $this->print_render_attribute_string('container'); ?>>
                    <div <?php $this->print_render_attribute_string('inner'); ?>>
                        <?php foreach ($settings['about_box'] as $item):?>
                            <div <?php $this->print_render_attribute_string('item'); ?>>
                                <div class="about-box-caption">
                                    <?php
                                    $about_title_html = $item['about_title'];
                                    if (!empty($item['about_link']['url'])) :
                                        $about_title_html = '<a href="' . esc_url($item['about_link']['url']) . '">' . esc_html($about_title_html) . '</a>';
                                    endif;
                                    printf('<div class="about-title">%s</div>', $about_title_html);
                                    ?>
                                    <?php if (
                                        ($item['about_box_icon_type'] === 'icon' && !empty($item['about_box_icon']['value'])) ||
                                        ($item['about_box_icon_type'] === 'gif' && !empty($item['about_box_gif']['url']))
                                    ): ?>
                                        <div class="icon">
                                            <?php if ($item['about_box_icon_type'] === 'gif' && !empty($item['about_box_gif']['url'])): ?>
                                                <img src="<?php echo esc_url($item['about_box_gif']['url']); ?>" alt="">
                                            <?php elseif (!empty($item['about_box_icon']['value'])): ?>
                                                <?php \Elementor\Icons_Manager::render_icon($item['about_box_icon'], ['aria-hidden' => 'true']); ?>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="content-image">
                                    <?php if (!empty($item['about_content'])) : ?>
                                        <div class="about-content"><?php echo sprintf('%s', $item['about_content']); ?></div>
                                    <?php endif; ?>
                                    <?php $this->render_image($settings, $item); ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php $this->get_swiper_navigation(count($settings['about_box'])); ?>
                </div>
            </div>
            <?php

        }

    }
    private function render_image($settings, $item) {
        if (!empty($item['about_image']['url'])) :
            ?>
            <div class="elementor-about-image">
                <?php
                $item['about_image_size']             = $settings['about_image_size'];
                $item['about_image_custom_dimension'] = $settings['about_image_custom_dimension'];
                echo Group_Control_Image_Size::get_attachment_image_html($item, 'about_image');
                ?>
            </div>
        <?php
        endif;
    }
}
$widgets_manager->register(new Makbet_Elementor_About_Box());
