<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Makbet\Elementor\Makbet_Base_Widgets;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

/**
 * Elementor Archive Portfolio widget.
 *
 *
 * @since 1.0.0
 */
class Makbet_Elementor_Archive_Portfolio extends Makbet_Base_Widgets {

    public function get_categories() {
        return array('makbet-addons');
    }

    public function get_name() {
        return 'makbet-archive-portfolio';
    }

    public function get_title() {
        return esc_html__('Makbet Archive Portfolio', 'makbet');
    }

    public function get_icon() {
        return 'eicon-archive';
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('Settings', 'makbet'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'portfolio_style',
            [
                'label'   => esc_html__('Style', 'makbet'),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__('Style 1', 'makbet'),
                    '2' => esc_html__('Style 2', 'makbet'),
                    '3' => esc_html__('Style 3', 'makbet'),
                ],
                'default' => '3'
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name'      => 'portfolio_image',
                'default'   => 'makbet-portfolio',
                'separator' => 'none',
            ]
        );

        $this->end_controls_section();

        // Wrapper
        $this->start_controls_section(
            'section_style_wrapper',
            [
                'label' => esc_html__('Wrapper', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'flex',
            [
                'label'     => esc_html__('Flex Direction', 'makbet'),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'row'            => [
                        'title' => esc_html__('Row', 'makbet'),
                        'icon'  => 'eicon-arrow-right',
                    ],
                    'column'         => [
                        'title' => esc_html__('Column', 'makbet'),
                        'icon'  => 'eicon-arrow-down',
                    ],
                    'row-reverse'    => [
                        'title' => esc_html__('Row Reverse', 'makbet'),
                        'icon'  => 'eicon-arrow-left',
                    ],
                    'column-reverse' => [
                        'title' => esc_html__('Column Reverse', 'makbet'),
                        'icon'  => 'eicon-arrow-up',
                    ],
                ],
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-inner' => 'flex-direction: {{VALUE}};',
                ],
                'condition' => [
                    'portfolio-style' => ['1'],
                ],
            ]
        );

        $this->add_responsive_control(
            'wrapper_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .portfolio-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    'portfolio-style!' => ['2'],
                ],
            ]
        );

        $this->add_control(
            'wrapper_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .portfolio-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bg_color',
            [
                'label'     => esc_html__('Background Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio-inner' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'portfolio-style!' => ['2'],
                ],
            ]
        );

        $this->end_controls_section();


        // Image.
        $this->start_controls_section(
            'section_style_image',
            [
                'label' => esc_html__('Image', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'image_height',
            [
                'label'      => esc_html__('Height', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .portfolio-post-thumbnail' => 'padding-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_width',
            [
                'label'      => esc_html__('Width', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .portfolio-post-thumbnail' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition'  => [
                    'portfolio-style' => ['1'],
                ],
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .portfolio-post-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    'portfolio-style!' => ['2'],
                ],
            ]
        );

        $this->end_controls_section();

        //Content

        $this->start_controls_section(
            'section_style_content',
            [
                'label' => esc_html__('Content', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .portfolio-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Title.
        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_text_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .entry-title a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .entry-title'   => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_text_color_hover',
            [
                'label'     => esc_html__('Hover Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .entry-title a:hover' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .entry-title:hover'   => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .entry-title',
            ]
        );

        $this->add_responsive_control(
            'title_space',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .entry-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Category.
        $this->start_controls_section(
            'section_style_category',
            [
                'label' => esc_html__('Category', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'category_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio-categories a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'category_color_hover',
            [
                'label'     => esc_html__('Hover Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .portfolio-categories a:hover' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'category_typography',
                'selector' => '{{WRAPPER}} .portfolio-categories a',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'category_border',
                'selector' => '{{WRAPPER}} .portfolio-categories a',
            ]
        );

        $this->add_responsive_control(
            'category_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .portfolio-categories a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'category_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .portfolio-categories a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->get_controls_column();
    }

    protected function render() {
        $settings        = $this->get_controls_settings();
        $portfolio_style = $settings['portfolio_style'] ?: '1';

        $this->add_render_attribute('wrapper', 'class', [
            'archive-portfolio-wrapper',
            'pavo_portfolio-wrapper',
            'portfolio-style-' . $portfolio_style,
        ]);

        ?>
        <div <?php $this->print_render_attribute_string('wrapper') ?> >
            <div class="elementor-grid">
                <?php


                if (\Elementor\Plugin::instance()->editor->is_edit_mode()) {
                    $params = array(
                        'posts_per_page' => -1,
                        'post_type'      => 'pavo_portfolio',
                    );

                    $query = new WP_Query($params);

                    while ($query->have_posts()): $query->the_post();
                        include get_theme_file_path('template-parts/portfolio/content-style-' . $portfolio_style . '.php');
                    endwhile;

                } else {
                    if (have_posts()) {
                        while (have_posts()) {
                            the_post();
                            include get_theme_file_path('template-parts/portfolio/content-style-' . $portfolio_style . '.php');
                        }
                        wp_reset_postdata();
                    } else {
                        echo '<p>' . esc_html__('There are no posts', 'makbet') . '</p>';
                        return;
                    }
                }
                ?>
            </div>
        </div>

        <?php
        /**
         * Functions hooked in to makbet_loop_after action
         *
         * @see makbet_paging_nav - 10
         */
        do_action('makbet_loop_after');

    }
}

$widgets_manager->register(new Makbet_Elementor_Archive_Portfolio());
