<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Makbet\Elementor\Makbet_Base_Widgets;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

/**
 * Elementor Archive Service widget.
 *
 *
 * @since 1.0.0
 */
class Makbet_Elementor_Archive_Service extends Makbet_Base_Widgets {

    public function get_categories() {
        return array('makbet-addons');
    }

    public function get_name() {
        return 'makbet-archive-service';
    }

    public function get_title() {
        return esc_html__('Makbet Archive Service', 'makbet');
    }

    public function get_icon() {
        return 'eicon-archive';
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('Settings', 'makbet'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'service_style',
            [
                'label'   => esc_html__('Style', 'makbet'),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__('Style 1', 'makbet'),
                    '2' => esc_html__('Style 2', 'makbet'),
                ],
                'default' => '1'
            ]
        );

        $this->end_controls_section();

        // STYLE

        // Wrapper
        $this->start_controls_section(
            'section_style_item',
            [
                'label' => esc_html__('Item', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'background_color',
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .our-service',
            ]
        );

        $this->add_responsive_control(
            'service_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .our-service' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'service_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .our-service' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'service_spacing',
            [
                'label'      => esc_html__('Spacing', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .our-service' => 'gap: {{SIZE}}{{UNIT}}',
                ],
                'condition'  => [
                    'service_style' => ['1'],
                ],
            ]
        );

        $this->end_controls_section();

        // Title
        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .service-content .entry-title, 
                                {{WRAPPER}} .service-style-2 .elementor-button .elementor-button-text',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-content .entry-title'                             => 'color: {{VALUE}};',
                    '{{WRAPPER}} .service-style-2 .elementor-button .elementor-button-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label'     => esc_html__('Color Hover', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-content .entry-title a:hover'                           => 'color: {{VALUE}};',
                    '{{WRAPPER}} .service-style-2 .elementor-button .elementor-button-text:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'style_title_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .service-content .entry-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    'service_style!' => ['2'],
                ],
            ]
        );

        $this->end_controls_section();

        // Description
        $this->start_controls_section(
            'section_style_description',
            [
                'label'     => esc_html__('Description', 'makbet'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'service_style!' => ['2'],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'description_typography',
                'selector' => '{{WRAPPER}} .service-content .excerpt-content',
            ]
        );

        $this->add_responsive_control(
            'style_description_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .service-content .excerpt-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Icon

        $this->start_controls_section(
            'style_icon',
            [
                'label'     => esc_html__('Icon', 'makbet'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'service_style' => '1',
                ],
            ]
        );

        $this->add_responsive_control(
            'style_icon_size',
            [
                'label'      => esc_html__('Size', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .our-service.service-style-1' => '--size-icon: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .service-style-4'             => '--size-icon: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'style_icon_size_bg',
            [
                'label'      => esc_html__('Size Background', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .our-service.service-style-1' => '--size-bg-icon: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .service-style-4'             => '--size-bg-icon: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->start_controls_tabs(
            'style_tabs_service_color'
        );

        $this->start_controls_tab(
            'style_normal_tab_service_color',
            [
                'label'     => esc_html__('Normal', 'makbet'),
                'condition' => [
                    'service_style' => '1',
                ],
            ]
        );

        $this->add_control(
            'bg_color',
            [
                'label'     => esc_html__('Background Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .our-service .entry-icon' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .timeline-dot'            => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'           => 'icon_color',
                'types'          => ['gradient'],
                'selector'       => '{{WRAPPER}} .icon-mask',
                'fields_options' => [
                    'background' => [
                        'label'              => __('Icon Gradient', 'makbet'),
                        'frontend_available' => true,
                    ],
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab_service_color',
            [
                'label'     => esc_html__('Hover', 'makbet'),
                'condition' => [
                    'service_style' => '1',
                ],
            ]
        );

        $this->add_control(
            'bg_color_hover',
            [
                'label'     => esc_html__('Background Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .our-service:hover .entry-icon' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'service_style' => '1',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'           => 'icon_color_hover',
                'types'          => ['gradient'],
                'selector'       => '{{WRAPPER}} .our-service:hover .icon-mask',
                'fields_options' => [
                    'background' => [
                        'label'              => __('Icon Gradient Hover', 'makbet'),
                        'frontend_available' => true,
                    ],
                ],
                'condition'      => [
                    'service_style' => '1',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->get_controls_column();
    }

    protected function render() {
        $settings = $this->get_controls_settings();

        $this->add_render_attribute('wrapper', 'class', ['archive-service-wrapper',]);

        ?>
        <div <?php $this->print_render_attribute_string('wrapper') ?> >
            <div class="elementor-grid">
                <?php

                $service_style = $settings['service_style'] ?: '1';

                if (\Elementor\Plugin::instance()->editor->is_edit_mode()) {
                    $params = array(
                        'posts_per_page' => -1,
                        'post_type'      => 'pavo_service',
                    );

                    $query = new WP_Query($params);

                    while ($query->have_posts()): $query->the_post();
                        get_template_part('template-parts/service/content-style-' . $service_style);
                    endwhile;
                    wp_reset_postdata();

                } else {
                    if (have_posts()) {
                        while (have_posts()) {
                            the_post();
                            get_template_part('template-parts/service/content-style-' . $service_style);
                        }
                        wp_reset_postdata();
                    } else {
                        echo '<p>' . esc_html__('There are no posts', 'makbet') . '</p>';
                        return;
                    }
                }
                ?>
            </div>
        </div>

        <?php
        /**
         * Functions hooked in to makbet_loop_after action
         *
         * @see makbet_paging_nav - 10
         */
        do_action('makbet_loop_after');

    }
}

$widgets_manager->register(new Makbet_Elementor_Archive_Service());
