<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Makbet\Elementor\Makbet_Base_Widgets;

class Makbet_Elementor_Price_Table extends Makbet_Base_Widgets
{

    public function get_name()
    {
        return 'makbet-price-table';
    }

    public function get_title()
    {
        return esc_html__('Makbet Price Table', 'makbet');
    }

    public function get_categories()
    {
        return array('makbet-addons');
    }

    public function get_icon()
    {
        return 'eicon-price-table';
    }

    public function get_script_depends()
    {
        return ['makbet-elementor-price-table'];
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_pricing',
            [
                'label' => esc_html__('Pricing', 'makbet'),
            ]
        );

// Enable/Disable Monthly/Yearly Toggle
        $this->add_control(
            'enable_toogle',
            [
                'label' => esc_html__('Enable Toggle', 'makbet'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'makbet'),
                'label_off' => esc_html__('Off', 'makbet'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

// Discount Text
        $this->add_control(
            'show_sale_off',
            [
                'label' => esc_html__('Discount Text', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Save 25%', 'makbet'),
                'condition' => [
                    'enable_toogle' => 'yes',
                ],
            ]
        );

// Monthly Text
        $this->add_control(
            'text_monthly',
            [
                'label' => esc_html__('Monthly', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Monthly', 'makbet'),
                'condition' => [
                    'enable_toogle' => 'yes',
                ],
            ]
        );

// Yearly Text
        $this->add_control(
            'text_annually',
            [
                'label' => esc_html__('Yearly', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Yearly', 'makbet'),
                'condition' => [
                    'enable_toogle' => 'yes',
                ],
            ]
        );

// Toggle Alignment
        $this->add_responsive_control(
            'tabs_justify',
            [
                'label' => esc_html__('Alignment', 'makbet'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Left', 'makbet'),
                        'icon' => 'eicon-align-start-h',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'makbet'),
                        'icon' => 'eicon-align-center-h',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Right', 'makbet'),
                        'icon' => 'eicon-align-end-h',
                    ],
                ],
                'condition' => [
                    'enable_toogle' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-toggle' => 'justify-content:{{VALUE}}',
                ],
            ]
        );

// Repeater for Monthly Features
        $monthly_item_repeater = new \Elementor\Repeater();
        $monthly_item_repeater->add_control(
            'price_icon_color',
            [
                'label' => esc_html__('Icon Color', 'makbet'),
                'type' => \Elementor\Controls_Manager::COLOR,
            ]
        );
        $monthly_item_repeater->add_control(
            'price_list_title',
            [
                'label' => esc_html__('Title', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Web & Mobile Optimization', 'makbet'),
            ]
        );
        $monthly_item_repeater->add_control(
            'price_list_icon',
            [
                'label' => esc_html__('Icon', 'makbet'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-check',
                    'library' => 'fa-solid',
                ],
            ]
        );

// Repeater for Yearly Features
        $yearly_item_repeater = new \Elementor\Repeater();
        $yearly_item_repeater->add_control(
            'price_icon_color',
            [
                'label' => esc_html__('Icon Color', 'makbet'),
                'type' => \Elementor\Controls_Manager::COLOR,
            ]
        );
        $yearly_item_repeater->add_control(
            'price_list_title',
            [
                'label' => esc_html__('Title', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Advanced Web & Mobile Optimization', 'makbet'),
            ]
        );
        $yearly_item_repeater->add_control(
            'price_list_icon',
            [
                'label' => esc_html__('Icon', 'makbet'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
            ]
        );

// Main Repeater for Pricing Items
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'show_best_values',
            [
                'label' => esc_html__('Show Popular', 'makbet'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'makbet'),
                'label_off' => esc_html__('Hide', 'makbet'),
                'return_value' => 'yes',
                'default' => 'no',
                'prefix_class' => 'show-best-values-',
                'separator' => 'before',
                'render_type' => 'template',

            ]
        );
        $repeater->add_control(
            'price_best_value',
            [
                'label' => esc_html__('Popular', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Popular', 'makbet'),
                'condition' => [
                    'show_best_values' => 'yes',
                ],
            ]
        );
        $repeater->add_control(
            'pricing_title',
            [
                'label' => esc_html__('Title', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Pricing Plan', 'makbet'),
            ]
        );
        $repeater->add_control(
            'pricing_des',
            [
                'label' => esc_html__('Description', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Suitable for beginners or those seeking a fitness plan', 'makbet'),
                'label_block' => true,
                'rows' => 3,
            ]
        );
        $repeater->add_control(
            'pricing_symbol',
            [
                'label' => esc_html__('Symbol', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('$', 'makbet'),
                'placeholder' => esc_html__('Symbol...', 'makbet'),
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'pricing_currency',
            [
                'label' => esc_html__('Monthly Price', 'makbet'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 39.99,
            ]
        );
        $repeater->add_control(
            'pricing_period',
            [
                'label' => esc_html__('Monthly Period', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('/month', 'makbet'),
                'placeholder' => esc_html__('Period...', 'makbet'),
            ]
        );
        $repeater->add_control(
            'pricing_annual',
            [
                'label' => esc_html__('Yearly Price', 'makbet'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 29.99,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'pricing_period_annual',
            [
                'label' => esc_html__('Yearly Period', 'makbet'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('/year', 'makbet'),
                'placeholder' => esc_html__('Period...', 'makbet'),
            ]
        );

// Add Repeater for Monthly Features
        $repeater->add_control(
            'monthly_features',
            [
                'label' => esc_html__('Monthly Features', 'makbet'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $monthly_item_repeater->get_controls(),
                'title_field' => '{{{ price_list_title }}}',
                'item_actions' => [
                    'add' => false,
                ],
                'default' => [
                    [
                        'price_list_title' => esc_html__('Web & Mobile Optimization', 'makbet'),
                        'price_list_icon' => [
                            'value' => 'fas fa-check',
                            'library' => 'fa-solid',
                        ],
                    ],
                ],
            ]
        );

// Add Repeater for Yearly Features
        $repeater->add_control(
            'yearly_features',
            [
                'label' => esc_html__('Yearly Features', 'makbet'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $yearly_item_repeater->get_controls(),
                'title_field' => '{{{ price_list_title }}}',
                'item_actions' => [
                    'add' => false,
                ],
                'default' => [
                    [
                        'price_list_title' => esc_html__('Advanced Web & Mobile Optimization', 'makbet'),
                        'price_list_icon' => [
                            'value' => 'fas fa-star',
                            'library' => 'fa-solid',
                        ],
                    ],
                    [
                        'price_list_title' => esc_html__('Priority Support', 'makbet'),
                        'price_list_icon' => [
                            'value' => 'fas fa-headset',
                            'library' => 'fa-solid',
                        ],
                    ],
                ],
            ]
        );
        $repeater->add_control(
            'pricing_button_text',
            [
                'label' => esc_html__('Button Text', 'makbet'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('get started', 'makbet'),
            ]
        );

        $repeater->add_control(
            'link_month',
            [
                'label' => esc_html__('Monthly Link', 'makbet'),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-month-link.com', 'makbet'),
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_external' => true,
            ]
        );

        $repeater->add_control(
            'link_year',
            [
                'label' => esc_html__('Yearly Link', 'makbet'),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-year-link.com', 'makbet'),
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_external' => true,
            ]
        );

        $this->add_control(
            'pricings',
            [
                'label'       => esc_html__('Pricing Item', 'makbet'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ pricing_title }}}',
                'separator' => 'before',
                'prevent_empty' => false
            ]
        );

        $this->end_controls_section();


        // WRAPPER STYLE
        $this->start_controls_section(
            'section_style_price_wrapper',
            [
                'label' => esc_html__('Wrapper', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,

            ]
        );
        $this->add_control(
            'price_effects',
            [
                'label' => esc_html__('Price Flex', 'makbet'),
                'type'  => Controls_Manager::SWITCHER,

                'prefix_class' => 'price-effects-'
            ]
        );
        $this->add_responsive_control(
            'testimonial_width_img',
            [
                'label'      => esc_html__('Width', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', '%', 'vw'],
                'selectors'  => [
                    '{{WRAPPER}}.price-effects-yes .price_table_inner .price_left'           => 'width: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'price_effects' => 'yes'
                ],
            ]
        );
        $this->add_responsive_control(
            'padding_price_wrapper',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .price_table_inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'margin_price_wrapper',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .price_table_inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'color_price_wrapper',
            [
                'label'     => esc_html__('Background Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .price_table_inner' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'wrapper_border',
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .price_table_inner',
                'separator'   => 'before',
            ]
        );

        $this->add_control(
            'border_color_hover',
            [
                'label' => esc_html__('Border Color Hover', 'makbet'),
                'type' => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .price_table_inner:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'wrapper_radius',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-price-table-item, {{WRAPPER}} .price_table_inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'wrapper_box_shadow',
                'selector' => '{{WRAPPER}} .price_table_inner',
            ]
        );

        $this->end_controls_section();

        // header style
        $this->start_controls_section(
            'section_header_style',
            [
                'label' => esc_html__('Header', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'header_style_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Title', 'makbet' ),

            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .title',
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );



        $this->add_control(
            'header_des',
            [
                'label' => esc_html__('Description', 'makbet'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'des_typography',
                'selector' => '{{WRAPPER}} .price-des',
            ]
        );

        $this->add_control(
            'header_price',
            [
                'label' => esc_html__('Price', 'makbet'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'price_typography',
                'selector' => '{{WRAPPER}} .price_table_header .elementor-price-table__currency',
            ]
        );

        $this->add_control(
            'header_symbol',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Symbol', 'makbet'),
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'symbol_typography',
                'selector' => '{{WRAPPER}} .price_table_header .elementor-price-table__integer-part',
            ]
        );


        $this->add_control(
            'header_period',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Period', 'makbet'),
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'period_typography',
                'selector' => '{{WRAPPER}} .price_table_header .elementor-price-table__period',
            ]
        );

        $this->add_responsive_control(
            'header_padding',
            [
                'label'      => esc_html__('Header Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .price_table_header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'heading_content_colors',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Colors', 'makbet' ),
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs( 'price_color_tabs' );

        $this->start_controls_tab( 'price_colors_normal',
            [
                'label' => esc_html__( 'Normal', 'makbet' ),
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'price_des_color',
            [
                'label' => esc_html__( 'Description Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-des' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'price_color',
            [
                'label' => esc_html__( 'Price Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-price-table__currency' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-price-table__integer-part' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'period_color',
            [
                'label' => esc_html__( 'Period Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-price-table__period' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'price_colors_hover',
            [
                'label' => esc_html__( 'Hover', 'makbet' ),
            ]
        );


        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__( 'Title Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_table_inner:hover .title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'des_color_hover',
            [
                'label' => esc_html__( 'Description Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_table_inner:hover .price-des' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'price_color_hover',
            [
                'label' => esc_html__( 'Price Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_table_inner:hover .elementor-price-table__currency' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .price_table_inner:hover .elementor-price-table__integer-part' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'period_color_hover',
            [
                'label' => esc_html__( 'Period Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price_table_inner:hover .elementor-price-table__period' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();


        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__( 'Content', 'makbet' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'features_text_typography',
                'selector' => '{{WRAPPER}} .pricing_features li',
            ]
        );

        $this->add_control(
            'features_text_color',
            [
                'label' => esc_html__( ' Text Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing_features ul li' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'features_icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing_features  ul li i' => 'color: {{VALUE}}!important;',
                    '{{WRAPPER}} .pricing_features  ul li svg' => 'color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label'      => esc_html__('Padding Content', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .pricing_features' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_margin',
            [
                'label'      => esc_html__('Margin Content', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .pricing_features' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_footer_style',
            [
                'label' => esc_html__( 'Button', 'makbet' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'testimonial_width_button',
            [
                'label'      => esc_html__('Width', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', '%', 'vw'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-button-bgEffect .elementor-button-wrapper '           => 'width: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .elementor-button-bgEffect .elementor-button'           => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->start_controls_tabs( 'button_color_tabs' );

        $this->start_controls_tab( 'button_colors_normal',
            [
                'label' => esc_html__( 'Normal', 'makbet' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => esc_html__( 'Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .button-more-link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_colors_hover',
            [
                'label' => esc_html__( 'Hover', 'makbet' ),
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label' => esc_html__( 'Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .button-more-link:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bgcolor_hover',
            [
                'label' => esc_html__('Background Color', 'makbet'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .button-more-link:hover' => 'background-color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'button_padding',
            [
                'label'      => esc_html__('Button Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .button-more-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'toggle_style',
            [
                'label' => esc_html__( 'Pricing Toggle', 'makbet' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'  => [
                    'enable_toogle' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'toggle_typography',
                'selector' => '{{WRAPPER}} .pricing-toggle .toggle-text',

                'condition'  => [
                    'enable_toogle' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'toggle_text_color',
            [
                'label' => esc_html__( ' Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,

                'condition'  => [
                    'enable_toogle' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-price-table-toggle .pricing-toggle.active .toggle-text:first-child' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-price-table-toggle .pricing-toggle:not(.active) .toggle-text:nth-child(3)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'toggle_text_color_active',
            [
                'label' => esc_html__( ' Active Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,

                'condition'  => [
                    'enable_toogle' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-toggle:not(.active) .toggle-text:first-child' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .pricing-toggle.active .toggle-text:nth-child(3)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'toggle_spacing',
            [
                'label' => esc_html__( 'Gap Between Toggle', 'makbet' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-toggle-inner' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition'  => [
                    'enable_toogle' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'toggle_bgcolor',
            [
                'label' => esc_html__( 'Toggle Background Color', 'makbet' ),
                'type' => Controls_Manager::COLOR,

                'condition'  => [
                    'enable_toogle' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-price-table-toggle .button-toggle small:before' => 'Background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'toggle_border',
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .button-toggle',
                'separator'   => 'before',
            ]
        );

        $this->add_control(
            'toggle_radius',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-price-table-toggle .button-toggle small ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'toggle_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'condition'  => [
                    'enable_toogle' => 'yes',
                ],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-price-table-toggle .pricing-toggle-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'toggle_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'condition'  => [
                    'enable_toogle' => 'yes',
                ],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-price-table-toggle .pricing-toggle-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        $this->get_controls_column();
        // Carousel options
        $this->get_control_carousel();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (!empty($settings['pricings']) && is_array($settings['pricings'])) {
            $this->add_render_attribute('wrapper', 'class', 'elementor-price-table-item-wrapper');
            $this->get_data_elementor_columns();
            $this->add_render_attribute('inner', 'class', 'elementor-price-table-content');
            $this->add_render_attribute('item', 'class', 'grid-item elementor-price-table-item');
        }

        $unique_id = $this->get_id();
        ?>
        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <?php if (!empty($settings['enable_toogle']) && $settings['enable_toogle'] == 'yes') : ?>
                <div class="elementor-price-table-toggle">
                    <div class="pricing-toggle">
                        <div class="pricing-toggle-inner">
                            <span class="toggle-text"><?php echo esc_html($settings['text_monthly'] ?? 'Monthly'); ?></span>
                            <label class="button-toggle">
                                <input class="toggle-checkbox" type="checkbox" id="checkbox-<?php echo esc_attr($unique_id); ?>">
                                <small></small>
                            </label>
                            <span class="toggle-text"><?php echo esc_html($settings['text_annually'] ?? 'Yearly'); ?></span>
                            <?php if (!empty($settings['show_sale_off'])) : ?>
                                <span class="price-sale"><?php echo esc_html($settings["show_sale_off"]); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div <?php $this->print_render_attribute_string('container'); ?>>
                <div <?php $this->print_render_attribute_string('inner'); ?>>
                    <?php foreach ($settings['pricings'] as $pricings) : ?>
                        <?php
                        $link_month = $pricings['link_month']['url'] ?? '';
                        $link_year = $pricings['link_year']['url'] ?? '';
                        $text_month = $pricings['pricing_button_text'] ?? 'get started';
                        $text_year = $pricings['pricing_button_text'] ?? $text_month;

                        $default_link = !empty($link_month) ? $link_month : $link_year;
                        $default_text = !empty($link_month) ? $text_month : $text_year;
                        ?>
                        <div <?php $this->print_render_attribute_string('item'); ?>>
                            <div class="price_table_inner">
                                <div class="price-left">
                                    <div class="title-best-value">
                                        <?php if (!empty($pricings['pricing_title'])) : ?>
                                            <div class="title"><?php echo esc_html($pricings["pricing_title"]); ?></div>
                                        <?php endif; ?>
                                        <?php if (!empty($pricings['price_best_value'])) : ?>
                                            <div class="price-best-value"><?php echo esc_html($pricings["price_best_value"]); ?></div>
                                        <?php endif; ?>
                                    </div>
                                    <?php if (!empty($pricings['pricing_des'])) : ?>
                                        <div class="price-des"><?php echo esc_html($pricings["pricing_des"]); ?></div>
                                    <?php endif; ?>
                                    <div class="price_table_header">
                                        <div class="elementor-price-table__price-price">
                                            <div class="elementor-price-table__price-monthly">
                                                <div class="elementor-price-table__price">
                                                    <span class="elementor-price-table__integer-part"><?php echo esc_html($pricings['pricing_symbol'] ?? ''); ?></span>
                                                    <span class="elementor-price-table__currency"><?php echo esc_html($pricings['pricing_currency'] ?? ''); ?></span>
                                                    <span class="elementor-price-table__period"><?php echo esc_html($pricings['pricing_period'] ?? ''); ?></span>
                                                </div>
                                            </div>
                                            <?php if (!empty($settings['enable_toogle']) && $settings['enable_toogle'] == 'yes') : ?>
                                                <div class="elementor-price-table__price-annual" >
                                                    <div class="elementor-price-table__price">
                                                        <span class="elementor-price-table__integer-part"><?php echo esc_html($pricings['pricing_symbol'] ?? ''); ?></span>
                                                        <span class="elementor-price-table__currency"><?php echo esc_html($pricings['pricing_annual'] ?? ''); ?></span>
                                                        <span class="elementor-price-table__period"><?php echo esc_html($pricings['pricing_period_annual'] ?? ''); ?></span>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="elementor-price-table__button enable-effects-yes elementor-button-bgEffect">
                                        <?php if (!empty($link_month) || !empty($link_year)) : ?>
                                            <div class="elementor-button-wrapper">
                                                <a href="<?php echo esc_url($default_link); ?>"
                                                   class="pricing-button-shared button-more-link btn-slip-effect elementor-button elementor-button-link elementor-size-xs has-interacted"
                                                   data-href-month="<?php echo esc_url($link_month); ?>"
                                                   data-href-year="<?php echo esc_url($link_year); ?>"
                                                   data-label-month="<?php echo esc_attr($text_month); ?>"
                                                   data-label-year="<?php echo esc_attr($text_year); ?>">
                                                <span class="elementor-button-content-wrapper">
                                                    <span class="pricing-button-icon elementor-button-icon">
                                                        <i aria-hidden="true" class="makbet-icon-arrow-right-btn"></i>
                                                    </span>
                                                    <span class="pricing-button-text makbet_btn_text elementor-button-text">
                                                        <?php echo esc_html($default_text); ?>
                                                    </span>
                                                </span>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="pricing_features">
                                    <div class="features-monthly">
                                        <?php if (!empty($pricings['monthly_features']) && is_array($pricings['monthly_features'])) : ?>
                                                <?php foreach ($pricings['monthly_features'] as $item) :
                                                    $icon = $item['price_list_icon'];
                                                    $icon_color = !empty($item['price_icon_color']) ? $item['price_icon_color'] : '';
                                                    $color_css = $icon_color ? 'color: ' . esc_attr($icon_color) . ';' : '';
                                                    ?>
                                                    <ul class="features-item">
                                                        <li>
                                                            <?php
                                                            if ( is_array($icon) && !empty($icon['library']) ) {
                                                                if ( $icon['library'] === 'svg' ) {
                                                                    $svg_url = '';
                                                                    if ( !empty( $icon['value']['url'] ) ) {
                                                                        $svg_url = $icon['value']['url'];
                                                                    } elseif ( is_string( $icon['value'] ) && filter_var( $icon['value'], FILTER_VALIDATE_URL ) ) {
                                                                        $svg_url = $icon['value'];
                                                                    }

                                                                    if ( $svg_url ) {
                                                                        ?>
                                                                        <span class="icon-mask price-icon" style="--icon-url: url(<?php echo esc_url( $svg_url ); ?>); <?php echo esc_attr($color_css); ?>"></span>';
                                                                    <?php }
                                                                } else {
                                                                    \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true', 'class' => 'price-icon', 'style' => esc_attr($color_css)]);
                                                                }
                                                            }
                                                            ?>

                                                            <div class="price-list-title"><?php echo esc_html($item['price_list_title'] ?? ''); ?></div>
                                                        </li>
                                                    </ul>
                                                <?php endforeach; ?>

                                        <?php endif; ?>
                                    </div>
                                    <?php if (!empty($settings['enable_toogle']) && $settings['enable_toogle'] == 'yes') : ?>
                                        <div class="features-annual" style="display:none;">
                                            <?php if (!empty($pricings['yearly_features']) && is_array($pricings['yearly_features'])) : ?>
                                                <?php foreach ($pricings['yearly_features'] as $item) :
                                                    $icon = $item['price_list_icon'];
                                                    $icon_color = !empty($item['price_icon_color']) ? $item['price_icon_color'] : '';
                                                    $color_css = $icon_color ? 'color: ' . esc_attr($icon_color) . ';' : '';
                                                    ?>
                                                    <ul class="features-item">
                                                        <li>
                                                            <?php
                                                            if ( is_array($icon) && !empty($icon['library']) ) {
                                                                if ( $icon['library'] === 'svg' ) {
                                                                    $svg_url = '';
                                                                    if ( !empty( $icon['value']['url'] ) ) {
                                                                        $svg_url = $icon['value']['url'];
                                                                    } elseif ( is_string( $icon['value'] ) && filter_var( $icon['value'], FILTER_VALIDATE_URL ) ) {
                                                                        $svg_url = $icon['value'];
                                                                    }

                                                                    if ( $svg_url ) {
                                                                        ?>
                                                                        <span class="icon-mask price-icon" style="--icon-url: url(<?php echo esc_url( $svg_url ); ?>); <?php echo esc_attr($color_css); ?>"></span>';
                                                                    <?php }
                                                                } else {
                                                                    \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true', 'class' => 'price-icon', 'style' => esc_attr($color_css) ] );
                                                                }
                                                            }
                                                            ?>
                                                            <div class="price-list-title"><?php echo esc_html($item['price_list_title'] ?? ''); ?></div>
                                                        </li>
                                                    </ul>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php $this->get_swiper_navigation(count($settings['pricings'])); ?>
            </div>
        </div>
        <?php
    }

}

$widgets_manager->register(new Makbet_Elementor_Price_Table());
