<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Makbet\Elementor\Makbet_Base_Widgets;

class Makbet_Elementor_Progress_Bar extends Makbet_Base_Widgets {
    public function get_name() {
        return 'makbet-progress-bar';
    }
    public function get_script_depends() {
        return ['makbet-elementor-progress-bar'];
    }

    public function get_title() {
        return __('Makbet Progress Bar', 'makbet');
    }

    protected function register_controls() {
        $this->start_controls_section('section_progress_bar', [
            'label' => __('Progress Bar', 'makbet'),
        ]);

        $this->add_control('title', [
            'label' => __('Title', 'makbet'),
            'type' => Controls_Manager::TEXT,
            'dynamic' => [ 'active' => true ],
            'placeholder' => __('Enter your title', 'makbet'),
            'default' => __('My Skill', 'makbet'),
            'label_block' => true,
        ]);

        $this->add_control(
            'progress_content',
            [
                'label'       => esc_html__('Content', 'makbet'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => 'Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
                'label_block' => true,
                'rows'        => '6',
            ]
        );
        $this->add_control('percent', [
            'label' => __('Percentage', 'makbet'),
            'type' => Controls_Manager::SLIDER,
            'default' => [ 'size' => 50, 'unit' => '%' ],
            'label_block' => true,
        ]);

        $this->add_control('display_percentage', [
            'label' => __('Display Percentage', 'makbet'),
            'type' => Controls_Manager::SELECT,
            'default' => 'show',
            'options' => [ 'show' => __('Show', 'makbet'), 'hide' => __('Hide', 'makbet') ],
        ]);

        $this->add_control('progress_type', [
            'label' => __('Type', 'makbet'),
            'type' => Controls_Manager::SELECT,
            'default' => 'line',
            'options' => [
                'line' => __('Line', 'makbet'),
                'circle' => __('Circle', 'makbet'),
            ],
        ]);

        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_progress_bar',
            [
                'label' => esc_html__('Wrapper', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'progress_bar_effects',
            [
                'label' => esc_html__('Caption Flex', 'makbet'),
                'type'  => Controls_Manager::SWITCHER,

                'prefix_class' => 'progress-effects-'
            ]
        );
        $this->add_responsive_control(
            'progress_bar_gap',
            [
                'label'      => esc_html__('Gap', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}}.progress-effects-yes .elementor-widget-container' => 'Gap: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'progress_bar_effects' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'background_color_progress_bar',
            [
                'label'     => esc_html__('Background Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-widget-container' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'backdrop_blur_progress_bar',
            [
                'label' => esc_html__('Backdrop Blur', 'makbet'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-widget-container' => 'backdrop-filter: blur({{SIZE}}px); -webkit-backdrop-filter: blur({{SIZE}}px);',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'progress_bar_border',
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .elementor-widget-container',
                'separator'   => 'before',
            ]
        );
        $this->add_control(
            'border_radius_progress_bar',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-widget-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding_progress_bar',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-widget-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_progress_bar_title',
            [
                'label' => esc_html__('Caption', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'progress_bar_title_alignment',
            [
                'label'       => esc_html__('Alignment Title', 'makbet'),
                'type'        => Controls_Manager::CHOOSE,
                'options'     => [
                    'left'   => [
                        'title' => esc_html__('Left', 'makbet'),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'makbet'),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__('Right', 'makbet'),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'label_block' => false,
                'selectors'   => [
                    '{{WRAPPER}} .progress-bar-caption' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'progress_bar_title',
            [
                'label'     => esc_html__('Title', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'progress_bar_title_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .progress-bar-caption .makbet-progress-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'progress_bar_title_typography',
                'selector' => '{{WRAPPER}} .progress-bar-caption .makbet-progress-title',
            ]
        );
        $this->add_responsive_control(
            'progress_bar_title_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .progress-bar-caption .makbet-progress-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'progress_bar_content',
            [
                'label'     => esc_html__('Content', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'progress_bar_content_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .progress-bar-caption .makbet-progress-content' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'progress_bar_content_typography',
                'selector' => '{{WRAPPER}} .progress-bar-caption .makbet-progress-content',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_progress_bar_line',
            [
                'label' => esc_html__('Line', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition'    => [
                    'progress_type' => 'line',
                ],
            ]
        );
        $this->add_control(
            'progress_bar_line_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .makbet-progress-line-container .makbet-progress-line-wrapper .makbet-progress-line-bar' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius_progress_bar_line',
            [
                'label'      => esc_html__('Border Radius Line', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .makbet-progress-line-container .makbet-progress-line-wrapper .makbet-progress-line-bar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'progress_bar_line_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .makbet-progress-line-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'progress_bar_heading_percentage',
            [
                'label'     => esc_html__('Percentage', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'progress_bar_percentage_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .makbet-progress-line-container .makbet-progress-percentage' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'progress_bar_percentage_typography',
                'selector' => '{{WRAPPER}} .makbet-progress-line-container .makbet-progress-percentage',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_progress_bar_circle',
            [
                'label' => esc_html__('Circle', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition'    => [
                    'progress_type' => 'circle',
                ],
            ]
        );
        $this->add_responsive_control(
            'progress_bar_circle_width',
            [
                'label'      => esc_html__('Width', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', '%', 'vw'],
                'selectors'  => [
                    '{{WRAPPER}} .makbet-progress-circle-wrapper'           => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'progress_bar_circle_height',
            [
                'label'      => esc_html__('Height', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'vh', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .makbet-progress-circle-wrapper' => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_control(
            'progress_bar_circle_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .makbet-progress-circle-wrapper .makbet-progress-circle-svg circle.makbet-progress-fg' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'progress_bar_circle_percentage',
            [
                'label'     => esc_html__('Percentage', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'progress_bar_circle_percentage_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .makbet-progress-circle-wrapper .makbet-progress-percentage-center' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'progress_circle_percentage_typography',
                'selector' => '{{WRAPPER}} .makbet-progress-circle-wrapper .makbet-progress-percentage-center',
            ]
        );
        $this->end_controls_section();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        $percent = isset($settings['percent']['size']) ? $settings['percent']['size'] : 0;

        ob_start();

        if ($settings['progress_type'] === 'circle') :
            $radius = 54;
            $circumference = 2 * pi() * $radius;
            ?>
            <div class="makbet-progress-circle-wrapper"
                 data-max="<?php echo esc_attr($percent); ?>"
                 role="progressbar"
                 aria-valuemin="0"
                 aria-valuemax="100"
                 aria-valuenow="<?php echo esc_attr($percent); ?>">
                <svg viewBox="0 0 120 120" class="makbet-progress-circle-svg">
                    <circle class="makbet-progress-bg" cx="60" cy="60" r="<?php echo esc_attr($radius); ?>" fill="none" stroke-width="10" />
                    <circle class="makbet-progress-fg" cx="60" cy="60" r="<?php echo esc_attr($radius); ?>" fill="none" stroke-width="10"
                            stroke-dasharray="<?php echo esc_attr($circumference); ?>" stroke-dashoffset="<?php echo esc_attr($circumference); ?>" />
                </svg>

                <?php if ('hide' !== $settings['display_percentage']) : ?>
                    <div class="makbet-progress-percentage-center">
                        <span class="makbet-progress-percentage" data-target="<?php echo esc_attr($percent); ?>">0%</span>
                    </div>
                <?php endif; ?>
            </div>

        <?php else : ?>
            <div class="makbet-progress-line-container">
                <div class="makbet-progress-line-wrapper"
                     role="progressbar"
                     aria-valuemin="0"
                     aria-valuemax="100"
                     aria-valuenow="<?php echo esc_attr($percent); ?>">
                    <div class="makbet-progress-line-bar" data-max="<?php echo esc_attr($percent); ?>"></div>
                </div>

                <?php if ('hide' !== $settings['display_percentage']) : ?>
                    <span class="makbet-progress-percentage" data-target="<?php echo esc_attr($percent); ?>" style="left: 0%;">0%</span>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="progress-bar-caption">
            <?php if (!empty($settings['title'])) : ?>
                <span class="makbet-progress-title"><?php echo esc_html($settings['title']); ?></span>
            <?php endif; ?>

            <?php if (!empty($settings['progress_content'])) : ?>
                <span class="makbet-progress-content"><?php echo esc_html($settings['progress_content']); ?></span>
            <?php endif; ?>
        </div>

        <?php
        echo ob_get_clean();
    }



}

$widgets_manager->register(new Makbet_Elementor_Progress_Bar());