<?php

use Elementor\Controls_Manager;
use Makbet\Elementor\Makbet_Base_Widgets;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Makbet_Elementor_Service_Post extends Makbet\Elementor\Makbet_Base_Widgets {

    public function get_name() {
        return 'makbet-service-post';
    }

    public function get_title() {
        return esc_html__('Makbet Service Post', 'makbet');
    }

    public function get_icon() {
        return 'eicon-kit-details'; // TODO: Change the autogenerated stub
    }

    public function get_categories() {
        return array('makbet-addons');
    }

    protected function register_controls() {

        $this->start_controls_section('section_query', [
            'label' => esc_html__('Service Post', 'makbet'),
            'tab'   => Controls_Manager::TAB_CONTENT,
        ]);

        $this->add_control('more_services_title', [
            'label'       => esc_html__('Services Title', 'makbet'),
            'type'        => Controls_Manager::TEXT,
            'default'     => 'Services Category',
            'placeholder' => esc_html__('Add Title', 'makbet'),
        ]);

        $this->add_control('slider_service_type', [
            'label'   => esc_html__('Service Post Query', 'makbet'),
            'type'    => Controls_Manager::SELECT,
            'default' => 'random',
            'options' => [
                'random' => esc_html__('Random', 'makbet'),
                'name'   => esc_html__('Name', 'makbet')
            ],
        ]);

        $this->add_control('orderby', [
            'label'   => esc_html__('Order By', 'makbet'),
            'type'    => Controls_Manager::SELECT,
            'default' => 'post_date',
            'options' => [
                'post_date'  => esc_html__('Date', 'makbet'),
                'post_title' => esc_html__('Title', 'makbet'),
                'menu_order' => esc_html__('Menu Order', 'makbet'),
                'rand'       => esc_html__('Random', 'makbet'),
            ],
        ]);

        $this->add_control('order', [
            'label'   => esc_html__('Order', 'makbet'),
            'type'    => Controls_Manager::SELECT,
            'default' => 'asc',
            'options' => [
                'asc'  => esc_html__('ASC', 'makbet'),
                'desc' => esc_html__('DESC', 'makbet'),
            ],
        ]);

        $this->add_control('service_single_image', [
            'label'       => esc_html__('Show Service Post', 'makbet'),
            'type'        => Controls_Manager::SELECT2,
            'multiple'    => true,
            'options'     => $this->get_post_service(),
            'label_block' => true,
            'condition'   => [
                'slider_service_type' => 'name'
            ]
        ]);

        $this->add_control('posts_per_page', [
            'label'     => esc_html__('Posts Per Page', 'makbet'),
            'type'      => Controls_Manager::NUMBER,
            'default'   => 6,
            'condition' => [
                'slider_service_type' => 'random'
            ]
        ]);

        $this->end_controls_section();

        $this->start_controls_section('section_style_wrapper', [
            'label' => esc_html__('Wrapper', 'makbet'),
            'tab'   => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'background_color',
                'types'    => ['gradient'],
                'selector' => '{{WRAPPER}} .service_posts',
            ]
        );

        $this->add_responsive_control(
            'wrapper_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .service_posts' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control('service_border_radius', [
            'label'      => esc_html__('Border Radius', 'makbet'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .service_posts' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->end_controls_section();

        $this->start_controls_section('section_style_title', [
            'label' => esc_html__('Title', 'makbet'),
            'tab'   => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name'     => 'name_typography',
            'selector' => '{{WRAPPER}} .post-title',
        ]);

        $this->add_control('title_color', [
            'label'     => esc_html__('Color', 'makbet'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .post-title' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_responsive_control('style_content_padding', [
            'label'      => esc_html__('Padding', 'makbet'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .post-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->end_controls_section();

        $this->start_controls_section('section_style_item', [
            'label' => esc_html__('Items', 'makbet'),
            'tab'   => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('icon_heading', [
            'label'     => esc_html__('Icon', 'makbet'),
            'type'      => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);

        $this->add_responsive_control('icon_size', [
            'label'     => esc_html__('Size', 'makbet'),
            'type'      => Controls_Manager::SLIDER,
            'range'     => ['px' => ['min' => 1, 'max' => 100]],
            'selectors' => [
                '{{WRAPPER}} .service-content a i' => 'font-size: {{SIZE}}{{UNIT}}',
            ],
        ]);

        $this->add_responsive_control('icon_spacing', [
            'label'     => esc_html__('Background Icon Size', 'makbet'),
            'type'      => Controls_Manager::SLIDER,
            'range'     => ['px' => ['min' => 1, 'max' => 100]],
            'selectors' => [
                '{{WRAPPER}} .entry-title i' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}',
            ],
        ]);

        $this->start_controls_tabs('tabs_icon_style');

        $this->start_controls_tab(
            'tab_icon_normal',
            [
                'label' => esc_html__('Normal', 'makbet'),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__('Icon', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-content a i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color_bg',
            [
                'label'     => esc_html__('Background Icon', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-content a i' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_icon_hover',
            [
                'label' => esc_html__('Hover / Active', 'makbet'),
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label'     => esc_html__('Icon', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-content:hover a i, {{WRAPPER}} .service-content.active a i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color_hover_bg',
            [
                'label'     => esc_html__('Background Icon', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-content:hover a i, {{WRAPPER}} .service-content.active a i' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control('text_heading', [
            'label'     => esc_html__('Text', 'makbet'),
            'type'      => Controls_Manager::HEADING,
            'separator' => 'before',
        ]);

        $this->add_responsive_control('wrapper_padding_inner', [
            'label'     => esc_html__('Padding', 'makbet'),
            'type'      => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .service-content .entry-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_responsive_control('text_border_radius', [
            'label'     => esc_html__('Border Radius', 'makbet'),
            'type'      => Controls_Manager::DIMENSIONS,
            'selectors' => [
                '{{WRAPPER}} .service-content .entry-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        // Background tabs for entry-title
        $this->start_controls_tabs('tabs_text_background');

        $this->start_controls_tab('tab_text_background_normal', [
            'label' => esc_html__('Normal', 'makbet'),
        ]);

        $this->add_control('text_color', [
            'label'     => esc_html__('Text', 'makbet'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service-content a' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_group_control(\Elementor\Group_Control_Background::get_type(), [
            'name'     => 'text_background',
            'types'    => ['gradient'],
            'selector' => '{{WRAPPER}} .service-content .entry-title',
        ]);

        $this->end_controls_tab();

        $this->start_controls_tab('tab_text_background_hover', [
            'label' => esc_html__('Hover / Active', 'makbet'),
        ]);

        $this->add_control('text_color_hover', [
            'label'     => esc_html__('Text', 'makbet'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service-content:hover a, {{WRAPPER}} .service-content.active a' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_group_control(\Elementor\Group_Control_Background::get_type(), [
            'name'     => 'text_background_hover',
            'types'    => ['gradient'],
            'selector' => '{{WRAPPER}} .service-content:hover .entry-title, {{WRAPPER}} .service-content.active .entry-title',
        ]);

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }


    protected function get_post_service() {
        $query = new WP_Query([
            'posts_per_page' => -1,
            'post_type'      => 'pavo_service',
        ]);

        $options = [];

        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $options[get_the_ID()] = get_the_title();
            }
            wp_reset_postdata();
        }

        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $query    = $this->query_posts();

        if (!$query->have_posts()) {
            return;
        }

        $title = !empty($settings['more_services_title']) ? trim($settings['more_services_title']) : '';

        $this->add_render_attribute('wrapper', 'class', 'service-post-inner');
        if (!empty($title)) {
            $this->add_render_attribute('title', 'class', 'post-title');
        }
        ?>
        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <div class="service_posts">
                <?php if (!empty($title)) : ?>
                    <div <?php $this->print_render_attribute_string('title'); ?>>
                        <?php echo esc_html($title); ?>
                    </div>
                <?php endif; ?>

                <div class="service-post-item">
                    <?php
                    while ($query->have_posts()) {
                        $query->the_post();
                        $post_id    = get_the_ID();
                        $post_title = get_the_title();
                        $is_active  = ($post_id === get_queried_object_id()) ? ' active' : '';
                        ?>
                        <div class="service-content<?php echo esc_attr($is_active); ?>">
                            <a class="entry-title" href="<?php the_permalink(); ?>">
                                <?php echo esc_html($post_title); ?>
                                <i class="makbet-icon-arrow-right-normal"></i>
                            </a>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
        <?php
        wp_reset_postdata();
    }

    public function query_posts() {
        $settings = $this->get_settings();
        $args     = self::get_query_args($settings);
        return new WP_Query($args);
    }

    public static function get_query_args($settings) {
        $args = [
            'post_type'           => 'pavo_service',
            'ignore_sticky_posts' => true,
            'post_status'         => 'publish',
            'orderby'             => $settings['orderby'] ?? 'date',
            'order'               => $settings['order'] ?? 'DESC',
            'posts_per_page'      => $settings['posts_per_page'] ?? 6,
            'paged'               => max(1, get_query_var(is_front_page() ? 'page' : 'paged')),
        ];

        if (!empty($settings['service_single_image']) && $settings['slider_service_type'] === 'name') {
            $args['post__in']       = $settings['service_single_image'];
            $args['posts_per_page'] = -1;
        }

        return $args;
    }
}

$widgets_manager->register(new Makbet_Elementor_Service_Post());

