(function ($) {
    "use strict";

    // Edit button inside menu item
    var Makbet_Modal_Menu_Item = Backbone.View.extend({

        initialize: function (data) {
            this.model = new Backbone.Model(data);
            this.template = '<span class="makbet-edit-menu"><i class="fa fa-pencil"></i> Mega</span>';
            this.events = {
                'click': '_openModalHandler'
            };
        },

        render: function () {
            this.setElement(this.template);
            return this;
        },

        _openModalHandler: function () {
            window.makbet_menu_modal = new Makbet_Modal(this.model);
        }
    });

    // Modal popup for menu settings
    var Makbet_Modal = Backbone.View.extend({

        initialize: function (model) {
            this.model = model;

            this.events = {
                'click .close': '_closeHandler',
                'click .makbet-modal-overlay': '_closeHandler',
                'click #edit-megamenu': '_editSubmenuContentHandler',
                'submit #menu-edit-form': '_submitEditMenuForm',
                'change .toggle-select-setting select': 'toggle'
            };

            this.listenTo(this.model, 'destroy', this.remove);
            this.listenTo(this.model, 'change:is_loading change:edit_submenu', this._reRender.bind(this));

            this.render();
            this.delegateEvents();
        },

        toggle: function (e) {
            this._toggle(e.currentTarget);
        },

        _toggle: function (el) {
            const val = $(el).val();
            const target = $(el).data('target');
            if (!target) return;

            if (val == 1) {
                $(target).show();
                if ($(target).find('select').length) {
                    this._toggle($(target).find('select'));
                }
            } else {
                $(target).hide().find('select').val(0);
            }
        },

        render: function () {
            const that = this;
            let html = $('#tpl-makbet-menu-item-modal').html();
            this.template = _.template(html, { variable: 'data' })(this.model.toJSON());
            this.setElement(this.template);
            $('body').append(this.el);

            let data = this.model.toJSON();
            data.action = 'makbet_load_menu_data';
            data.nonce = makbet_memgamnu_params.nonces.load_menu_data;

            // Conditional display based on menu depth
            const isTop = typeof data.istop === 'boolean' ? data.istop : true;
            $(".submenu-setting, .submenu-width-setting").toggle(isTop);

            // Init toggles
            $(".toggle-select-setting select").each(function () {
                that._toggle(this);
            });

            // Load menu data via AJAX
            if (this.model.get('is_loading') === true) {
                $.post(makbet_memgamnu_params.ajaxurl, data)
                    .done(function (res) {
                        if (res.data) {
                            _.each(res.data, (value, key) => that.model.set(key, value));
                        }
                        if (res.status === true) {
                            that.model.set('is_loading', false);
                        }
                    });
            }

            this.initThirdpary();
            return this;
        },

        _submitEditMenuForm: function (e) {
            e.preventDefault();

            const that = this;
            const form = $('#menu-edit-form');
            const data = form.serializeArray();

            data.push({ name: 'action', value: 'makbet_update_menu_item_data' });

            $.ajax({
                url: makbet_memgamnu_params.ajaxurl,
                method: 'POST',
                data: data,
                beforeSend: function () {
                    form.find('.makbet-modal-footer button').prop('disabled', true);
                    form.find('button[type="submit"]').prepend('<i class="fa fa-spin fa-spinner"></i> ');
                }
            }).always(function () {
                form.find('.makbet-modal-footer button').prop('disabled', false);
            }).done(function (res) {
                if (res.status === true) {
                    that.model.destroy();
                }
                if (res.message) {
                    alert(res.message);
                }
            });

            return false;
        },

        _formatState: function (state) {
            if (!state.id) return state.text;

            return $(`<span><i class="${state.element.value.toLowerCase()}"></i> ${state.text}</span>`);
        },

        initThirdpary: function () {
            if (this.$('.icon-picker').length && $.fn.select2) {
                this.$('.icon-picker').select2({ templateResult: this._formatState });
            }

            if (this.$('.color-picker').length && $.fn.wpColorPicker) {
                this.$('.color-picker').wpColorPicker();
            }
        },

        _reRender: function () {
            this.$el.replaceWith(this.render().el);
        },

        _closeHandler: function (e) {
            e.preventDefault();
            this.model.destroy();
            return false;
        },

        _editSubmenuContentHandler: function () {
            this.model.set('edit_submenu', true);
        }
    });

    // Hover to show Mega Edit button
    $(document)
        .on('mouseenter', '#menu-to-edit .menu-item-handle', function () {
            const $item = $(this),
                $title = $item.find('.item-title'),
                $li = $item.closest('li'),
                id = parseInt($li.attr('id').replace('menu-item-', '')),
                isTop = $li.hasClass('menu-item-depth-0');

            $title.append(new Makbet_Modal_Menu_Item({
                menu_id: id,
                is_loading: true,
                istop: isTop ? 1 : 0
            }).render().el);
        })
        .on('mouseleave', '#menu-to-edit .menu-item-handle', function () {
            $(this).find('.item-title .makbet-edit-menu').remove();
        });

})(jQuery);