<div class="portfolio-inner">
    <div class="portfolio-post-thumbnail">
        <?php
        $video_file = get_post_meta(get_the_ID(), 'video_portfolio_file', true);
        $video_url  = get_post_meta(get_the_ID(), 'video_portfolio_url', true);
        $image_size = $this->get_settings_for_display('portfolio_image_size');

        if ($image_size === 'custom') {
            $custom_size = isset($settings['portfolio_image_custom_dimension']) && is_array($settings['portfolio_image_custom_dimension'])
                ? $settings['portfolio_image_custom_dimension']
                : ['width' => 300, 'height' => 300];
            $width       = !empty($custom_size['width']) ? $custom_size['width'] : 300;
            $height      = !empty($custom_size['height']) ? $custom_size['height'] : 300;
            $image_size  = [$width, $height];
        }

        if ($video_file) {
            echo '<video autoplay loop muted><source src="' . esc_url($video_file) . '" type="video/mp4"></video>';
        } elseif ($video_url) {
            $separator = strpos($video_url, '?') === false ? '?' : '&';
            $video_url .= $separator . 'autoplay=1&loop=1&mute=1';
            echo wp_oembed_get($video_url);
        } else {
            if (has_post_thumbnail()) {
                the_post_thumbnail($image_size, ['class' => 'featured-image']);
            }
        }
        ?>
    </div>

    <div class="portfolio-content">
        <div class="entry-top">
            <?php the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>
            <?php
            $excerpt = get_the_excerpt();
            if (!empty($excerpt)) : ?>
                <div class="excerpt-content"><?php echo wp_trim_words($excerpt, 35); ?></div>
            <?php endif; ?>
            <div class="elementor-button-link button-portfolio">
                <a class="elementor-button has-interacted" href="<?php the_permalink() ?>">
                <span class="elementor-button-content-wrapper">
                    <span class="elementor-button-text"><?php echo esc_html__('Learn more', 'makbet'); ?></span>
                    <span class="elementor-button-icon">
                        <i aria-hidden="true" class="makbet-icon- makbet-icon-arrow-right-btn"></i>
                    </span>
                </span>
                </a>
            </div>
        </div>
        <?php
        $portfolio_id = isset($portfolio['id']) ? $portfolio['id'] : get_the_ID();
        $categories   = get_the_terms($portfolio_id, 'pavo_portfolio_cat');
        if (!empty($categories) && !is_wp_error($categories)) :
            ?>
            <div class="portfolio-categories">
                <?php foreach ($categories as $cat) : ?>
                    <a href="<?php echo esc_url(get_term_link($cat)); ?>" class="portfolio-category">
                        <?php echo esc_html($cat->name); ?>
                    </a>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>